/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.sun.enterprise.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;

public class ListEjbsTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : ListEjbsTester --standalone <instance-name> <module-name> <app-name>";

    public ListEjbsTester() {
        super("Ejb Tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length < 3) {
            this.getWriter().println(ListEjbsTester.getUsageString());
            return -1;
        }
        AppServerInstance server = this.getServerInstance(params[0]);
        boolean isStandAlone = this.isStandAloneModule(params);
        DeployedEJBModuleComponentBean module = null;
        if (isStandAlone) {
            module = server.getDeployedEJBModule(params[2]);
        } else {
            DeployedApplicationComponentBean app = server.getDeployedApplication(params[2]);
            module = app.getEJBModule(params[1]);
        }
        this.listEjbs(module);
        this.listSessionBeans(module);
        this.listEntityBeans(module);
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private void listEjbs(DeployedEJBModuleComponentBean module) throws Exception {
        String[] ejbs = module.getEJBs();
        for (int i = 0; i < ejbs.length; ++i) {
            this.getWriter().println("Ejb[" + i + "] = " + ejbs[i]);
        }
    }

    private void listSessionBeans(DeployedEJBModuleComponentBean module) throws Exception {
        ServerModelIterator it = module.getSessionBeans();
        while (it.hasNext()) {
            this.getWriter().println("Session Bean = " + it.next());
        }
    }

    private void listEntityBeans(DeployedEJBModuleComponentBean module) throws Exception {
        ServerModelIterator it = module.getEntityBeans();
        while (it.hasNext()) {
            this.getWriter().println("Entity Bean = " + it.next());
        }
    }

    private boolean isStandAloneModule(String[] params) {
        boolean isStandAlone = false;
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].equalsIgnoreCase("--standalone")) continue;
            isStandAlone = true;
            break;
        }
        return isStandAlone;
    }

    public static void main(String[] args) throws Exception {
        new ListEjbsTester().execute(args);
    }
}

