/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.AuthDb;
import com.sun.enterprise.admin.servermodel.beans.HttpServiceComponentBean;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.beans.VirtualServer;
import com.sun.enterprise.admin.servermodel.beans.VirtualServerClass;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import java.util.HashMap;
import java.util.Map;

public class GetAuthDbAttributesTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : GetAuthDbAttributesTester <instance-name> <vsClassId> <virtualServerId> <authDbId>";

    public GetAuthDbAttributesTester() {
        super("AuthDB Tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 4) {
            this.getWriter().println(GetAuthDbAttributesTester.getUsageString());
            return -1;
        }
        AppServerInstance instance = this.getServerInstance(params[0]);
        HttpServiceComponentBean httpService = instance.getHttpService();
        VirtualServerClass vsClass = httpService.getVirtualServerClass(params[1]);
        VirtualServer vs = vsClass.getVirtualServer(params[2]);
        AuthDb authDb = vs.getAuthDb(params[3]);
        Map attributes = this.getAttributes(authDb);
        this.getWriter().println(attributes);
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private Map getAttributes(ServerComponent authDb) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>(5);
        Object value = authDb.getAttribute("id");
        attributes.put("id", value);
        value = authDb.getAttribute("database");
        attributes.put("database", value);
        value = authDb.getAttribute("basedn");
        attributes.put("basedn", value);
        value = authDb.getAttribute("certmaps");
        attributes.put("certmaps", value);
        return attributes;
    }

    public static void main(String[] args) throws Exception {
        new GetAuthDbAttributesTester().execute(args);
    }
}

