/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.comm.AdminConnectorClient;
import com.sun.enterprise.admin.comm.AuthenticationInfo;
import com.sun.enterprise.admin.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.common.JMXExceptionTranslator;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.common.exception.AFTargetNotFoundException;
import com.sun.enterprise.admin.common.exception.AccessViolationException;
import com.sun.enterprise.admin.common.exception.AttributeNotFoundException;
import com.sun.enterprise.admin.common.exception.InvalidAttributeValueException;
import com.sun.enterprise.admin.servermodel.context.AdminContext;
import com.sun.enterprise.admin.servermodel.context.AuthenticationContext;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.ExceptionUtil;
import com.sun.enterprise.admin.util.HostAndPort;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SOMRequestDispatcher {
    private boolean isLocal;
    private HostAndPort hostAndPort;
    private String user;
    private String password;

    public static SOMRequestDispatcher getDispatcher(ContextHolder ctxHolder) {
        SOMRequestDispatcher dispatcher = new SOMRequestDispatcher();
        if (ctxHolder != null) {
            AuthenticationContext authCtx;
            AdminContext adminCtx = ctxHolder.getAdminContext();
            if (adminCtx != null && !adminCtx.isLocal()) {
                dispatcher = new SOMRequestDispatcher(adminCtx.getHostAndPort());
            }
            if ((authCtx = ctxHolder.getAuthenticationContext()) != null) {
                String user = authCtx.getUser();
                String password = authCtx.getPassword();
                dispatcher.setClientCredentials(user, password);
            }
        }
        return dispatcher;
    }

    SOMRequestDispatcher() {
        this.isLocal = true;
    }

    SOMRequestDispatcher(HostAndPort hAndp) {
        ArgChecker.checkValid(hAndp, "hAndp");
        this.hostAndPort = hAndp;
        this.isLocal = false;
    }

    public Object invoke(ObjectName mbeanName, String operationName, Object[] params, String[] signature) throws AFException {
        Object returnValue = null;
        try {
            if (this.isLocal) {
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                returnValue = mbeanServer.invoke(mbeanName, operationName, params, signature);
            } else {
                HttpConnectorAddress address = this.getHttpConnectorAddress();
                AdminConnectorClient cc = new AdminConnectorClient(address);
                returnValue = cc.invoke(mbeanName, operationName, params, signature);
            }
        }
        catch (Exception e) {
            AFException afe = JMXExceptionTranslator.translate(e);
            throw afe;
        }
        return returnValue;
    }

    public Object getAttribute(ObjectName mbeanName, String attributeName) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        Object returnValue = null;
        try {
            if (this.isLocal) {
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                returnValue = mbeanServer.getAttribute(mbeanName, attributeName);
            } else {
                HttpConnectorAddress address = this.getHttpConnectorAddress();
                AdminConnectorClient cc = new AdminConnectorClient(address);
                returnValue = cc.getAttribute(mbeanName, attributeName);
            }
        }
        catch (Exception e) {
            AFException afe = JMXExceptionTranslator.translate(e);
            if (afe instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)afe;
            }
            if (afe instanceof AccessViolationException) {
                throw (AccessViolationException)afe;
            }
            if (afe instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)afe;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return returnValue;
    }

    public void setAttribute(ObjectName mbeanName, String attributeName, Object value) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        try {
            Attribute jmxAttribute = new Attribute(attributeName, value);
            if (this.isLocal) {
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                mbeanServer.setAttribute(mbeanName, jmxAttribute);
            } else {
                HttpConnectorAddress address = this.getHttpConnectorAddress();
                AdminConnectorClient cc = new AdminConnectorClient(address);
                cc.setAttribute(mbeanName, jmxAttribute);
            }
        }
        catch (Exception e) {
            AFException afe = JMXExceptionTranslator.translate(e);
            if (afe instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)afe;
            }
            if (afe instanceof AccessViolationException) {
                throw (AccessViolationException)afe;
            }
            if (afe instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)afe;
            }
            if (afe instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)afe;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
    }

    public AttributeList getAttributes(ObjectName mbeanName, String[] attributes) throws AFException {
        AttributeList values = null;
        try {
            if (this.isLocal) {
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                values = mbeanServer.getAttributes(mbeanName, attributes);
            } else {
                HttpConnectorAddress address = this.getHttpConnectorAddress();
                AdminConnectorClient cc = new AdminConnectorClient(address);
                values = cc.getAttributes(mbeanName, attributes);
            }
        }
        catch (Exception e) {
            AFException afe = JMXExceptionTranslator.translate(e);
            throw afe;
        }
        return values;
    }

    public AttributeList setAttributes(ObjectName mbeanName, AttributeList al) throws AFException {
        AttributeList values = null;
        try {
            if (this.isLocal) {
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                values = mbeanServer.setAttributes(mbeanName, al);
            } else {
                HttpConnectorAddress address = this.getHttpConnectorAddress();
                AdminConnectorClient cc = new AdminConnectorClient(address);
                values = cc.setAttributes(mbeanName, al);
            }
        }
        catch (Exception e) {
            AFException afe = JMXExceptionTranslator.translate(e);
            throw afe;
        }
        return values;
    }

    private final void setClientCredentials(String user, String password) {
        this.user = user;
        this.password = password;
    }

    private HttpConnectorAddress getHttpConnectorAddress() {
        HttpConnectorAddress address = new HttpConnectorAddress(this.hostAndPort);
        AuthenticationInfo authInfo = new AuthenticationInfo(this.user, this.password);
        address.setAuthenticationInfo(authInfo);
        return address;
    }
}

