/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.common.exception.AFOtherException;
import com.sun.enterprise.admin.servermodel.beans.DeployedServletComponentBean;
import com.sun.enterprise.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedWebModuleComponentController
implements Controller {
    private static final String LIST_SERVLETS = "getServlets";
    private DeployedWebModuleComponentBean deployedModule;

    public DeployedWebModuleComponentController(DeployedWebModuleComponentBean deployedModule) {
        this.deployedModule = deployedModule;
    }

    public ServerModelIterator getServlets() throws AFException {
        String[] servlets = (String[])this.invoke(LIST_SERVLETS, null, null);
        Vector<DeployedServletComponentBean> list = new Vector<DeployedServletComponentBean>();
        if (servlets != null && servlets.length > 0) {
            for (int i = 0; i < servlets.length; ++i) {
                ObjectName mbeanName = null;
                String instanceName = this.deployedModule.getInstanceName();
                String moduleName = this.deployedModule.getModuleName();
                boolean isStandAloneModule = this.deployedModule.isStandAlone();
                if (isStandAloneModule) {
                    mbeanName = ObjectNames.getServletObjectName(instanceName, moduleName, servlets[i]);
                } else {
                    String appName = this.deployedModule.getAppName();
                    mbeanName = ObjectNames.getServletObjectName(instanceName, appName, moduleName, servlets[i]);
                }
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("DeployedWebModuleComponentController.getServlets: mbeanName = " + mbeanName);
                DeployedServletComponentBean servlet = new DeployedServletComponentBean(mbeanName.toString(), servlets[i]);
                servlet.setContextHolder(this.deployedModule.getContextHolder());
                list.add(servlet);
            }
        }
        return new ServerModelIterator(list);
    }

    public ServerModelIterator getJSPs() throws AFException {
        throw new UnsupportedOperationException("To be implemented");
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws AFException {
        ObjectName mbeanName = null;
        Object retValue = null;
        try {
            mbeanName = new ObjectName(this.deployedModule.getIdentifier());
            ContextHolder ctxHolder = this.deployedModule.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (MalformedObjectNameException mone) {
            throw new AFOtherException(mone);
        }
        return retValue;
    }
}

