/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel;

import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.HostAndPort;
import java.util.HashMap;
import java.util.Map;

public class ServerInstanceManagerFactory {
    private static ServerInstanceManagerFactory factoryInstance = new ServerInstanceManagerFactory();
    private static ServerInstanceManager localServerInstanceManager;
    private Map simRepository = new HashMap(5);

    private ServerInstanceManagerFactory() {
    }

    public static ServerInstanceManagerFactory getFactory() {
        return factoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceManager getServerInstanceManager() {
        Class clazz = ServerInstanceManagerFactory.class;
        synchronized (clazz) {
            if (localServerInstanceManager == null) {
                localServerInstanceManager = new ServerInstanceManager();
            }
        }
        return localServerInstanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceManager getServerInstanceManager(HostAndPort hAndp) {
        ServerInstanceManager manager = null;
        ServerInstanceManagerFactory serverInstanceManagerFactory = this;
        synchronized (serverInstanceManagerFactory) {
            manager = (ServerInstanceManager)this.simRepository.get(hAndp);
            if (manager == null) {
                manager = new ServerInstanceManager(hAndp);
                HostAndPort key = new HostAndPort(hAndp);
                this.simRepository.put(key, manager);
            }
        }
        return manager;
    }

    public ServerInstanceManager getServerInstanceManager(HostAndPort hAndp, String user, String password) {
        ServerInstanceManager sim = this.getServerInstanceManager(hAndp);
        Assert.assertit(sim != null, "null value returned");
        sim.setAuthenticationContext(user, password);
        return sim;
    }
}

