/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.meta;

import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanEasyConfig {
    private static StringManager localStrings = StringManager.getManager(MBeanEasyConfig.class);
    static final String DESCR_LINE_DELIMITER = ",";
    static final String STRINGSOUREC_FILENAME = "MBeanConfig.properties";
    static final String EXCEPTION_LINE_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_description_line");
    static final String EXCEPTION_WRONG_LINE_FORMAT = localStrings.getString("admin.server.core.mbean.meta.wrong_fields_number_in_description_line");
    static final String EXCEPTION_NAME_FLD_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_name_in_description_line");
    static final String EXCEPTION_CLASSNAME_FLD_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_classname_in_description_line");
    static final String EXCEPTION_UNKNOWN_RWTYPE = localStrings.getString("admin.server.core.mbean.meta.unknown_rw_type_in_description_line");
    static final String EXCEPTION_UNKNOWN_IMPACT_TYPE = localStrings.getString("admin.server.core.mbean.meta.unknown_impact_type_in_description");
    static final String EXCEPTION_OPER_NOT_FOUND = localStrings.getString("admin.server.core.mbean.meta.unfound_operation_in_bean_class");
    static final String EXCEPTION_WRONG_PARAM_FORMAT = localStrings.getString("admin.server.core.mbean.meta.wrong_operation_parameter_in_description");
    static final String EXCEPTION_WRONG_PARAM_DIM = localStrings.getString("admin.server.core.mbean.meta.wrong_operation_parameter_dimension_in_description");
    static final String EXCEPTION_WRONG_PARAM_CLASS = localStrings.getString("admin.server.core.mbean.meta.wrong_parameter_attribute_class_in_description");
    static final String EXCEPTION_EMPTY_PARAM_TYPE = localStrings.getString("admin.server.core.mbean.meta.empty_parameter_attribute_type_in_description_line");
    static final String TYPE_INFO = "INFO";
    static final String TYPE_ACTION = "ACTION";
    static final String TYPE_ACTION_INFO = "ACTION_INFO";
    static final String TYPE_UNKNOWN = "UNKNOWN";
    private MBeanAttributeInfo[] m_attrs = new MBeanAttributeInfo[0];
    private MBeanConstructorInfo[] m_cstrs = new MBeanConstructorInfo[0];
    private MBeanOperationInfo[] m_opers = new MBeanOperationInfo[0];
    private MBeanNotificationInfo[] m_notfs = new MBeanNotificationInfo[0];
    private Class m_beanClass = null;
    private String m_descr = null;
    static Object[][] convTable = new Object[][]{{"byte", "B", Byte.TYPE, "java.lang.Byte"}, {"char", "C", Character.TYPE, "java.lang.Character"}, {"double", "D", Double.TYPE, "java.lang.Double"}, {"float", "F", Float.TYPE, "java.lang.Float"}, {"int", "I", Integer.TYPE, "java.lang.Integer"}, {"long", "J", Long.TYPE, "java.lang.Long"}, {"short", "S", Short.TYPE, "java.lang.Short"}, {"boolean", "Z", Boolean.TYPE, "java.lang.Boolean"}, {"void", "V", Void.TYPE, "?"}};

    public MBeanEasyConfig(Class configuringMBeanClass, String[] attrDescr, String[] operDescr, String descr) throws MBeanConfigException {
        this.m_beanClass = configuringMBeanClass;
        this.m_descr = descr;
        if (this.m_descr == null || this.m_descr.length() == 0) {
            this.m_descr = "" + MBeanEasyConfig.getPureClassName(configuringMBeanClass) + ".mbean";
        }
        this.m_attrs = MBeanEasyConfig.createAttributesInfo(this.m_beanClass, attrDescr);
        this.m_cstrs = MBeanEasyConfig.createConstructorsInfo(this.m_beanClass, null);
        this.m_opers = MBeanEasyConfig.createOperationsInfo(this.m_beanClass, operDescr);
    }

    public static MBeanAttributeInfo[] createAttributesInfo(Class configuringMBeanClass, String[] attrDescr) throws MBeanConfigException {
        if (attrDescr == null || attrDescr.length < 1) {
            return new MBeanAttributeInfo[0];
        }
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[attrDescr.length];
        String beanName = MBeanEasyConfig.getPureClassName(configuringMBeanClass);
        for (int i = 0; i < attrDescr.length; ++i) {
            infos[i] = MBeanEasyConfig.parseAttributeDescrLine(beanName, attrDescr[i]);
        }
        return infos;
    }

    public static MBeanOperationInfo[] createOperationsInfo(Class configuringMBeanClass, String[] operDescr) throws MBeanConfigException {
        if (configuringMBeanClass == null) {
            return new MBeanOperationInfo[0];
        }
        if (operDescr == null || operDescr.length < 1) {
            return new MBeanOperationInfo[0];
        }
        ArrayList<MBeanOperationInfo> arr = new ArrayList<MBeanOperationInfo>();
        for (int i = 0; i < operDescr.length; ++i) {
            MBeanOperationInfo[] overloads = MBeanEasyConfig.parseOperationDescrLine(configuringMBeanClass, operDescr[i]);
            for (int j = 0; j < overloads.length; ++j) {
                arr.add(overloads[j]);
            }
        }
        MBeanOperationInfo[] infos = new MBeanOperationInfo[arr.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = (MBeanOperationInfo)arr.get(i);
        }
        return infos;
    }

    public static MBeanConstructorInfo[] createConstructorsInfo(Class configuringMBeanClass, String constructorDescr) {
        if (configuringMBeanClass == null) {
            return new MBeanConstructorInfo[0];
        }
        if (constructorDescr == null) {
            String nameDescr = MBeanEasyConfig.getPureClassName(configuringMBeanClass) + ".constructor";
            constructorDescr = MBeanEasyConfig.getResourceString(nameDescr, nameDescr);
        }
        Constructor<?>[] ctrs = configuringMBeanClass.getConstructors();
        MBeanConstructorInfo[] infos = new MBeanConstructorInfo[ctrs.length];
        for (int i = 0; i < ctrs.length; ++i) {
            infos[i] = new MBeanConstructorInfo(constructorDescr, ctrs[i]);
        }
        return infos;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.m_beanClass == null) {
            return null;
        }
        return new MBeanInfo(this.m_beanClass.getName(), this.m_descr, this.m_attrs, this.m_cstrs, this.m_opers, this.m_notfs);
    }

    public void setMBeanDescription(String beanDescription) {
        this.m_descr = beanDescription;
    }

    public void setAttributesInfo(MBeanAttributeInfo[] attributesInfo) {
        if (attributesInfo == null) {
            attributesInfo = new MBeanAttributeInfo[]{};
        }
        this.m_attrs = attributesInfo;
    }

    public void setOperationsInfo(MBeanConstructorInfo[] constructorInfo) {
        if (constructorInfo == null) {
            constructorInfo = new MBeanConstructorInfo[]{};
        }
        this.m_cstrs = constructorInfo;
    }

    public void setOperationsInfo(MBeanOperationInfo[] operationsInfo) {
        if (operationsInfo == null) {
            operationsInfo = new MBeanOperationInfo[]{};
        }
        this.m_opers = operationsInfo;
    }

    public void setNotificationsInfo(MBeanNotificationInfo[] notificationsInfo) {
        if (notificationsInfo == null) {
            notificationsInfo = new MBeanNotificationInfo[]{};
        }
        this.m_notfs = notificationsInfo;
    }

    public static Object convertStringValueToProperType(String value, String targetType) throws MBeanConfigException {
        if (value == null) {
            return null;
        }
        try {
            Class cl = MBeanEasyConfig.getPrimitiveClass(targetType);
            if (cl != null || (cl = MBeanEasyConfig.getRelatedPrimitiveClass(targetType)) != null) {
                if (cl == Byte.TYPE) {
                    return new Byte(value);
                }
                if (cl == Character.TYPE) {
                    return new Character(value.charAt(0));
                }
                if (cl == Double.TYPE) {
                    return new Double(value);
                }
                if (cl == Float.TYPE) {
                    return new Float(value);
                }
                if (cl == Integer.TYPE) {
                    return new Integer(value);
                }
                if (cl == Long.TYPE) {
                    return new Long(value);
                }
                if (cl == Short.TYPE) {
                    return new Short(value);
                }
                if (cl == Boolean.TYPE) {
                    return new Boolean(value);
                }
            }
        }
        catch (IllegalArgumentException e) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.convertstringvaluetopropertype_wrong_argument_type", e.getMessage());
            throw new MBeanConfigException(msg);
        }
        return value;
    }

    private static MBeanAttributeInfo parseAttributeDescrLine(String beanName, String descrLine) throws MBeanConfigException {
        boolean bReadable = false;
        boolean bWritable = false;
        if (descrLine == null) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_exception_line_empty", EXCEPTION_LINE_EMPTY);
            throw new MBeanConfigException(msg);
        }
        String[] flds = MBeanEasyConfig.getLineFields(descrLine, 4);
        if (flds.length < 3 || flds.length > 4) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_LINE_FORMAT, descrLine);
            throw new MBeanConfigException(msg);
        }
        String name = flds[0];
        if (name.length() == 0) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_NAME_FLD_EMPTY, descrLine);
            throw new MBeanConfigException(msg);
        }
        String className = flds[1];
        if (className.length() == 0) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_CLASSNAME_FLD_EMPTY, descrLine);
            throw new MBeanConfigException(msg);
        }
        className = MBeanEasyConfig.convertTypeToSignatureClass(className).getName();
        String rwType = flds[2];
        if (rwType.equals("R")) {
            bReadable = true;
        } else if (rwType.equals("W")) {
            bWritable = true;
        } else if (rwType.equals("RW") || rwType.equals("WR")) {
            bWritable = true;
            bReadable = true;
        } else {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_UNKNOWN_RWTYPE, descrLine);
            throw new MBeanConfigException(msg);
        }
        String defaultName = beanName + "." + name + ".attribute";
        String descr = flds.length < 4 || flds[3].length() == 0 ? MBeanEasyConfig.getResourceString(defaultName, defaultName) : MBeanEasyConfig.getResourceString(flds[3], defaultName);
        return new MBeanAttributeInfo(name, className, descr, bReadable, bWritable, false);
    }

    /*
     * WARNING - void declaration
     */
    private static MBeanOperationInfo[] parseOperationDescrLine(Class configuringMBeanClass, String descrLine) throws MBeanConfigException {
        void var4_15;
        Method method;
        int type;
        if (descrLine == null) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_exception_line_empty", EXCEPTION_LINE_EMPTY);
            throw new MBeanConfigException(msg);
        }
        int idx1 = descrLine.indexOf(40);
        if (idx1 <= 0 || idx1 == descrLine.length() - 1) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_PARAM_FORMAT, descrLine);
            throw new MBeanConfigException(msg);
        }
        String name = descrLine.substring(0, idx1).trim();
        if (name.length() == 0) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_NAME_FLD_EMPTY, descrLine);
            throw new MBeanConfigException(msg);
        }
        int idx2 = descrLine.indexOf(41, idx1 + 1);
        if (idx2 <= 0) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_PARAM_FORMAT, descrLine);
            throw new MBeanConfigException(msg);
        }
        Object[] params = MBeanEasyConfig.decomposeParametersDescription(descrLine.substring(idx1 + 1, idx2));
        String[] flds = MBeanEasyConfig.getLineFields(descrLine.substring(idx2), 3);
        if (flds.length < 2) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_LINE_FORMAT, descrLine);
            throw new MBeanConfigException(msg);
        }
        String typeName = flds[1];
        if (typeName.equals(TYPE_INFO)) {
            type = 0;
        } else if (typeName.equals(TYPE_ACTION)) {
            type = 1;
        } else if (typeName.equals(TYPE_ACTION_INFO)) {
            type = 2;
        } else if (typeName.equals(TYPE_UNKNOWN)) {
            type = 3;
        } else {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_UNKNOWN_IMPACT_TYPE, descrLine);
            throw new MBeanConfigException(msg);
        }
        String beanName = MBeanEasyConfig.getPureClassName(configuringMBeanClass);
        String defaultName = beanName + "." + name + ".operation";
        String descr = flds.length < 3 || flds[2].length() == 0 ? MBeanEasyConfig.getResourceString(defaultName, defaultName) : MBeanEasyConfig.getResourceString(flds[2], defaultName);
        Class[] signature = new Class[params.length / 3];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = (Class)params[i * 3];
        }
        try {
            method = configuringMBeanClass.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.parseoperationdescrline_wrong_exception_format", EXCEPTION_OPER_NOT_FOUND, descrLine);
            throw new MBeanConfigException(msg);
        }
        MBeanParameterInfo[] infos = new MBeanParameterInfo[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            String pDescr;
            String pName = (String)params[i * 3 + 1];
            if (pName == null) {
                pName = "";
            }
            if ((pDescr = (String)params[i * 3 + 2]) == null) {
                pDescr = pName.length() > 0 ? beanName + "." + name + "." + pName + ".parameter" : "";
            }
            infos[i] = new MBeanParameterInfo(pName, signature[i].getName(), pDescr);
        }
        return new MBeanOperationInfo[]{new MBeanOperationInfo(name, descr, infos, method.getReturnType().getName(), (int)var4_15)};
    }

    private static String[] getLineFields(String line, int nMax) {
        ArrayList<String> flds = new ArrayList<String>();
        int idx1 = 0;
        int idx2 = 100;
        if (line == null || line.length() == 0 || nMax == 0) {
            return null;
        }
        while (idx2 > 0 && nMax > flds.size() && idx1 < line.length()) {
            idx2 = line.indexOf(DESCR_LINE_DELIMITER, idx1);
            if (idx2 < 0) {
                flds.add(line.substring(idx1).trim());
            } else {
                flds.add(line.substring(idx1, idx2).trim());
            }
            idx1 = idx2 + 1;
            if (idx2 != line.length()) continue;
            flds.add("");
        }
        String[] strs = new String[flds.size()];
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = (String)flds.get(i);
        }
        return strs;
    }

    static String getResourceString(String resourceID, String nullReplacer) {
        return resourceID;
    }

    private static Method[] getMethodsForName(Class configuringMBeanClass, String name) {
        ArrayList<Method> overloads = new ArrayList<Method>();
        Method[] all = configuringMBeanClass.getMethods();
        if (all == null) {
            return null;
        }
        for (int i = 0; i < all.length; ++i) {
            if (!name.equals(all[i].getName())) continue;
            overloads.add(all[i]);
        }
        if (overloads.size() == 0) {
            return null;
        }
        Method[] ret = new Method[overloads.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Method)overloads.get(i);
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    private static Class convertTypeToSignatureClass(String type) throws MBeanConfigException {
        block11: {
            int idx = (type = type.trim()).indexOf("[");
            if (idx == 0 || type.length() == 0) {
                String msg = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_EMPTY_PARAM_TYPE, type);
                throw new MBeanConfigException(msg);
            }
            if (idx > 0) {
                String name = type.substring(0, idx).trim();
                if (name.length() == 0) {
                    String msg = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_EMPTY_PARAM_TYPE, type);
                    throw new MBeanConfigException(msg);
                }
                String code = MBeanEasyConfig.getPrimitiveCode(name);
                if (code == null) {
                    if (name.indexOf(46) < 0) {
                        name = "java.lang." + name;
                    }
                    return Class.forName(MBeanEasyConfig.getArrayPrefix(type, idx) + "L" + name + ";");
                }
                return Class.forName(MBeanEasyConfig.getArrayPrefix(type, idx) + code);
            }
            Class cl = MBeanEasyConfig.getPrimitiveClass(type);
            if (cl == null) break block11;
            return cl;
            {
                catch (ClassNotFoundException e) {
                    String msg = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_WRONG_PARAM_CLASS, type);
                    throw new MBeanConfigException(msg);
                }
            }
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            if (type.indexOf(46) > 0) {
                String msg = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_WRONG_PARAM_CLASS, type);
                throw new MBeanConfigException(msg);
            }
            return Class.forName("java.lang." + type);
        }
    }

    private static String getArrayPrefix(String line, int idx) throws MBeanConfigException {
        String pref = "";
        int dimCheck = 0;
        while (idx < line.length()) {
            if (line.charAt(idx) == '[') {
                pref = pref + "[";
            } else if (line.charAt(idx) == ']') {
                ++dimCheck;
            }
            ++idx;
        }
        if (pref.length() != dimCheck) {
            String msg = localStrings.getString("admin.server.core.mbean.meta.getarrayprefix_wrong_exception_format", EXCEPTION_WRONG_PARAM_DIM, line);
            throw new MBeanConfigException(msg);
        }
        return pref;
    }

    private static Object findConvTableElemByType(String type, int idx) {
        for (int i = 0; i < convTable.length; ++i) {
            if (!type.equals((String)convTable[i][0])) continue;
            return convTable[i][idx];
        }
        return null;
    }

    private static Object findConvTableElemByAssoClassName(String assoClass, int idx) {
        for (int i = 0; i < convTable.length; ++i) {
            if (!assoClass.equals((String)convTable[i][3])) continue;
            return convTable[i][idx];
        }
        return null;
    }

    private static String getPrimitiveCode(String type) {
        return (String)MBeanEasyConfig.findConvTableElemByType(type, 1);
    }

    private static Class getPrimitiveClass(String type) {
        return (Class)MBeanEasyConfig.findConvTableElemByType(type, 2);
    }

    private static Class getRelatedPrimitiveClass(String className) {
        return (Class)MBeanEasyConfig.findConvTableElemByAssoClassName(className, 2);
    }

    private static Object[] decomposeParametersDescription(String line) throws MBeanConfigException {
        ArrayList<Object> flds = new ArrayList<Object>();
        int idx1 = 0;
        int idx2 = 100;
        int len = (line = line.trim()).length();
        if (len == 0) {
            return new Object[0];
        }
        while (idx1 < len) {
            int parmEnd = line.indexOf(44, idx1);
            if (parmEnd < 0) {
                parmEnd = len;
            }
            if ((idx2 = line.indexOf(32, idx1)) > parmEnd) {
                idx2 = parmEnd;
            }
            if (idx2 < 0) {
                flds.add(MBeanEasyConfig.convertTypeToSignatureClass(line.substring(idx1)));
                idx2 = parmEnd;
            } else {
                flds.add(MBeanEasyConfig.convertTypeToSignatureClass(line.substring(idx1, idx2)));
            }
            for (idx1 = idx2 + 1; idx1 < parmEnd && line.charAt(idx1) == ' '; ++idx1) {
            }
            if (idx1 >= parmEnd) {
                flds.add(null);
                flds.add(null);
                if (idx1 == parmEnd) {
                    ++idx1;
                }
                while (idx1 < len && line.charAt(idx1) == ' ') {
                    ++idx1;
                }
                continue;
            }
            idx2 = line.indexOf(32, idx1);
            if (idx2 > parmEnd) {
                idx2 = parmEnd;
            }
            if (idx2 < 0) {
                flds.add(line.substring(idx1).trim());
                idx2 = parmEnd;
            } else {
                flds.add(line.substring(idx1, idx2).trim());
            }
            for (idx1 = idx2 + 1; idx1 < parmEnd && line.charAt(idx1) == ' '; ++idx1) {
            }
            if (idx1 >= parmEnd) {
                flds.add(null);
                if (idx1 == parmEnd) {
                    ++idx1;
                }
                while (idx1 < len && line.charAt(idx1) == ' ') {
                    ++idx1;
                }
                continue;
            }
            idx2 = line.indexOf(44, idx1);
            if (idx2 < 0) {
                flds.add(line.substring(idx1).trim());
                idx2 = len;
            } else {
                flds.add(line.substring(idx1, idx2).trim());
            }
            for (idx1 = idx2 + 1; idx1 < len && line.charAt(idx1) == ' '; ++idx1) {
            }
        }
        Object[] strs = new Object[flds.size()];
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = flds.get(i);
        }
        return strs;
    }

    private static String getPureClassName(Class configuringMBeanClass) {
        if (configuringMBeanClass == null) {
            return null;
        }
        String className = configuringMBeanClass.getName();
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(idx + 1);
        }
        return className;
    }
}

