/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.exception.ControlException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.mbean.config.AdminEntityResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ModulesXMLHelper {
    public static final int MODULE_TYPE_EJB = 1;
    public static final int MODULE_TYPE_WEB = 2;
    public static final int MODULE_TYPE_JAVA = 4;
    public static final int MODULE_TYPE_ALL = 255;
    public static final int EJB_TYPE_SESSION = 1;
    public static final int EJB_TYPE_ENTITY = 2;
    public static final int EJB_TYPE_MSGDRIVEN = 4;
    public static final int EJB_TYPE_ALL = 255;
    static final String APPLICATION_TAG = "application";
    static final String MODULE_TAG = "module";
    static final String EJB_MODULE_TAG = "ejb";
    static final String WEB_MODULE_TAG = "web";
    static final String WEB_URI_TAG = "web-uri";
    static final String CONTEXT_ROOT_TAG = "context-root";
    static final String JAVA_MODULE_TAG = "java";
    static final String ENTERPRISE_BEANS_TAG = "enterprise-beans";
    static final String SESSION_TAG = "session";
    static final String ENTITY_TAG = "entity";
    static final String MESSAGE_DRIVEN_TAG = "message-driven";
    static final String EJB_NAME_TAG = "ejb-name";
    static final String SERVLET_TAG = "servlet";
    static final String SERVLET_NAME_TAG = "servlet-name";
    static final Logger sLogger = AdminService.sLogger;
    Document document;

    public ModulesXMLHelper(String fileName) throws Exception {
        this.document = this.createDocument(fileName);
    }

    public static String[] getModulesFromApplicationLocation(String appLocation, int moduleType) throws Exception {
        ModulesXMLHelper myObj = new ModulesXMLHelper(appLocation + "/META-INF/application.xml");
        return myObj.getModules(moduleType);
    }

    public static boolean isModuleExists(String appLocation, String moduleName, int moduleType) throws Exception {
        String[] strs = ModulesXMLHelper.getModulesFromApplicationLocation(appLocation, moduleType);
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                if (!moduleName.equals(strs[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getEnterpriseBeansForEjbModule(String location, String ejbModuleName, int ejbTypes) throws Exception {
        if (ejbModuleName != null) {
            if (ejbModuleName.endsWith(".jar")) {
                ejbModuleName = ejbModuleName.substring(0, ejbModuleName.length() - 4);
            }
            location = location + "/" + ejbModuleName + "_jar";
        }
        ModulesXMLHelper myObj = new ModulesXMLHelper(location + "/META-INF/ejb-jar.xml");
        return myObj.getEnterpriseBeans(ejbTypes);
    }

    public static String[] getServletsForWebModule(String location, String webModuleName) throws Exception {
        if (webModuleName != null) {
            if (webModuleName.endsWith(".war")) {
                webModuleName = webModuleName.substring(0, webModuleName.length() - 4);
            }
            location = location + "/" + webModuleName + "_war";
        }
        ModulesXMLHelper myObj = new ModulesXMLHelper(location + "/WEB-INF/web.xml");
        return myObj.getServlets();
    }

    public String[] getModules(int moduleType) throws Exception {
        if (this.document != null) {
            ArrayList arr = this.findChildNodesByName(this.document.getDocumentElement(), MODULE_TAG);
            String[] strs = new String[arr.size()];
            int noNullCount = 0;
            for (int i = 0; i < arr.size(); ++i) {
                String str = this.getModuleNameFromNode((Node)arr.get(i), moduleType);
                if (str == null) continue;
                strs[noNullCount++] = str;
            }
            String[] res = new String[noNullCount];
            for (int i = 0; i < noNullCount; ++i) {
                res[i] = strs[i];
            }
            return res;
        }
        return new String[0];
    }

    public String[] getEnterpriseBeans(int ejbType) throws Exception {
        Node beansListNode;
        if (this.document != null && (beansListNode = this.findChildNodeByName(this.document.getDocumentElement(), ENTERPRISE_BEANS_TAG)) != null) {
            ArrayList resList = new ArrayList();
            if ((ejbType & 1) != 0) {
                this.addToListEjbNames(resList, beansListNode, SESSION_TAG);
            }
            if ((ejbType & 1) != 0) {
                this.addToListEjbNames(resList, beansListNode, ENTITY_TAG);
            }
            if ((ejbType & 1) != 0) {
                this.addToListEjbNames(resList, beansListNode, MESSAGE_DRIVEN_TAG);
            }
            String[] res = new String[resList.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (String)resList.get(i);
            }
            return res;
        }
        return new String[0];
    }

    public String[] getServlets() throws Exception {
        if (this.document != null) {
            ArrayList arr = this.findChildNodesByName(this.document.getDocumentElement(), SERVLET_TAG);
            String[] res = new String[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                Node nameNode = this.findChildNodeByName((Node)arr.get(i), SERVLET_NAME_TAG);
                res[i] = this.getTextForNode(nameNode);
            }
            return res;
        }
        return new String[0];
    }

    private void addToListEjbNames(ArrayList listToAdd, Node listNode, String tag) {
        ArrayList arr = this.findChildNodesByName(listNode, tag);
        for (int i = 0; i < arr.size(); ++i) {
            Node nameNode = this.findChildNodeByName((Node)arr.get(i), EJB_NAME_TAG);
            listToAdd.add(this.getTextForNode(nameNode));
        }
    }

    private Document createDocument(String fileName) throws Exception {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            AdminEntityResolver resolver = new AdminEntityResolver();
            builder.setEntityResolver(resolver);
            document = builder.parse(new File(fileName));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            sLogger.throwing(this.getClass().getName(), "createDocument", x);
            throw new ControlException(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            sLogger.throwing(this.getClass().getName(), "createDocument", pce);
            throw new ControlException(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            sLogger.throwing(this.getClass().getName(), "createDocument", ioe);
            throw new ControlException(ioe.getLocalizedMessage());
        }
        return document;
    }

    private ArrayList findChildNodesByName(Node node, String name) {
        ArrayList<Node> resNodes = new ArrayList<Node>();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equalsIgnoreCase(name)) continue;
            resNodes.add(node);
        }
        return resNodes;
    }

    private Node findChildNodeByName(Node node, String name) {
        ArrayList resNodes = new ArrayList();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    private String getModuleNameFromNode(Node node, int moduleType) {
        ArrayList arr;
        if ((moduleType & 1) != 0 && (arr = this.findChildNodesByName(node, EJB_MODULE_TAG)).size() > 0) {
            return this.getTextForNode((Node)arr.get(0));
        }
        if ((moduleType & 4) != 0 && (arr = this.findChildNodesByName(node, JAVA_MODULE_TAG)).size() > 0) {
            return this.getTextForNode((Node)arr.get(0));
        }
        if ((moduleType & 2) != 0 && (arr = this.findChildNodesByName(node, WEB_MODULE_TAG)).size() > 0 && (arr = this.findChildNodesByName(node = (Node)arr.get(0), WEB_URI_TAG)) != null && arr.size() > 0) {
            String desc = this.getTextForNode((Node)arr.get(0));
            return desc;
        }
        return null;
    }

    private String getTextForNode(Node node) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }
}

