/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.EntityStatus;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.J2EEWebModuleException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.ModulesXMLHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.instance.InstanceEnvironment;

public class ManagedStandaloneJ2EEWebModule
extends ConfigMBeanBase
implements ConfigAttributeName.StandaloneWebModule {
    private int state = 1;
    private static final String[][] MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"contextRoot", "@" + ServerTags.CONTEXT_ROOT}, {"location", "@" + ServerTags.LOCATION}, {"virtualServers", "@" + ServerTags.VIRTUAL_SERVERS}, {"description", "@" + PSEUDO_ATTR_DESCRIPTION}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "contextRoot, String,     RW", "location, String,     RW", "virtualServers, String,     RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getStatus(),   INFO", "enable(),      ACTION", "disable(),     ACTION", "start(),       ACTION", "stop(),        ACTION", "getState(),    INFO"};

    public ManagedStandaloneJ2EEWebModule() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedStandaloneJ2EEWebModule(String instanceName, String moduleName) throws MBeanConfigException {
        this();
        this.initialize("standalone-web-module", new String[]{instanceName, moduleName});
    }

    public EntityStatus getStatus() throws J2EEWebModuleException {
        EntityStatus status = null;
        try {
            boolean isModuleEnabled = true;
            status = new EntityStatus();
            if (isModuleEnabled) {
                status.setEnabled();
            } else {
                status.setDisabled();
            }
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getStatus", e);
            throw new J2EEWebModuleException(e.getMessage());
        }
        return status;
    }

    public void disable() throws J2EEWebModuleException {
    }

    public void stop() throws J2EEWebModuleException {
        this.state = 2;
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "disable");
            this.state = 3;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "stop", e);
            this.state = 4;
            throw new J2EEWebModuleException(e.getMessage());
        }
    }

    public Integer getState() throws J2EEWebModuleException {
        return new Integer(this.state);
    }

    public void enable() throws J2EEWebModuleException {
    }

    public void start() throws J2EEWebModuleException {
        this.state = 0;
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "enable");
            this.state = 1;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "start", e);
            this.state = 4;
            throw new J2EEWebModuleException(e.getMessage());
        }
    }

    public String[] getServlets() throws J2EEWebModuleException {
        try {
            String location = (String)this.getAttribute("location");
            return ModulesXMLHelper.getServletsForWebModule(location, null);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getServlets", e);
            throw new J2EEWebModuleException(e.getMessage());
        }
    }

    private void multicastAdminEvent(String entityName, String actionCode) throws J2EEWebModuleException {
        String instanceName = super.getServerInstanceName();
        InstanceEnvironment instEnv = new InstanceEnvironment(instanceName);
        ModuleDeployEvent event = new ModuleDeployEvent(instanceName, entityName, "web", actionCode);
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(instanceName);
        if (serverInstancePinger.getInstanceStatusCode() != 0) {
            return;
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        if (!"success".equals(multicastResult.getResultCode())) {
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
    }
}

