/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.storage;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedAdminServerInstance;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedServerInstance;
import com.sun.enterprise.admin.server.core.mbean.config.ServerController;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class MBeanManufacturer {
    private ObjectName mObjectName = null;
    private Object mConfigBean = null;
    private AdminContext mAdminContext;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager localStrings = StringManager.getManager(MBeanManufacturer.class);

    public MBeanManufacturer(ObjectName oName, Object configBean) {
        if (oName == null || configBean == null) {
            String msg = localStrings.getString("admin.server.core.jmx.storage.null_object_name_or_config_bean");
            throw new IllegalArgumentException(msg);
        }
        this.mObjectName = oName;
        this.mConfigBean = configBean;
    }

    public void setAdminContext(AdminContext ctx) {
        this.mAdminContext = ctx;
    }

    public Object createMBeanInstance() {
        Object mbeanInstance = null;
        String instanceName = ApplicationServer.getServerContext().getInstanceName();
        if (this.mConfigBean instanceof MBeanRegistryEntry) {
            try {
                ConfigContext configContext;
                if (this.mAdminContext != null) {
                    configContext = this.mAdminContext.getAdminConfigContext();
                } else {
                    InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceName);
                    String fileUrl = instanceEnvironment.getBackupConfigFilePath();
                    configContext = ConfigFactory.createConfigContext(fileUrl);
                }
                return ((MBeanRegistryEntry)this.mConfigBean).instantiateMBean(this.mObjectName, null, configContext);
            }
            catch (Exception e) {
                return null;
            }
        }
        String type = ObjectNameHelper.getType(this.mObjectName);
        Level logLevel = Level.SEVERE;
        try {
            if (type.equals("controller")) {
                mbeanInstance = new ServerController(this.mAdminContext);
            } else if (type.equals("configurator")) {
                mbeanInstance = new GenericConfigurator();
            } else if (type.equals("server-instance")) {
                mbeanInstance = this.createServerInstanceMBean(instanceName);
            } else {
                logLevel = Level.FINE;
                mbeanInstance = this.createGenericConfigMBean(this.mObjectName);
            }
        }
        catch (Exception e) {
            _logger.log(logLevel, "mbean.config.admin.create_mbean_instance_failed", e);
        }
        return mbeanInstance;
    }

    private ManagedServerInstance createServerInstanceMBean(String instanceName) throws Exception {
        Server server = (Server)this.mConfigBean;
        ConfigContext ctx = server.getConfigContext();
        Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(ctx, ServerXPathHelper.XPATH_CONFIG);
        HttpService https = config.getHttpService();
        HttpListener[] hlArray = https.getHttpListener();
        HttpListener ls = hlArray[0];
        for (int i = 0; i < hlArray.length; ++i) {
            if (!hlArray[i].isEnabled()) continue;
            ls = hlArray[i];
            break;
        }
        String port = new PropertyResolver(ctx, instanceName).resolve(ls.getPort());
        int intPort = Integer.parseInt(port);
        HostAndPort hp = new HostAndPort("localhost", intPort);
        return new ManagedServerInstance(instanceName, hp, false, this.mAdminContext);
    }

    private ManagedAdminServerInstance createAdminServerInstance() throws Exception {
        return new ManagedAdminServerInstance();
    }

    private Object createGenericConfigMBean(ObjectName objectName) throws MBeanConfigException {
        ConfigMBeanNamingInfo mbeanInfo = new ConfigMBeanNamingInfo(objectName);
        mbeanInfo.setAdminContext(this.mAdminContext);
        return mbeanInfo.constructConfigMBean();
    }
}

