/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.ByteChunk;
import com.sun.enterprise.admin.common.DownloadRequestInfo;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeanapi.ISystemServicesMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SystemServicesMBean
implements DynamicMBean,
ISystemServicesMBean {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private Map mStreamTable = new Hashtable();
    private MBeanInfo info = null;
    private static StringManager localStrings = StringManager.getManager(SystemServicesMBean.class);
    private Lock lock;
    private DownloadInfo downloadInfo;

    public String uploadToServer(ByteChunk byteChunk) throws MBeanException {
        if (byteChunk == null) {
            throw new IllegalArgumentException();
        }
        String fileName = byteChunk.getChunkedFileName();
        String id = byteChunk.getId();
        File localDir = new File(AdminService.getAdminService().getTempDirPath(), id);
        localDir.mkdirs();
        String localPath = FileUtils.safeGetCanonicalPath(localDir);
        String targetDirName = byteChunk.getTargetDir();
        if (targetDirName != null) {
            File targetDir = new File(targetDirName);
            if (targetDir.isAbsolute()) {
                String msg = localStrings.getString("admin.mbeans.ssmb.absolute_dirs_not_allowed");
                throw new MBeanException(new IllegalAccessException(), msg);
            }
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            targetDir = new File(instanceRoot, targetDirName);
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            localPath = FileUtils.safeGetCanonicalPath(targetDir);
        }
        File uploadFile = new File(localPath, fileName);
        localPath = FileUtils.safeGetCanonicalPath(uploadFile);
        if (byteChunk.isFirst()) {
            if (uploadFile.exists()) {
                sLogger.log(Level.INFO, "mbean.temp_upload_file_exists", localPath);
                boolean couldDelete = uploadFile.delete();
                if (couldDelete) {
                    sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", localPath);
                } else {
                    sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", localPath);
                }
            }
            OutputStream outStream = this.createOutputStream(localPath);
            this.mStreamTable.put(id, outStream);
            sLogger.log(Level.INFO, "mbean.begin_upload", localPath);
        }
        this.saveFile(localPath, byteChunk);
        return localPath;
    }

    public DownloadRequestInfo mcPrepareDownload(String filePath) throws MBeanException {
        File dFile = new File(filePath = RelativePathResolver.resolvePath(filePath));
        if (!dFile.isAbsolute()) {
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            sLogger.log(Level.CONFIG, "mbean.prep_download", instanceRoot + filePath);
            dFile = new File(instanceRoot, filePath);
        } else {
            sLogger.log(Level.CONFIG, "mbean.prep_download", filePath);
        }
        if (!dFile.exists()) {
            String msg = localStrings.getString("admin.mbeans.ssmb.file_doesnot_exist", dFile.getAbsolutePath());
            throw new MBeanException(new FileNotFoundException(), msg);
        }
        return new DownloadRequestInfo(dFile);
    }

    public Object prepareDownload(String filePath) throws MBeanException {
        File downloadFile = new File(filePath = RelativePathResolver.resolvePath(filePath));
        if (!downloadFile.isAbsolute()) {
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            sLogger.log(Level.CONFIG, "mbean.prep_download", instanceRoot + filePath);
            downloadFile = new File(instanceRoot, filePath);
        } else {
            sLogger.log(Level.CONFIG, "mbean.prep_download", filePath);
        }
        if (!downloadFile.exists()) {
            String msg = localStrings.getString("admin.mbeans.ssmb.file_doesnot_exist", downloadFile.getAbsolutePath());
            throw new MBeanException(new FileNotFoundException(), msg);
        }
        try {
            if (this.lock == null) {
                this.lock = new Lock();
            }
            this.lock.attempt(1000L);
        }
        catch (Exception ie) {
            String msg = localStrings.getString("admin.server.core.mbean.config.could_not_acquire_lock", ie.toString());
            throw new MBeanException(ie, msg);
        }
        if (this.downloadInfo == null) {
            this.downloadInfo = new DownloadInfo();
        }
        this.downloadInfo.downloadFile = downloadFile;
        long size = this.downloadInfo.downloadFile.length();
        this.downloadInfo.numChunks = Math.round(size / 0xA00000L);
        if ((long)(this.downloadInfo.numChunks * 0xA00000) < size) {
            this.downloadInfo.numChunks += 1;
        }
        this.downloadInfo.isPrepared = true;
        return null;
    }

    /*
     * Loose catch block
     */
    public ByteChunk downloadFile(Integer chunkInteger) throws MBeanException {
        ByteChunk byteChunk;
        block16: {
            RandomAccessFile raf;
            block15: {
                int chunkIndex = chunkInteger;
                sLogger.log(Level.FINE, "mbean.begin_download");
                if (this.downloadInfo == null) {
                    String msg = localStrings.getString("admin.mbeans.ssmb.call_preparedownload_first");
                    throw new MBeanException(new IllegalStateException(msg));
                }
                if (!this.downloadInfo.isPrepared) {
                    String msg = localStrings.getString("admin.mbeans.ssmb.call_preparedownload_first");
                    throw new MBeanException(new IllegalStateException(msg));
                }
                byteChunk = null;
                if (this.downloadInfo.downloadFile.length() == 0L) {
                    byte[] bytes = new byte[]{};
                    byteChunk = new ByteChunk(bytes, this.downloadInfo.downloadFile.getAbsolutePath(), true, true);
                    this.unlockAndReset();
                    return byteChunk;
                }
                if (chunkIndex >= this.downloadInfo.numChunks || chunkIndex < 0) {
                    String msg = localStrings.getString("admin.mbeans.ssmb.invalid_chunk_index");
                    this.unlockAndReset();
                    throw new MBeanException(new IllegalStateException(msg));
                }
                raf = null;
                raf = new RandomAccessFile(this.downloadInfo.downloadFile, "r");
                byte[] bytes = new byte[0xA00000];
                raf.seek(this.downloadInfo.numBytesRead);
                int actualBytesRead = raf.read(bytes, 0, 0xA00000);
                if (actualBytesRead < bytes.length) {
                    byte[] newBytes = new byte[actualBytesRead];
                    System.arraycopy(bytes, 0, newBytes, 0, newBytes.length);
                    bytes = newBytes;
                }
                this.downloadInfo.numBytesRead += actualBytesRead;
                boolean isFirstChunk = chunkIndex == 0;
                boolean isLastChunk = chunkIndex == this.downloadInfo.numChunks - 1;
                sLogger.log(Level.FINEST, "chunkIndex = " + chunkIndex + " isFirstChunk = " + isFirstChunk + " isLastChunk = " + isLastChunk);
                byteChunk = new ByteChunk(bytes, this.downloadInfo.downloadFile.getAbsolutePath(), isFirstChunk, isLastChunk);
                Object var10_15 = null;
                if (raf == null) break block15;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (byteChunk != null && byteChunk.isLast()) {
                this.unlockAndReset();
            }
            break block16;
            {
                catch (IOException ioe) {
                    sLogger.log(Level.FINE, "mbean.download_failed", ioe);
                    this.unlockAndReset();
                    throw new MBeanException(ioe);
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (byteChunk != null && byteChunk.isLast()) {
                    this.unlockAndReset();
                }
                throw throwable;
            }
        }
        return byteChunk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized DownloadRequestInfo mcDownloadFile(DownloadRequestInfo info) throws MBeanException {
        ByteChunk byteChunk;
        block12: {
            sLogger.log(Level.FINE, "mbean.begin_download");
            if (info == null) {
                String msg = localStrings.getString("admin.mbeans.ssmb.call_preparedownload_first");
                throw new MBeanException(new IllegalStateException(msg));
            }
            if (!info.isPrepared()) {
                String msg = localStrings.getString("admin.mbeans.ssmb.call_preparedownload_first");
                throw new MBeanException(new IllegalStateException(msg));
            }
            File targetFile = new File(info.getDownloadFilePath());
            byteChunk = null;
            if (targetFile.length() == 0L) {
                byte[] bytes = new byte[]{};
                String fPath = info.getDownloadFilePath();
                byteChunk = new ByteChunk(bytes, fPath, true, true, fPath, 0L);
                info.setChunk(byteChunk);
                return info;
            }
            if (info.getChunkIndex() >= info.getNumberOfChunks() || info.getChunkIndex() < 0) {
                String msg = localStrings.getString("admin.mbeans.ssmb.invalid_chunk_index");
                throw new MBeanException(new IllegalStateException(msg));
            }
            RandomAccessFile raf = null;
            try {
                try {
                    raf = new RandomAccessFile(targetFile, "r");
                    byte[] bytes = new byte[0xA00000];
                    raf.seek(info.getNumberOfBytesSent());
                    int actualBytesRead = raf.read(bytes, 0, 0xA00000);
                    if (actualBytesRead < bytes.length) {
                        byte[] newBytes = new byte[actualBytesRead];
                        System.arraycopy(bytes, 0, newBytes, 0, newBytes.length);
                        bytes = newBytes;
                    }
                    info.incrementNumberOfBytesSent(bytes.length);
                    String path = info.getDownloadFilePath();
                    byteChunk = new ByteChunk(bytes, path, info.isFirstChunk(), info.isLastChunk(), path, targetFile.length());
                }
                catch (IOException ioe) {
                    sLogger.log(Level.FINE, "mbean.download_failed", ioe);
                    throw new MBeanException(ioe);
                }
                Object var9_14 = null;
                if (raf == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (raf == null) throw throwable;
                try {
                    raf.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioe) {}
            raf.close();
        }
        info.setChunk(byteChunk);
        return info;
    }

    private void unlockAndReset() {
        try {
            this.downloadInfo.reset();
            this.lock.release();
        }
        catch (Exception e) {
            sLogger.log(Level.FINEST, "lock could not be released");
        }
    }

    public String getClientStubJarLocation(String appName) throws MBeanException {
        String clientJarLocation = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ObjectName appsObjName = new ObjectName("com.sun.appserv:type=applications,category=config");
            String appLocation = null;
            ObjectName appObjName = null;
            try {
                appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getJ2eeApplicationByName", new Object[]{appName}, new String[]{"java.lang.String"});
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (appObjName == null) {
                try {
                    appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getEjbModuleByName", new Object[]{appName}, new String[]{"java.lang.String"});
                }
                catch (Exception ejbe) {
                    // empty catch block
                }
                if (appObjName == null) {
                    try {
                        appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getAppclientModuleByName", new Object[]{appName}, new String[]{"java.lang.String"});
                    }
                    catch (Exception ace) {
                        // empty catch block
                    }
                }
                if (appObjName == null) {
                    throw new IllegalArgumentException(localStrings.getString("admin.mbeans.ssmb.invalid_appname", appName));
                }
            }
            appLocation = (String)this.getMBeanServer().getAttribute(appObjName, "location");
            clientJarLocation = appLocation + File.separator + DeploymentServiceUtils.getClientJarPath(appName);
            sLogger.log(Level.INFO, "mbean.cl_jar_loc", clientJarLocation);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.toString(), e);
            throw new MBeanException(e);
        }
        return clientJarLocation;
    }

    public String getWsdlFileLocation(String appName, String moduleName, String wsdlFileUri) throws MBeanException {
        String wsdlFileLocation = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ObjectName appsObjName = new ObjectName("com.sun.appserv:type=applications,category=config");
            String appLocation = null;
            ObjectName appObjName = null;
            try {
                appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getJ2eeApplicationByName", new Object[]{appName}, new String[]{"java.lang.String"});
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (appObjName != null) {
                appLocation = (String)this.getMBeanServer().getAttribute(appObjName, "location");
            } else {
                try {
                    appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getEjbModuleByName", new Object[]{appName}, new String[]{"java.lang.String"});
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (appObjName != null) {
                    appLocation = (String)this.getMBeanServer().getAttribute(appObjName, "location");
                } else {
                    try {
                        appObjName = (ObjectName)this.getMBeanServer().invoke(appsObjName, "getWebModuleByName", new Object[]{appName}, new String[]{"java.lang.String"});
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    if (appObjName != null) {
                        appLocation = (String)this.getMBeanServer().getAttribute(appObjName, "location");
                    } else {
                        throw new IllegalArgumentException(localStrings.getString("admin.mbeans.ssmb.invalid_appname", appName));
                    }
                }
            }
            FileArchive appArchive = new FileArchive();
            AbstractArchive moduleArchive = null;
            appArchive.open(RelativePathResolver.resolvePath(appLocation));
            moduleArchive = moduleName != null ? appArchive.getEmbeddedArchive(moduleName) : appArchive;
            wsdlFileLocation = moduleArchive.getArchiveUri() + File.separator + wsdlFileUri.replace('/', File.separatorChar);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.toString(), e);
            throw new MBeanException(e);
        }
        return wsdlFileLocation;
    }

    protected MBeanServer getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    protected String getDomainName() {
        return AdminService.getAdminService().getAdminContext().getDomainName();
    }

    public Object getAttribute(String str) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(str);
    }

    public AttributeList getAttributes(String[] str) {
        return new AttributeList();
    }

    public MBeanInfo getMBeanInfo() {
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[1];
        MBeanNotificationInfo[] notifications = null;
        MBeanAttributeInfo[] attributes = null;
        MBeanOperationInfo[] operations = new MBeanOperationInfo[4];
        try {
            MBeanConstructorInfo cinfo;
            constructors[0] = cinfo = new MBeanConstructorInfo("Main constructor", this.getClass().getConstructor(null));
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getLocalizedMessage());
        }
        MBeanParameterInfo[] parameters = new MBeanParameterInfo[]{new MBeanParameterInfo("byteChunk", ByteChunk.class.getName(), "byte chunk")};
        operations[0] = new MBeanOperationInfo("uploadToServer", "upload file to admin server", parameters, String.class.getName(), 1);
        MBeanParameterInfo[] parameters1 = new MBeanParameterInfo[]{new MBeanParameterInfo("fileName", String.class.getName(), "file name")};
        operations[1] = new MBeanOperationInfo("prepareDownload", "prepare file download from admin server", parameters1, Object.class.getName(), 1);
        MBeanParameterInfo[] parameters2 = new MBeanParameterInfo[]{new MBeanParameterInfo("chunkIndex", "java.lang.Integer", "chunk index")};
        operations[2] = new MBeanOperationInfo("downloadFile", "download file from admin server", parameters2, ByteChunk.class.getName(), 1);
        MBeanParameterInfo[] parameters3 = new MBeanParameterInfo[]{new MBeanParameterInfo("appName", String.class.getName(), "application name")};
        operations[3] = new MBeanOperationInfo("getClientStubJarLocation", "get stub file location from admin server", parameters3, String.class.getName(), 1);
        return new MBeanInfo(this.getClass().getName(), "Manages System Services", attributes, constructors, operations, notifications);
    }

    public Object invoke(String str, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            String methodName = str;
            Class[] types = new Class[sig.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = Class.forName(sig[i]);
            }
            Method m = this.getClass().getMethod(methodName, types);
            return m.invoke((Object)this, args);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.toString(), e);
            throw new MBeanException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFile(String filePath, ByteChunk aChunk) throws MBeanException {
        OutputStream sOut = null;
        String id = aChunk.getId();
        try {
            try {
                sOut = (OutputStream)this.mStreamTable.get(id);
                byte[] bytes = aChunk.getBytes();
                sOut.write(bytes);
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, e.getLocalizedMessage(), e);
                throw new MBeanException(e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (!aChunk.isLast()) throw throwable;
                sOut.close();
                this.mStreamTable.remove(id);
                if (aChunk.getTotalFileSize() > 0L) {
                    if (new File(filePath).length() != aChunk.getTotalFileSize()) {
                        sLogger.log(Level.WARNING, "mbean.upload_failed", filePath);
                        String msg = localStrings.getString("admin.mbeans.upload_failed", filePath);
                        throw new MBeanException(new RuntimeException(msg));
                    }
                } else {
                    sLogger.log(Level.INFO, "mbean.filesize_notverified", filePath);
                }
                sLogger.log(Level.INFO, "mbean.upload_done", filePath);
                throw throwable;
            }
            catch (Exception fe) {
                sLogger.log(Level.WARNING, fe.toString(), fe);
                throw new MBeanException(fe);
            }
        }
        try {}
        catch (Exception fe) {
            sLogger.log(Level.WARNING, fe.toString(), fe);
            throw new MBeanException(fe);
        }
        if (!aChunk.isLast()) return;
        sOut.close();
        this.mStreamTable.remove(id);
        if (aChunk.getTotalFileSize() > 0L) {
            if (new File(filePath).length() != aChunk.getTotalFileSize()) {
                sLogger.log(Level.WARNING, "mbean.upload_failed", filePath);
                String msg = localStrings.getString("admin.mbeans.upload_failed", filePath);
                throw new MBeanException(new RuntimeException(msg));
            }
        } else {
            sLogger.log(Level.INFO, "mbean.filesize_notverified", filePath);
        }
        sLogger.log(Level.INFO, "mbean.upload_done", filePath);
    }

    private OutputStream createOutputStream(String filePath) throws MBeanException {
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(filePath);
        }
        catch (Exception e) {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (Exception ce) {
                sLogger.log(Level.WARNING, "mbean.upload_failed", filePath);
            }
            throw new MBeanException(e);
        }
        return fOut;
    }

    private static final class DownloadInfo {
        private File downloadFile;
        private int numChunks;
        private long numBytesRead;
        private boolean isPrepared;

        private DownloadInfo() {
            this.reset();
        }

        private synchronized void reset() {
            this.downloadFile = null;
            this.numChunks = 0;
            this.numBytesRead = 0L;
            this.isPrepared = false;
        }
    }

    private final class Lock {
        private boolean inUse = false;

        private Lock() {
        }

        private synchronized void acquire() throws InterruptedException, IllegalAccessException {
            while (this.inUse) {
                this.wait();
            }
            this.inUse = true;
        }

        private synchronized void release() throws IllegalAccessException {
            this.inUse = false;
            this.notify();
        }

        private synchronized void attempt(long milliseconds) throws InterruptedException, IllegalAccessException {
            if (this.inUse) {
                this.wait(milliseconds);
                if (this.inUse) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.another_thread_holding_lock");
                    throw new IllegalAccessException(msg);
                }
            }
            this.inUse = true;
        }
    }
}

