/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.mbeans.HttpListenerVirtualServerAssociationMgr;
import com.sun.enterprise.admin.util.jmx.AttributeListUtils;
import com.sun.enterprise.config.ConfigException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HttpListenerMBean
extends BaseConfigMBean
implements MBeanRegistration {
    private ObjectName on;
    static final String DEFAULT_VIRTUAL_SERVER = "default_virtual_server";

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String oldVs = null;
        if (this.isDefaultVirtualServer(attribute)) {
            oldVs = (String)super.getAttribute(DEFAULT_VIRTUAL_SERVER);
        }
        super.setAttribute(attribute);
        if (this.isDefaultVirtualServer(attribute)) {
            try {
                this.changeHttpListenerRef(oldVs, (String)attribute.getValue());
            }
            catch (ConfigException ce) {
                throw new MBeanException(ce);
            }
        }
    }

    public AttributeList setAttributes(AttributeList list) {
        String oldVs = null;
        if (this.isDefaultVirtualServerExists(list)) {
            try {
                oldVs = (String)super.getAttribute(DEFAULT_VIRTUAL_SERVER);
            }
            catch (JMException e) {
                // empty catch block
            }
        }
        AttributeList al = super.setAttributes(list);
        if (this.isDefaultVirtualServerExists(list) && this.isDefaultVirtualServerExists(al)) {
            try {
                this.changeHttpListenerRef(oldVs, this.getDefaultVirtualServer(list));
            }
            catch (ConfigException ce) {
                _sLogger.log(Level.WARNING, "httplistenerMBean.failed_to_add_http_listener_ref", ce);
            }
        }
        return al;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.on = super.preRegister(server, name);
        return this.on;
    }

    private void changeHttpListenerRef(String oldVs, String newVs) throws ConfigException {
        HttpListenerVirtualServerAssociationMgr mgr = new HttpListenerVirtualServerAssociationMgr(super.getConfigContext(), this.on.getKeyProperty("config"));
        String id = this.on.getKeyProperty("id");
        mgr.changeHttpListenerRef(id, oldVs, newVs);
    }

    private boolean isDefaultVirtualServer(Attribute a) {
        return a.getName().equals(DEFAULT_VIRTUAL_SERVER);
    }

    private boolean isDefaultVirtualServerExists(AttributeList al) {
        return AttributeListUtils.containsNamedAttribute(al, DEFAULT_VIRTUAL_SERVER);
    }

    private String getDefaultVirtualServer(AttributeList al) {
        Map map = AttributeListUtils.asNameMap(al);
        Attribute val = (Attribute)map.get(DEFAULT_VIRTUAL_SERVER);
        return (String)val.getValue();
    }
}

