/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.ElementChangeEventsFactory;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ElementChangeHelper {
    static final String eventType = ElementChangeHelper.class.getName();
    private static StringManager localStrings = StringManager.getManager(ElementChangeHelper.class);
    private static String PROPERTY_SUBSTR = "/" + ServerTags.ELEMENT_PROPERTY + "[";
    String lastXpath = null;
    MBeanRegistryEntry lastEntry = null;
    public static final String EVENT_PACKAGE_PATH_PREFIX = "com.sun.enterprise.admin.event.";
    private static String[] restartExcludeXPaths = new String[]{"/domain/lb-configs"};

    static boolean isChangesToMerge(ConfigChange change1, ConfigChange change2) {
        String xpath2;
        String xpath1;
        if (change1 == null || change2 == null || (xpath1 = change1.getXPath()) == null || (xpath2 = change2.getXPath()) == null || !ElementChangeHelper.compareXPathes(xpath1, xpath2)) {
            return false;
        }
        if (ElementChangeHelper.isPropertyXPath(xpath2)) {
            return true;
        }
        return xpath1.equals(change2.getXPath()) && change1.getClass().equals(change2.getClass());
    }

    static boolean checkChangeListForElement(ArrayList list) {
        if (list == null || list.size() <= 0) {
            return false;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (ElementChangeHelper.isChangesToMerge((ConfigChange)list.get(i - 1), (ConfigChange)list.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isPropertyChange(ConfigChange change) {
        String xpath;
        return change != null && (xpath = change.getXPath()) != null && xpath.indexOf(PROPERTY_SUBSTR) >= 0;
    }

    static boolean isPropertyXPath(String xpath) {
        return xpath != null && xpath.indexOf(PROPERTY_SUBSTR) >= 0;
    }

    static String getConfigElementPrimaryKey(String xpath) {
        if (xpath != null) {
            xpath = xpath.trim();
        }
        if (xpath != null && xpath.endsWith("']")) {
            int idx = xpath.lastIndexOf(39, xpath.length() - 3);
            return xpath.substring(idx + 1, xpath.length() - 2);
        }
        return null;
    }

    static String getConfigElementType(String xpath) {
        if (xpath.trim().endsWith("]")) {
            xpath = xpath.substring(0, xpath.lastIndexOf(91));
        }
        return xpath.substring(0, xpath.lastIndexOf(47));
    }

    static String getConfigElementTargetName(String xpath, ConfigContext ctx) {
        Object targetName = null;
        try {
            TargetBuilder targetBuilder = new TargetBuilder();
            return targetBuilder.getTargetNameForXPath(xpath, ctx, true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getElementXPath(ArrayList changes) {
        return ElementChangeHelper.getElementXPath((ConfigChange)changes.get(0));
    }

    static String getElementXPath(ConfigChange change) {
        String xpath = change.getXPath();
        if (xpath == null) {
            return xpath;
        }
        int iMatch = xpath.indexOf(PROPERTY_SUBSTR);
        if (iMatch < 0) {
            return xpath;
        }
        return xpath.substring(0, iMatch);
    }

    static int getActionCodeForChanges(ArrayList changes) {
        return ElementChangeHelper.getActionCodeForChange((ConfigChange)changes.get(0));
    }

    static int getActionCodeForChange(ConfigChange change) {
        if (ElementChangeHelper.isPropertyXPath(change.getXPath())) {
            return 3;
        }
        int action = change instanceof ConfigSet ? 1 : (change instanceof ConfigAdd ? 1 : (change instanceof ConfigUpdate ? 3 : (change instanceof ConfigDelete ? 2 : 0)));
        return action;
    }

    private static boolean compareXPathes(String xpath1, String xpath2) {
        int iProp = xpath1.indexOf(PROPERTY_SUBSTR);
        if (iProp > 0) {
            xpath1 = xpath1.substring(0, iProp);
        }
        if ((iProp = xpath2.indexOf(PROPERTY_SUBSTR)) > 0) {
            xpath2 = xpath2.substring(0, iProp);
        }
        return xpath1.equals(xpath2);
    }

    public AdminEvent[] generateElementChangeEventsFromChangeList(String instanceName, ArrayList changeList, ConfigContext domainContext) {
        ArrayList new_events;
        ArrayList<ConfigChange> merged = new ArrayList<ConfigChange>();
        ArrayList events = new ArrayList();
        ConfigChange lastChange = null;
        for (int i = 0; i < changeList.size(); ++i) {
            ConfigChange change = (ConfigChange)changeList.get(i);
            if (merged.isEmpty() || ElementChangeHelper.isChangesToMerge(lastChange, change)) {
                merged.add(change);
                lastChange = change;
                continue;
            }
            if (merged.isEmpty()) continue;
            ArrayList new_events2 = this.createEventsForElementChange(instanceName, merged, domainContext);
            if (new_events2 != null && new_events2.size() > 0) {
                events.addAll(new_events2);
            }
            merged.clear();
            merged.add(change);
            lastChange = change;
        }
        if (!merged.isEmpty() && (new_events = this.createEventsForElementChange(instanceName, merged, domainContext)) != null && new_events.size() > 0) {
            events.addAll(new_events);
        }
        return events.toArray(new AdminEvent[events.size()]);
    }

    public ArrayList createEventsForElementChange(String instanceName, ArrayList changeList, ConfigContext domainContext) {
        return this.createEventsForElementChange(instanceName, changeList, domainContext, true);
    }

    private ArrayList createEventsForElementChange(String instanceName, ArrayList changeList, ConfigContext domainContext, boolean bCheckList) {
        if (bCheckList && !ElementChangeHelper.checkChangeListForElement(changeList)) {
            String msg = localStrings.getString("admin.event.wrong_configchange");
            throw new IllegalArgumentException(msg);
        }
        String xpath0 = ElementChangeHelper.getElementXPath(changeList);
        MBeanRegistryEntry entry = this.getRegistryEntry(xpath0);
        if (entry == null) {
            return null;
        }
        String eventName = entry.getElementChangeEventName();
        if (eventName != null && eventName.indexOf(46) < 0) {
            eventName = EVENT_PACKAGE_PATH_PREFIX + eventName;
        }
        if (eventName == null) {
            return null;
        }
        try {
            return ElementChangeEventsFactory.createEvents(eventName, instanceName, entry.getName(), changeList, domainContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = localStrings.getString("admin.event.cannot_create_eventforchange", eventName, xpath0);
            throw new IllegalArgumentException(msg);
        }
    }

    private synchronized MBeanRegistryEntry getRegistryEntry(String xpath) {
        if (xpath.equals(this.lastXpath)) {
            return this.lastEntry;
        }
        MBeanRegistry registry = MBeanRegistryFactory.getAdminMBeanRegistry();
        MBeanRegistryEntry entry = registry.findMBeanRegistryEntryByXPath(xpath);
        if (entry != null) {
            this.lastXpath = xpath;
            this.lastEntry = entry;
        }
        return entry;
    }

    public static Set getXPathesForDynamicallyNotReconfigurableElements(ArrayList changeList) {
        HashSet<String> xpathes = new HashSet<String>();
        if (changeList == null) {
            return xpathes;
        }
        MBeanRegistry registry = MBeanRegistryFactory.getAdminMBeanRegistry();
        String xpath_last = null;
        MBeanRegistryEntry entry = null;
        boolean bLastEntryHasEvent = false;
        String propertyName = null;
        block0: for (int i = 0; i < changeList.size(); ++i) {
            String xpath;
            ConfigChange change = (ConfigChange)changeList.get(i);
            int action = ElementChangeHelper.getActionCodeForChange(change);
            if (action == 0 || (xpath = change.getXPath()) == null || ElementChangeHelper.isXPathExcludedForRestartCheck(xpath)) continue;
            if (!xpath.equals(xpath_last)) {
                xpath_last = xpath;
                if (ElementChangeHelper.isPropertyXPath(change.getXPath())) {
                    propertyName = ElementChangeHelper.getConfigElementPrimaryKey(xpath);
                    xpath = ElementChangeHelper.getElementXPath(change);
                } else {
                    propertyName = null;
                }
                entry = registry.findMBeanRegistryEntryByXPath(xpath);
                if (entry == null) {
                    xpathes.add(xpath);
                    continue;
                }
                boolean bl = bLastEntryHasEvent = entry.getElementChangeEventName() != null;
            }
            if (bLastEntryHasEvent) continue;
            if (action == 1 && entry.isElementCreationDynamicallyReconfigurable()) {
                xpathes.add(xpath);
                continue;
            }
            if (action == 2 && entry.isElementDeletionDynamicallyReconfigurable()) {
                xpathes.add(xpath);
                continue;
            }
            if (propertyName != null && !entry.isPropertyDynamicallyReconfigurable(propertyName)) {
                xpathes.add(xpath);
                continue;
            }
            if (!(change instanceof ConfigUpdate)) {
                xpathes.add(xpath);
                continue;
            }
            Set attrs = ((ConfigUpdate)change).getAttributeSet();
            Iterator iter = attrs.iterator();
            while (iter.hasNext()) {
                String attr = (String)iter.next();
                if (entry.isAttributeDynamicallyReconfigurable(attr)) continue;
                xpathes.add(xpath);
                continue block0;
            }
        }
        return xpathes;
    }

    public static boolean getBooleanValue(String strValue) {
        boolean retval = false;
        if (strValue == null) {
            return retval;
        }
        if (strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("on") || strValue.equalsIgnoreCase("1")) {
            retval = true;
        }
        return retval;
    }

    private static boolean isXPathExcludedForRestartCheck(String xpath) {
        if (xpath == null) {
            return false;
        }
        for (int excludeIdx = 0; excludeIdx < restartExcludeXPaths.length; ++excludeIdx) {
            if (!xpath.startsWith(restartExcludeXPaths[excludeIdx])) continue;
            return true;
        }
        return false;
    }

    public static Boolean findEnabledChange(ArrayList changeList) {
        if (changeList == null) {
            return null;
        }
        for (int i = changeList.size() - 1; i >= 0; --i) {
            ConfigUpdate update;
            String enableStr;
            if (!(changeList.get(i) instanceof ConfigUpdate) || (enableStr = (update = (ConfigUpdate)changeList.get(i)).getNewValue(ServerTags.ENABLED)) == null) continue;
            return new Boolean(ElementChangeHelper.getBooleanValue(enableStr));
        }
        return null;
    }
}

