/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;

public final class DottedNameRegistry1To1Impl
implements DottedNameRegistry {
    final HashMap mDottedNameStringsToObjectNames = new HashMap(300);
    final HashMap mObjectNamesToDottedNameStrings = new HashMap(300);
    private static final int INITIAL_CAPACITY = 300;

    public synchronized ObjectName dottedNameToObjectName(String dottedName) {
        return (ObjectName)this.mDottedNameStringsToObjectNames.get(dottedName);
    }

    public synchronized String objectNameToDottedName(ObjectName objectName) {
        return (String)this.mObjectNamesToDottedNameStrings.get(objectName);
    }

    private Set copySet(Set input) {
        HashSet newSet = new HashSet();
        newSet.addAll(input);
        return newSet;
    }

    public synchronized Set allDottedNameStrings() {
        return this.copySet(this.mDottedNameStringsToObjectNames.keySet());
    }

    public synchronized Set allObjectNames() {
        return this.copySet(this.mObjectNamesToDottedNameStrings.keySet());
    }

    public synchronized void add(String dottedName, ObjectName objectName) {
        if (this.objectNameToDottedName(objectName) != null) {
            this.remove(objectName);
        }
        this.mDottedNameStringsToObjectNames.put(dottedName, objectName);
        this.mObjectNamesToDottedNameStrings.put(objectName, dottedName);
    }

    synchronized void remove(String dottedName, ObjectName objectName) {
        if (dottedName != null && objectName != null) {
            this.mDottedNameStringsToObjectNames.remove(dottedName);
            this.mObjectNamesToDottedNameStrings.remove(objectName);
        }
    }

    public void remove(String dottedName) {
        this.remove(dottedName, this.dottedNameToObjectName(dottedName));
    }

    public void remove(ObjectName objectName) {
        this.remove(this.objectNameToDottedName(objectName), objectName);
    }
}

