/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameAliasSupport;
import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameResolverForAliases;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class DottedNameAliasedQuery
implements DottedNameQuery {
    protected final DottedNameQuery mSrcQuery;
    protected final DottedNameServerInfo mServerInfo;
    final DottedNameResolverForAliases mAliasResolver;

    public DottedNameAliasedQuery(DottedNameQuery srcQuery, DottedNameServerInfo serverInfo) {
        this.mSrcQuery = srcQuery;
        this.mServerInfo = serverInfo;
        this.mAliasResolver = new DottedNameResolverForAliases(srcQuery, serverInfo);
    }

    public ObjectName dottedNameToObjectName(String dottedName) {
        return this.mAliasResolver.resolveDottedName(dottedName);
    }

    public Set allDottedNameStrings() {
        Set result = Collections.EMPTY_SET;
        try {
            result = this.allDottedNameStringsThrow();
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameLogger.logException(e);
        }
        return result;
    }

    protected Set allDottedNameStringsThrow() throws DottedNameServerInfo.UnavailableException {
        Set srcSet = this.mSrcQuery.allDottedNameStrings();
        Iterator iter = srcSet.iterator();
        HashSet<String> destSet = new HashSet<String>();
        Set configNames = this.mServerInfo.getConfigNames();
        while (iter.hasNext()) {
            String dottedName = (String)iter.next();
            DottedName dn = DottedNameFactory.getInstance().get(dottedName);
            String scope = dn.getScope();
            if (DottedNameAliasSupport.scopeIsDomain(scope)) {
                if (!DottedNameAliasSupport.isAliasedDomain(dn)) continue;
                destSet.add(dottedName);
                this.addAllNamesForDomain(dn, destSet);
                continue;
            }
            if (configNames.contains(scope)) {
                this.addAllNamesForConfig(dn, destSet);
                continue;
            }
            destSet.add(dottedName);
        }
        return destSet;
    }

    protected void addAllNamesForDomain(DottedName domainDN, Set outSet) throws DottedNameServerInfo.UnavailableException {
        Iterator iter = this.mServerInfo.getServerNames().iterator();
        while (iter.hasNext()) {
            String serverName = (String)iter.next();
            String dottedNameString = DottedName.toString(domainDN.getDomain(), serverName, domainDN.getParts());
            DottedName newName = DottedNameFactory.getInstance().get(dottedNameString);
            outSet.add(newName.toString());
        }
    }

    protected void addAllNamesForConfig(DottedName configDN, Set outSet) throws DottedNameServerInfo.UnavailableException {
        String[] serverNames = this.mServerInfo.getServerNamesForConfig(configDN.getScope());
        for (int i = 0; i < serverNames.length; ++i) {
            String newName = DottedName.toString(configDN.getDomain(), serverNames[i], configDN.getParts());
            outSet.add(newName);
        }
    }
}

