/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.TimerLocalHome;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbTimerService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.util.Iterator;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TimerBeanContainer
extends EntityContainer {
    private EJBTimerService ejbTimerService;

    protected TimerBeanContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        Iterator iter = this.invocationInfoMap.values().iterator();
        while (iter.hasNext()) {
            InvocationInfo invInfo = (InvocationInfo)iter.next();
            invInfo.securityPermissions = 1;
        }
        _logger.log(Level.FINE, "[TimerBeanContainer] Created  TimerBeanContainer: " + this.logParams[0]);
    }

    public void onShutdown() {
        _logger.log(Level.FINE, "[TimerBeanContainer] onShutdown() called....");
        super.onShutdown();
        if (this.ejbTimerService != null) {
            this.ejbTimerService.onShutdown();
        }
    }

    public void doAfterApplicationDeploy() {
        super.doAfterApplicationDeploy();
        try {
            String ejbtDatasource;
            TimerLocalHome timerLocalHome = (TimerLocalHome)this.ejbLocalHome;
            EjbBundleDescriptor bundle = this.ejbDescriptor.getEjbBundleDescriptor();
            ResourceReferenceDescriptor cmpResource = bundle.getCMPResourceReference();
            String cmpResourceJndiName = cmpResource.getJndiName();
            ServerContext sc = ApplicationServer.getServerContext();
            EjbContainer ejbc = ServerBeansFactory.getConfigBean(sc.getConfigContext()).getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            String string = ejbtDatasource = ejbt != null ? ejbt.getTimerDatasource() : null;
            if (ejbtDatasource != null && !ejbtDatasource.equals(cmpResourceJndiName)) {
                cmpResourceJndiName = ejbtDatasource;
                cmpResource.setJndiName(cmpResourceJndiName);
            }
            InitialContext context = new InitialContext();
            context.lookup(cmpResourceJndiName);
            boolean checkStatus = timerLocalHome.checkStatus(cmpResourceJndiName, false);
            if (checkStatus) {
                Application application = this.ejbDescriptor.getApplication();
                String appID = application.getRegistrationName();
                this.ejbTimerService = new EJBTimerService(appID, timerLocalHome);
                this.containerFactory.setEJBTimerService(this.ejbTimerService);
                _logger.log(Level.INFO, "ejb.timer_service_started", new Object[]{cmpResourceJndiName});
            }
        }
        catch (NamingException nnfe) {
            _logger.log(Level.WARNING, "ejb.timer_service_init_error", this.logParams);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.timer_service_init_error", this.logParams);
            _logger.log(Level.WARNING, "", ex);
        }
    }
}

