/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.ejb.containers.util.MethodMap;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;

public final class EJBLocalObjectInvocationHandler
extends EJBLocalObjectImpl
implements InvocationHandler {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBLocalObjectInvocationHandler.class);
    private EJBLocalObject proxy_;
    private MethodMap invocationInfoMap_;

    public EJBLocalObjectInvocationHandler(MethodMap invocationInfoMap) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
    }

    public void setProxy(EJBLocalObject proxy) {
        this.proxy_ = proxy;
    }

    public EJBLocalObject getEJBLocalObject() {
        return this.proxy_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass == Object.class) {
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        if (methodClass == IndirectlySerializable.class) {
            return this.getSerializableObjectFactory();
        }
        InvocationInfo invInfo = (InvocationInfo)this.invocationInfoMap_.get(method, args != null ? args.length : 0);
        if (invInfo == null) {
            throw new IllegalStateException("Unknown method :" + method);
        }
        if (methodClass == EJBLocalObject.class || invInfo.ejbIntfOverride) {
            return this.invokeEJBLocalObjectMethod(method.getName(), args);
        }
        if (invInfo.targetMethod1 == null) {
            Object[] params = new Object[]{invInfo.ejbName, "Local", invInfo.method.toString()};
            String errorMsg = localStrings.getLocalString("ejb.bean_class_method_not_found", "", params);
            logger.log(Level.SEVERE, "ejb.bean_class_method_not_found", params);
            throw new EJBException(errorMsg);
        }
        Object returnValue = null;
        Invocation inv = new Invocation();
        inv.isLocal = true;
        inv.isHome = false;
        inv.ejbObject = this;
        inv.method = method;
        inv.transactionAttribute = invInfo.txAttr;
        inv.securityPermissions = invInfo.securityPermissions;
        inv.invocationInfo = invInfo;
        try {
            this.container.preInvoke(inv);
            returnValue = SecurityUtil.invoke(invInfo.targetMethod1, inv, inv.ejb, args, this.container, null);
        }
        catch (InvocationTargetException ite) {
            inv.exception = ite.getCause();
        }
        catch (Throwable t) {
            inv.exception = t;
        }
        finally {
            this.container.postInvoke(inv);
        }
        if (inv.exception != null) {
            InvocationHandlerUtil.throwLocalException(inv.exception, method.getExceptionTypes());
        }
        return returnValue;
    }

    private Object invokeEJBLocalObjectMethod(String methodName, Object[] args) throws Exception {
        Object returnValue = null;
        switch (methodName.charAt(0)) {
            case 'r': {
                super.remove();
                break;
            }
            case 'i': {
                EJBLocalObject other = (EJBLocalObject)args[0];
                EJBLocalObjectImpl otherImpl = EJBLocalObjectImpl.toEJBLocalObjectImpl(other);
                returnValue = new Boolean(super.isIdentical(otherImpl));
                break;
            }
            case 'g': {
                if (methodName.charAt(3) == 'E') {
                    returnValue = super.getEJBLocalHome();
                    break;
                }
                returnValue = super.getPrimaryKey();
                break;
            }
            default: {
                throw new EJBException("unknown method = " + methodName);
            }
        }
        return returnValue;
    }
}

