/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Compiler;
import com.sun.ejb.codegen.JavaCompilerException;
import com.sun.ejb.codegen.ProcessExecutorException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.tools.javac.Main;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

class JavaCompiler
extends Compiler {
    private static final String JAVAC_EXT_DIRS_OPTION = "-extdirs";
    private static final String JAVAC_OUT_OF_PROCESS = "com.sun.aas.deployment.javacoutofprocess";
    private File userExe;
    private File fastExe;
    private File javacExe;
    private List userOptions;
    private static int fastJavacTimeout = -1;
    private static int javacTimeout = -1;
    private static int userTimeout = -1;

    JavaCompiler(List theOptions, List theFiles) throws JavaCompilerException {
        super(theOptions, theFiles);
    }

    protected void internal_compile() throws JavaCompilerException, ProcessExecutorException {
        if (this.userCompile()) {
            return;
        }
        if (this.fastjavacCompile()) {
            return;
        }
        this.javacCompile();
    }

    private boolean userCompile() throws ProcessExecutorException {
        if (this.userExe == null) {
            return false;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.userExe.getPath());
        cmd.add(JAVAC_EXT_DIRS_OPTION);
        cmd.add(System.getProperty("java.ext.dirs"));
        cmd.addAll(this.userOptions);
        cmd.addAll(this.options);
        cmd.addAll(this.files);
        String[] cmds = new String[cmd.size()];
        cmds = cmd.toArray(cmds);
        this.runProcess(cmds, JavaCompiler.getUserSpecifiedCompilerTimeout() * this.files.size());
        this.logCompilerName(this.userExe.getName());
        return true;
    }

    private boolean fastjavacCompile() throws ProcessExecutorException {
        if (this.fastExe == null || this.jdkDir == null) {
            return false;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.fastExe.getPath());
        cmd.add("-jdk");
        cmd.add(this.jdkDir.getPath());
        cmd.addAll(this.options);
        this.addJavaFiles(cmd);
        String[] cmds = new String[cmd.size()];
        cmds = cmd.toArray(cmds);
        this.runProcess(cmds, JavaCompiler.getFastjavacTimeout() * this.files.size());
        this.logCompilerName("fastjavac");
        return true;
    }

    private boolean javacCompile() throws JavaCompilerException, ProcessExecutorException {
        if (this.javacExe == null) {
            return false;
        }
        boolean outOfProcess = Boolean.getBoolean(JAVAC_OUT_OF_PROCESS);
        ArrayList<String> cmd = new ArrayList<String>();
        if (outOfProcess) {
            cmd.add(this.javacExe.getPath());
        }
        cmd.add(JAVAC_EXT_DIRS_OPTION);
        cmd.add(System.getProperty("java.ext.dirs"));
        cmd.addAll(this.options);
        this.addJavaFiles(cmd);
        String[] cmds = new String[cmd.size()];
        cmds = cmd.toArray(cmds);
        if (outOfProcess) {
            this.runProcess(cmds, JavaCompiler.getJavacTimeout() * this.files.size());
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bos);
                Main compiler = new Main();
                int ret = Main.compile(cmds, pw);
                if (ret != 0) {
                    byte[] errorBytes = bos.toByteArray();
                    String errorString = new String(errorBytes);
                    throw new JavaCompilerException("java_compiler.error", "Native compiler returned an error: {0}\nError messages are: {1}", new Object[]{new Integer(ret), errorString});
                }
            }
            catch (JavaCompilerException jce) {
                throw jce;
            }
            catch (Throwable t) {
                throw new JavaCompilerException("java_compiler.unknown_exception", "JavaC compiler threw an Exception", t);
            }
        }
        this.logCompilerName("javac");
        return true;
    }

    protected void internal_init() {
        this.fastExe = null;
        this.javacExe = null;
        this.userExe = null;
        this.userOptions = new ArrayList();
        this.initUserCompiler();
        this.initFastjavac();
        this.initJavac();
        logger.log(Level.FINE, "fastExe: " + (this.fastExe == null ? "null" : this.fastExe.getPath()));
        logger.log(Level.FINE, "javacExe: " + (this.javacExe == null ? "null" : this.javacExe.getPath()));
        logger.log(Level.FINE, "jdkDir: " + (this.jdkDir == null ? "null" : this.jdkDir.getPath()));
    }

    private void initUserCompiler() {
        String userSpecified = JavaCompiler.getSystemPropertyIgnoreCase("com.sun.aas.deployment.java.compiler");
        if (!StringUtils.ok((String)userSpecified)) {
            return;
        }
        this.userExe = new File(userSpecified);
        if (!this.userExe.exists()) {
            String msg = localStrings.getStringWithDefault("java_compiler.bad_user_compiler", "Can't locate user-specified Java Compiler for deployment.  Environmental Variable= {0}, Value = {1}", new Object[]{"com.sun.aas.deployment.java.compiler", userSpecified});
            logger.warning(msg);
            this.userExe = null;
            return;
        }
        this.userExe = FileUtils.safeGetCanonicalFile(this.userExe);
        String opts = JavaCompiler.getSystemPropertyIgnoreCase("com.sun.aas.deployment.java.compiler.options");
        if (!StringUtils.ok((String)opts)) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(opts);
        while (tok.hasMoreTokens()) {
            this.userOptions.add(tok.nextToken());
        }
    }

    private void initFastjavac() {
        if (this.installRoot == null || this.jdkDir == null) {
            return;
        }
        String fastName = OS.isWindows() ? "fastjavac.exe" : (OS.isSun() ? "fastjavac.sun" : (OS.isLinux() ? "fastjavac.linux" : null));
        if (fastName == null) {
            return;
        }
        this.fastExe = new File(this.installRoot + "/studio4/bin/fastjavac/" + fastName);
        this.fastExe = this.fastExe.exists() ? FileUtils.safeGetCanonicalFile(this.fastExe) : null;
    }

    private void initJavac() {
        if (this.jdkDir == null) {
            return;
        }
        String javacName = OS.isWindows() ? "javac.exe" : "javac";
        this.javacExe = new File(this.jdkDir, "/bin/" + javacName);
        this.javacExe = this.javacExe.exists() ? FileUtils.safeGetCanonicalFile(this.javacExe) : null;
    }

    private static int getFastjavacTimeout() {
        if (fastJavacTimeout < 0) {
            fastJavacTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.Fastjavac.TimeoutMS", 4000, 1000, 300000);
        }
        return fastJavacTimeout;
    }

    private static int getJavacTimeout() {
        if (javacTimeout < 0) {
            javacTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.Javac.TimeoutMS", 30000, 1000, 900000);
        }
        return javacTimeout;
    }

    private static int getUserSpecifiedCompilerTimeout() {
        if (userTimeout < 0) {
            userTimeout = JavaCompiler.getTimeout("com.sun.aas.deployment.java.compiler.TimeoutMS", 30000, 1000, 900000);
        }
        return userTimeout;
    }
}

