/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.File;

public class GeneratedNames {
    private String homeImplClass;
    private String homeStubClass;
    private String remoteStubClass;
    private String ejbObjectImplClass;
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";

    public GeneratedNames(EjbDescriptor desc) {
        this.ejbObjectImplClass = desc.getEJBObjectImplClassName().replace('.', File.separatorChar) + ".class";
        this.homeImplClass = desc.getRemoteHomeImplClassName().replace('.', File.separatorChar) + ".class";
        this.homeStubClass = GeneratedNames.getStubName(desc.getHomeClassName()).replace('.', File.separatorChar) + ".class";
        this.remoteStubClass = GeneratedNames.getStubName(desc.getRemoteClassName()).replace('.', File.separatorChar) + ".class";
    }

    public static String getStubName(String fullName) {
        String className = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot != -1) {
            className = fullName.substring(lastDot + 1, fullName.length());
            packageName = fullName.substring(0, lastDot + 1);
        }
        String stubName = packageName + "_" + className + "_Stub";
        if (GeneratedNames.isSpecialPackage(fullName)) {
            stubName = ORG_OMG_STUB_PREFIX + stubName;
        }
        return stubName;
    }

    public String getEjbObjectImplClass() {
        return this.ejbObjectImplClass;
    }

    public String getHomeImplClass() {
        return this.homeImplClass;
    }

    public String getHomeStubClass() {
        return this.homeStubClass;
    }

    public String getRemoteStubClass() {
        return this.remoteStubClass;
    }

    private static boolean isSpecialPackage(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("javax.");
    }
}

