/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.verifier.statics;

import com.sun.corba.ee.org.apache.bcel.Repository;
import com.sun.corba.ee.org.apache.bcel.classfile.AccessFlags;
import com.sun.corba.ee.org.apache.bcel.classfile.Code;
import com.sun.corba.ee.org.apache.bcel.classfile.CodeException;
import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantClass;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantDouble;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantFieldref;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantFloat;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantInteger;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantLong;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantMethodref;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantNameAndType;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantString;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.classfile.Field;
import com.sun.corba.ee.org.apache.bcel.classfile.FieldOrMethod;
import com.sun.corba.ee.org.apache.bcel.classfile.JavaClass;
import com.sun.corba.ee.org.apache.bcel.classfile.LineNumber;
import com.sun.corba.ee.org.apache.bcel.classfile.LineNumberTable;
import com.sun.corba.ee.org.apache.bcel.classfile.LocalVariable;
import com.sun.corba.ee.org.apache.bcel.classfile.LocalVariableTable;
import com.sun.corba.ee.org.apache.bcel.classfile.Method;
import com.sun.corba.ee.org.apache.bcel.generic.ALOAD;
import com.sun.corba.ee.org.apache.bcel.generic.ANEWARRAY;
import com.sun.corba.ee.org.apache.bcel.generic.ASTORE;
import com.sun.corba.ee.org.apache.bcel.generic.ATHROW;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayType;
import com.sun.corba.ee.org.apache.bcel.generic.BREAKPOINT;
import com.sun.corba.ee.org.apache.bcel.generic.CHECKCAST;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.DLOAD;
import com.sun.corba.ee.org.apache.bcel.generic.DSTORE;
import com.sun.corba.ee.org.apache.bcel.generic.EmptyVisitor;
import com.sun.corba.ee.org.apache.bcel.generic.FLOAD;
import com.sun.corba.ee.org.apache.bcel.generic.FSTORE;
import com.sun.corba.ee.org.apache.bcel.generic.FieldInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.GETSTATIC;
import com.sun.corba.ee.org.apache.bcel.generic.GotoInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.IINC;
import com.sun.corba.ee.org.apache.bcel.generic.ILOAD;
import com.sun.corba.ee.org.apache.bcel.generic.IMPDEP1;
import com.sun.corba.ee.org.apache.bcel.generic.IMPDEP2;
import com.sun.corba.ee.org.apache.bcel.generic.INSTANCEOF;
import com.sun.corba.ee.org.apache.bcel.generic.INVOKEINTERFACE;
import com.sun.corba.ee.org.apache.bcel.generic.INVOKESPECIAL;
import com.sun.corba.ee.org.apache.bcel.generic.INVOKESTATIC;
import com.sun.corba.ee.org.apache.bcel.generic.INVOKEVIRTUAL;
import com.sun.corba.ee.org.apache.bcel.generic.ISTORE;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionHandle;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionList;
import com.sun.corba.ee.org.apache.bcel.generic.InvokeInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.JsrInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.LDC;
import com.sun.corba.ee.org.apache.bcel.generic.LDC2_W;
import com.sun.corba.ee.org.apache.bcel.generic.LLOAD;
import com.sun.corba.ee.org.apache.bcel.generic.LOOKUPSWITCH;
import com.sun.corba.ee.org.apache.bcel.generic.LSTORE;
import com.sun.corba.ee.org.apache.bcel.generic.LoadClass;
import com.sun.corba.ee.org.apache.bcel.generic.MULTIANEWARRAY;
import com.sun.corba.ee.org.apache.bcel.generic.NEW;
import com.sun.corba.ee.org.apache.bcel.generic.NEWARRAY;
import com.sun.corba.ee.org.apache.bcel.generic.ObjectType;
import com.sun.corba.ee.org.apache.bcel.generic.PUTSTATIC;
import com.sun.corba.ee.org.apache.bcel.generic.RET;
import com.sun.corba.ee.org.apache.bcel.generic.ReturnInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.TABLESWITCH;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.verifier.PassVerifier;
import com.sun.corba.ee.org.apache.bcel.verifier.VerificationResult;
import com.sun.corba.ee.org.apache.bcel.verifier.Verifier;
import com.sun.corba.ee.org.apache.bcel.verifier.VerifierFactory;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.AssertionViolatedException;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.ClassConstraintException;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.InvalidMethodException;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.StaticCodeConstraintException;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import com.sun.corba.ee.org.apache.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import com.sun.corba.ee.org.apache.bcel.verifier.statics.IntList;
import java.io.Serializable;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier verifier, int n) {
        this.myOwner = verifier;
        this.method_no = n;
    }

    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methodArray = javaClass.getMethods();
            if (this.method_no >= methodArray.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methodArray[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException runtimeException) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult verificationResult = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult = new VerificationResult(2, classConstraintException.getMessage());
                return verificationResult;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException staticCodeConstraintException) {
                verificationResult = new VerificationResult(2, staticCodeConstraintException.getMessage());
            }
            return verificationResult;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int n;
        int n2;
        int n3;
        Cloneable[] cloneableArray;
        int[] nArray = this.instructionList.getInstructionPositions();
        int n4 = this.code.getCode().length;
        LineNumberTable lineNumberTable = this.code.getLineNumberTable();
        if (lineNumberTable != null) {
            cloneableArray = lineNumberTable.getLineNumberTable();
            IntList intList = new IntList();
            block0: for (n3 = 0; n3 < cloneableArray.length; ++n3) {
                for (int i = 0; i < nArray.length; ++i) {
                    n2 = ((LineNumber)cloneableArray[n3]).getStartPC();
                    if (nArray[i] != n2) continue;
                    if (intList.contains(n2)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + n2 + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    intList.add(n2);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + ((LineNumber)cloneableArray[n3]).getStartPC() + "') that does not exist.");
            }
        }
        cloneableArray = this.code.getAttributes();
        for (int i = 0; i < cloneableArray.length; ++i) {
            LocalVariableTable localVariableTable;
            if (!(cloneableArray[i] instanceof LocalVariableTable) || (localVariableTable = (LocalVariableTable)cloneableArray[i]) == null) continue;
            LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
            for (n2 = 0; n2 < localVariableArray.length; ++n2) {
                n = localVariableArray[n2].getStartPC();
                int n5 = localVariableArray[n2].getLength();
                if (!Pass3aVerifier.contains(nArray, n)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + n + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(nArray, n + n5) || n + n5 == n4) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (n + n5) + "') that does not exist.");
            }
        }
        CodeException[] codeExceptionArray = this.code.getExceptionTable();
        for (n3 = 0; n3 < codeExceptionArray.length; ++n3) {
            int n6 = codeExceptionArray[n3].getStartPC();
            n2 = codeExceptionArray[n3].getEndPC();
            n = codeExceptionArray[n3].getHandlerPC();
            if (n6 >= n2) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n3] + "' that has its start_pc ('" + n6 + "') not smaller than its end_pc ('" + n2 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n6)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n3] + "' that has a non-existant bytecode offset as its start_pc ('" + n6 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n2) && n2 != n4) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n3] + "' that has a non-existant bytecode offset as its end_pc ('" + n6 + "') [that is also not equal to code_length ('" + n4 + "')].");
            }
            if (Pass3aVerifier.contains(nArray, n)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n3] + "' that has a non-existant bytecode offset as its handler_pc ('" + n + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        Instruction instruction;
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            if (instruction instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (instruction instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(instruction instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        instruction = this.instructionList.getEnd().getInstruction();
        if (!(instruction instanceof ReturnInstruction || instruction instanceof RET || instruction instanceof GotoInstruction || instruction instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor instOperandConstraintVisitor = new InstOperandConstraintVisitor(constantPoolGen);
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            Instruction instruction = instructionHandle.getInstruction();
            if (instruction instanceof JsrInstruction) {
                InstructionHandle instructionHandle2 = ((JsrInstruction)instruction).getTarget();
                if (instructionHandle2 == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + instructionHandle + "' as its target.");
                }
                if (!(instructionHandle2.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + instructionHandle + "' targets '" + instructionHandle2 + "'.");
                }
            }
            instructionHandle.accept(instOperandConstraintVisitor);
        }
    }

    private static boolean contains(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen constantPoolGen) {
            this.cpg = constantPoolGen;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction instruction, String string) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + instruction + " constraint violated: " + string);
        }

        private void indexValid(Instruction instruction, int n) {
            if (n < 0 || n >= this.cpg.getSize()) {
                this.constraintViolated(instruction, "Illegal constant pool index '" + n + "'.");
            }
        }

        public void visitLoadClass(LoadClass loadClass) {
            Verifier verifier;
            VerificationResult verificationResult;
            ObjectType objectType = loadClass.getLoadClassType(this.cpg);
            if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + verificationResult + "'.");
            }
        }

        public void visitLDC(LDC lDC) {
            this.indexValid(lDC, lDC.getIndex());
            Constant constant = this.cpg.getConstant(lDC.getIndex());
            if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
                this.constraintViolated(lDC, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + constant + "'.");
            }
        }

        public void visitLDC2_W(LDC2_W lDC2_W) {
            this.indexValid(lDC2_W, lDC2_W.getIndex());
            Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
            if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
                this.constraintViolated(lDC2_W, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + constant + "'.");
            }
            try {
                this.indexValid(lDC2_W, lDC2_W.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException staticCodeInstructionOperandConstraintException) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        public void visitFieldInstruction(FieldInstruction fieldInstruction) {
            this.indexValid(fieldInstruction, fieldInstruction.getIndex());
            Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
            if (!(constant instanceof ConstantFieldref)) {
                this.constraintViolated(fieldInstruction, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + constant + "'.");
            }
            String string = fieldInstruction.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(fieldInstruction.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            FieldOrMethod fieldOrMethod = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string)) continue;
                fieldOrMethod = fieldArray[i];
                break;
            }
            if (fieldOrMethod == null) {
                this.constraintViolated(fieldInstruction, "Referenced field '" + string + "' does not exist in class '" + javaClass.getClassName() + "'.");
            } else {
                Type type;
                Type type2 = Type.getType(fieldOrMethod.getSignature());
                if (!type2.equals(type = fieldInstruction.getType(this.cpg))) {
                    this.constraintViolated(fieldInstruction, "Referenced field '" + string + "' has type '" + type2 + "' instead of '" + type + "' as expected.");
                }
            }
        }

        public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
            Object object;
            Object object2;
            Serializable serializable;
            this.indexValid(invokeInstruction, invokeInstruction.getIndex());
            if (invokeInstruction instanceof INVOKEVIRTUAL || invokeInstruction instanceof INVOKESPECIAL || invokeInstruction instanceof INVOKESTATIC) {
                serializable = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(serializable instanceof ConstantMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_Methodref but a '" + serializable + "'.");
                } else {
                    object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)serializable).getNameAndTypeIndex());
                    object = (ConstantUtf8)this.cpg.getConstant(object2.getNameIndex());
                    if (((ConstantUtf8)object).getBytes().equals("<init>") && !(invokeInstruction instanceof INVOKESPECIAL)) {
                        this.constraintViolated(invokeInstruction, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!((ConstantUtf8)object).getBytes().equals("<init>") && ((ConstantUtf8)object).getBytes().startsWith("<")) {
                        this.constraintViolated(invokeInstruction, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                serializable = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(serializable instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + serializable + "'.");
                }
                if (((String)(object = ((ConstantUtf8)this.cpg.getConstant((object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)serializable).getNameAndTypeIndex())).getNameIndex())).getBytes())).equals("<init>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<init>'.");
                }
                if (((String)object).equals("<clinit>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<clinit>'.");
                }
            }
            serializable = invokeInstruction.getReturnType(this.cpg);
            if (serializable instanceof ArrayType) {
                serializable = ((ArrayType)serializable).getBasicType();
            }
            if (serializable instanceof ObjectType && ((VerificationResult)(object = (object2 = VerifierFactory.getVerifier(((ObjectType)serializable).getClassName())).doPass2())).getStatus() != 1) {
                this.constraintViolated(invokeInstruction, "Return type class/interface could not be verified successfully: '" + ((VerificationResult)object).getMessage() + "'.");
            }
            object2 = invokeInstruction.getArgumentTypes(this.cpg);
            for (int i = 0; i < ((Type[])object2).length; ++i) {
                Verifier verifier;
                VerificationResult verificationResult;
                serializable = object2[i];
                if (serializable instanceof ArrayType) {
                    serializable = ((ArrayType)serializable).getBasicType();
                }
                if (!(serializable instanceof ObjectType) || (verificationResult = (verifier = VerifierFactory.getVerifier(((ObjectType)serializable).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(invokeInstruction, "Argument type class/interface could not be verified successfully: '" + verificationResult.getMessage() + "'.");
            }
        }

        public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
            this.indexValid(iNSTANCEOF, iNSTANCEOF.getIndex());
            Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(iNSTANCEOF, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitCHECKCAST(CHECKCAST cHECKCAST) {
            this.indexValid(cHECKCAST, cHECKCAST.getIndex());
            Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(cHECKCAST, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitNEW(NEW nEW) {
            this.indexValid(nEW, nEW.getIndex());
            Constant constant = this.cpg.getConstant(nEW.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(nEW, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            } else {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)constant).getNameIndex());
                Type type = Type.getType("L" + constantUtf8.getBytes() + ";");
                if (type instanceof ArrayType) {
                    this.constraintViolated(nEW, "NEW must not be used to create an array.");
                }
            }
        }

        public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
            Type type;
            short s;
            this.indexValid(mULTIANEWARRAY, mULTIANEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(mULTIANEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((s = mULTIANEWARRAY.getDimensions()) < 1) {
                this.constraintViolated(mULTIANEWARRAY, "Number of dimensions to create must be greater than zero.");
            }
            if ((type = mULTIANEWARRAY.getType(this.cpg)) instanceof ArrayType) {
                int n = ((ArrayType)type).getDimensions();
                if (n < s) {
                    this.constraintViolated(mULTIANEWARRAY, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + type + "'.");
                }
            } else {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
            int n;
            Type type;
            this.indexValid(aNEWARRAY, aNEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(aNEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(aNEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((type = aNEWARRAY.getType(this.cpg)) instanceof ArrayType && (n = ((ArrayType)type).getDimensions()) >= 255) {
                this.constraintViolated(aNEWARRAY, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        public void visitNEWARRAY(NEWARRAY nEWARRAY) {
            byte by = nEWARRAY.getTypecode();
            if (by != 4 && by != 5 && by != 6 && by != 7 && by != 8 && by != 9 && by != 10 && by != 11) {
                this.constraintViolated(nEWARRAY, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        public void visitILOAD(ILOAD iLOAD) {
            int n = iLOAD.getIndex();
            if (n < 0) {
                this.constraintViolated(iLOAD, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(iLOAD, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitFLOAD(FLOAD fLOAD) {
            int n = fLOAD.getIndex();
            if (n < 0) {
                this.constraintViolated(fLOAD, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(fLOAD, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitALOAD(ALOAD aLOAD) {
            int n = aLOAD.getIndex();
            if (n < 0) {
                this.constraintViolated(aLOAD, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(aLOAD, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitISTORE(ISTORE iSTORE) {
            int n = iSTORE.getIndex();
            if (n < 0) {
                this.constraintViolated(iSTORE, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(iSTORE, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitFSTORE(FSTORE fSTORE) {
            int n = fSTORE.getIndex();
            if (n < 0) {
                this.constraintViolated(fSTORE, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(fSTORE, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitASTORE(ASTORE aSTORE) {
            int n = aSTORE.getIndex();
            if (n < 0) {
                this.constraintViolated(aSTORE, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(aSTORE, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitIINC(IINC iINC) {
            int n = iINC.getIndex();
            if (n < 0) {
                this.constraintViolated(iINC, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(iINC, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitRET(RET rET) {
            int n = rET.getIndex();
            if (n < 0) {
                this.constraintViolated(rET, "Index '" + n + "' must be non-negative.");
            } else {
                int n2 = this.max_locals() - 1;
                if (n > n2) {
                    this.constraintViolated(rET, "Index '" + n + "' must not be greater than max_locals-1 '" + n2 + "'.");
                }
            }
        }

        public void visitLLOAD(LLOAD lLOAD) {
            int n = lLOAD.getIndex();
            if (n < 0) {
                this.constraintViolated(lLOAD, "Index '" + n + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n2 = this.max_locals() - 2;
                if (n > n2) {
                    this.constraintViolated(lLOAD, "Index '" + n + "' must not be greater than max_locals-2 '" + n2 + "'.");
                }
            }
        }

        public void visitDLOAD(DLOAD dLOAD) {
            int n = dLOAD.getIndex();
            if (n < 0) {
                this.constraintViolated(dLOAD, "Index '" + n + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n2 = this.max_locals() - 2;
                if (n > n2) {
                    this.constraintViolated(dLOAD, "Index '" + n + "' must not be greater than max_locals-2 '" + n2 + "'.");
                }
            }
        }

        public void visitLSTORE(LSTORE lSTORE) {
            int n = lSTORE.getIndex();
            if (n < 0) {
                this.constraintViolated(lSTORE, "Index '" + n + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n2 = this.max_locals() - 2;
                if (n > n2) {
                    this.constraintViolated(lSTORE, "Index '" + n + "' must not be greater than max_locals-2 '" + n2 + "'.");
                }
            }
        }

        public void visitDSTORE(DSTORE dSTORE) {
            int n = dSTORE.getIndex();
            if (n < 0) {
                this.constraintViolated(dSTORE, "Index '" + n + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n2 = this.max_locals() - 2;
                if (n > n2) {
                    this.constraintViolated(dSTORE, "Index '" + n + "' must not be greater than max_locals-2 '" + n2 + "'.");
                }
            }
        }

        public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
            int[] nArray = lOOKUPSWITCH.getMatchs();
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == n && i != 0) {
                    this.constraintViolated(lOOKUPSWITCH, "Match '" + nArray[i] + "' occurs more than once.");
                }
                if (nArray[i] < n) {
                    this.constraintViolated(lOOKUPSWITCH, "Lookup table must be sorted but isn't.");
                    continue;
                }
                n = nArray[i];
            }
        }

        public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        }

        public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
            String string = pUTSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string)) continue;
                accessFlags = fieldArray[i];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (accessFlags.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(pUTSTATIC.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + pUTSTATIC.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
            String string2 = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
            if (!javaClass.isClass() && !string2.equals("<clinit>")) {
                this.constraintViolated(pUTSTATIC, "Interface field '" + accessFlags + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        public void visitGETSTATIC(GETSTATIC gETSTATIC) {
            String string = gETSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(gETSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string)) continue;
                accessFlags = fieldArray[i];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(gETSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
            String string = iNVOKEINTERFACE.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKEINTERFACE.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKEINTERFACE.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKEINTERFACE.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced method '" + iNVOKEINTERFACE.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (javaClass.isClass()) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced class '" + javaClass.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
            JavaClass javaClass;
            String string = iNVOKESPECIAL.getClassName(this.cpg);
            JavaClass javaClass2 = Repository.lookupClass(string);
            Method[] methodArray = javaClass2.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKESPECIAL, "Referenced method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass2.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((javaClass = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(javaClass, javaClass2) && !javaClass.equals(javaClass2) && !iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
                int n = -1;
                Method method2 = null;
                while (n != 0) {
                    n = javaClass.getSuperclassNameIndex();
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                    Method[] methodArray2 = javaClass.getMethods();
                    for (int i = 0; i < methodArray2.length; ++i) {
                        if (!methodArray2[i].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray2[i].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray2[i].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                        method2 = methodArray2[i];
                        break;
                    }
                    if (method2 == null) continue;
                }
                if (method2 == null) {
                    this.constraintViolated(iNVOKESPECIAL, "ACC_SUPER special lookup procedure not successful: method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
            String string = iNVOKESTATIC.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            AccessFlags accessFlags = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKESTATIC.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKESTATIC.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKESTATIC.getArgumentTypes(this.cpg))) continue;
                accessFlags = methodArray[i];
                break;
            }
            if (accessFlags == null) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
            String string = iNVOKEVIRTUAL.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(iNVOKEVIRTUAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i].getSignature()).equals(iNVOKEVIRTUAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i].getSignature()), iNVOKEVIRTUAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced method '" + iNVOKEVIRTUAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!javaClass.isClass()) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced class '" + javaClass.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].equals(objectArray2[i])) continue;
                return false;
            }
            return true;
        }
    }
}

