/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.ExceptionConstants;
import com.sun.corba.ee.org.apache.bcel.generic.AllocationInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayType;
import com.sun.corba.ee.org.apache.bcel.generic.BasicType;
import com.sun.corba.ee.org.apache.bcel.generic.ExceptionThrower;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.StackProducer;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.Visitor;
import com.sun.corba.ee.org.apache.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte by) {
        super((short)188, (short)2);
        this.type = by;
    }

    public NEWARRAY(BasicType basicType) {
        this(basicType.getType());
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + Constants.TYPE_NAMES[this.type];
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.type = byteSequence.readByte();
        this.length = (short)2;
    }

    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    public void accept(Visitor visitor) {
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitStackProducer(this);
        visitor.visitNEWARRAY(this);
    }
}

