/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.ExceptionConstants;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.generic.AllocationInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayType;
import com.sun.corba.ee.org.apache.bcel.generic.CPInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGenException;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.ExceptionThrower;
import com.sun.corba.ee.org.apache.bcel.generic.LoadClass;
import com.sun.corba.ee.org.apache.bcel.generic.ObjectType;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.Visitor;
import com.sun.corba.ee.org.apache.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int n, short s) {
        super((short)197, n);
        if (s < 1) {
            throw new ClassGenException("Invalid dimensions value: " + s);
        }
        this.dimensions = s;
        this.length = (short)4;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeByte(this.dimensions);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        this.dimensions = byteSequence.readByte();
        this.length = (short)4;
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index + " " + this.dimensions;
    }

    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.dimensions;
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] classArray = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, classArray, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return classArray;
    }

    public ObjectType getLoadClassType(ConstantPoolGen constantPoolGen) {
        Type type = this.getType(constantPoolGen);
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        return type instanceof ObjectType ? (ObjectType)type : null;
    }

    public void accept(Visitor visitor) {
        visitor.visitLoadClass(this);
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitMULTIANEWARRAY(this);
    }
}

