/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantClass;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGenException;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.IndexedInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.TypedInstruction;
import com.sun.corba.ee.org.apache.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short s, int n) {
        super(s, (short)3);
        this.setIndex(n);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        String string = constantPool.constantToString(constant);
        if (constant instanceof ConstantClass) {
            string = string.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + string;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.setIndex(byteSequence.readUnsignedShort());
        this.length = (short)3;
    }

    public final int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        ConstantPool constantPool = constantPoolGen.getConstantPool();
        String string = constantPool.getConstantString(this.index, (byte)7);
        if (!string.startsWith("[")) {
            string = "L" + string + ";";
        }
        return Type.getType(string);
    }
}

