/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaClientRequestDispatcherImpl;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.LocalObject;

public class NoConnectionCacheImpl
extends LocalObject
implements ORBConfigurator {
    private static ThreadLocal connectionCache = new ThreadLocal();

    private static NCCConnectionCacheImpl getConnectionCache(ORB oRB) {
        NCCConnectionCacheImpl nCCConnectionCacheImpl = (NCCConnectionCacheImpl)connectionCache.get();
        if (nCCConnectionCacheImpl == null) {
            nCCConnectionCacheImpl = new NCCConnectionCacheImpl(oRB);
            connectionCache.set(nCCConnectionCacheImpl);
        }
        return nCCConnectionCacheImpl;
    }

    public void configure(DataCollector dataCollector, final ORB oRB) {
        CorbaContactInfoListFactory corbaContactInfoListFactory = new CorbaContactInfoListFactory(){

            public void setORB(ORB oRB2) {
            }

            public CorbaContactInfoList create(IOR iOR) {
                return new NCCContactInfoListImpl(oRB, iOR);
            }
        };
        oRB.setCorbaContactInfoListFactory(corbaContactInfoListFactory);
        NCCClientRequestDispatcherImpl nCCClientRequestDispatcherImpl = new NCCClientRequestDispatcherImpl();
        RequestDispatcherRegistry requestDispatcherRegistry = oRB.getRequestDispatcherRegistry();
        for (int i = 0; i < 63; ++i) {
            ClientRequestDispatcher clientRequestDispatcher = requestDispatcherRegistry.getClientRequestDispatcher(i);
            if (clientRequestDispatcher == null) continue;
            requestDispatcherRegistry.registerClientRequestDispatcher(nCCClientRequestDispatcherImpl, i);
        }
    }

    private static class NCCClientRequestDispatcherImpl
    extends CorbaClientRequestDispatcherImpl {
        private NCCClientRequestDispatcherImpl() {
        }

        public void endRequest(Broker broker, Object object, InputObject inputObject) {
            super.endRequest(broker, object, inputObject);
            NoConnectionCacheImpl.getConnectionCache((ORB)broker).remove(null);
        }
    }

    public static class NCCContactInfoListImpl
    extends CorbaContactInfoListImpl {
        public NCCContactInfoListImpl(ORB oRB, IOR iOR) {
            super(oRB, iOR);
        }

        public ContactInfo createContactInfo(String string, String string2, int n) {
            return new NCCContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), string, string2, n);
        }
    }

    private static class NCCContactInfoImpl
    extends SocketOrChannelContactInfoImpl {
        private boolean debug;

        public void dprint(String string) {
            ORBUtility.dprint("NCCContactInfoImpl", string);
        }

        public NCCContactInfoImpl(ORB oRB, CorbaContactInfoList corbaContactInfoList, IOR iOR, short s, String string, String string2, int n) {
            super(oRB, corbaContactInfoList, iOR, s, string, string2, n);
            this.debug = oRB.transportDebugFlag;
        }

        public boolean shouldCacheConnection() {
            if (this.debug) {
                this.dprint("shouldCacheConnection : returns false");
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection createConnection() {
            if (this.debug) {
                this.dprint("createConnection->");
            }
            try {
                NCCConnectionImpl nCCConnectionImpl = new NCCConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
                if (this.debug) {
                    this.dprint("createConnection: created " + nCCConnectionImpl);
                }
                NCCConnectionCacheImpl nCCConnectionCacheImpl = NoConnectionCacheImpl.getConnectionCache(this.orb);
                nCCConnectionCacheImpl.put(this, nCCConnectionImpl);
                nCCConnectionImpl.setConnectionCache(nCCConnectionCacheImpl);
                NCCConnectionImpl nCCConnectionImpl2 = nCCConnectionImpl;
                return nCCConnectionImpl2;
            }
            finally {
                if (this.debug) {
                    this.dprint("createConnection<-");
                }
            }
        }
    }

    private static class NCCConnectionImpl
    extends SocketOrChannelConnectionImpl {
        private static int count = 0;
        private int myCount = count++;
        private boolean debug;

        public void dprint(String string) {
            ORBUtility.dprint("NCCConnectionImpl", string);
        }

        public NCCConnectionImpl(ORB oRB, CorbaContactInfo corbaContactInfo, String string, String string2, int n) {
            super(oRB, corbaContactInfo, string, string2, n);
            if (this.debug) {
                this.dprint("constructed new NCCConnectionImpl: " + this.toString());
            }
        }

        public String toString() {
            return "NCCConnectionImpl(" + this.myCount + ")[" + super.toString() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            if (this.debug) {
                this.dprint("close->: " + this);
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                if (this.debug) {
                    this.dprint("close : caught IOException" + iOException);
                }
                iOException.printStackTrace();
            }
            finally {
                if (this.debug) {
                    this.dprint("close<-: " + this);
                }
            }
        }
    }

    private static class NCCConnectionCacheImpl
    extends CorbaConnectionCacheBase
    implements OutboundConnectionCache {
        private Map store = new HashMap();
        private boolean debug;
        private Connection connection = null;

        public void dprint(String string) {
            ORBUtility.dprint("NCCConnectionCacheImpl", string);
        }

        public NCCConnectionCacheImpl() {
            this(null);
        }

        public NCCConnectionCacheImpl(ORB oRB) {
            super(oRB, "Dummy", "Dummy");
            this.debug = oRB.transportDebugFlag;
        }

        public Collection values() {
            return this.store.values();
        }

        protected Object backingStore() {
            return this.store;
        }

        protected void registerWithMonitoring() {
        }

        public Connection get(ContactInfo contactInfo) {
            return this.connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ContactInfo contactInfo, Connection connection) {
            if (this.debug) {
                this.dprint("put-> " + connection);
            }
            try {
                this.remove(contactInfo);
                this.connection = connection;
            }
            finally {
                if (this.debug) {
                    this.dprint("put<-");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ContactInfo contactInfo) {
            if (this.debug) {
                this.dprint("remove->");
            }
            try {
                if (this.connection != null) {
                    if (this.debug) {
                        this.dprint("remove: closing connection " + this.connection);
                    }
                    this.connection.close();
                    this.connection = null;
                } else if (this.debug) {
                    this.dprint("remove: connection is null");
                }
            }
            finally {
                if (this.debug) {
                    this.dprint("remove<-");
                }
            }
        }
    }
}

