/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior;

import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.ior.EncapsulationUtility;
import com.sun.corba.ee.impl.logging.IORSystemException;
import com.sun.corba.ee.impl.orbutil.HexOutputStream;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.IORTemplateList;
import com.sun.corba.ee.spi.ior.IdentifiableContainerBase;
import com.sun.corba.ee.spi.ior.IdentifiableFactoryFinder;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IORHelper;

public class IORImpl
extends IdentifiableContainerBase
implements IOR {
    private String typeId;
    private ORB factory = null;
    IORSystemException wrapper;
    private IORTemplateList iortemps = null;

    public ORB getORB() {
        return this.factory;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IOR)) {
            return false;
        }
        IOR iOR = (IOR)object;
        return super.equals(object) && this.typeId.equals(iOR.getTypeId());
    }

    public int hashCode() {
        return super.hashCode() ^ this.typeId.hashCode();
    }

    public IORImpl(ORB oRB) {
        this(oRB, "");
    }

    public IORImpl(ORB oRB, String string) {
        this.factory = oRB;
        this.wrapper = IORSystemException.get(oRB, "oa.ior");
        this.typeId = string;
    }

    public IORImpl(ORB oRB, String string, IORTemplate iORTemplate, ObjectId objectId) {
        this(oRB, string);
        this.iortemps = IORFactories.makeIORTemplateList();
        this.iortemps.add(iORTemplate);
        this.addTaggedProfiles(iORTemplate, objectId);
        this.makeImmutable();
    }

    private void addTaggedProfiles(IORTemplate iORTemplate, ObjectId objectId) {
        ObjectKeyTemplate objectKeyTemplate = iORTemplate.getObjectKeyTemplate();
        Iterator iterator = iORTemplate.iterator();
        while (iterator.hasNext()) {
            TaggedProfileTemplate taggedProfileTemplate = (TaggedProfileTemplate)iterator.next();
            TaggedProfile taggedProfile = taggedProfileTemplate.create(objectKeyTemplate, objectId);
            this.add(taggedProfile);
        }
    }

    public IORImpl(ORB oRB, String string, IORTemplateList iORTemplateList, ObjectId objectId) {
        this(oRB, string);
        this.iortemps = iORTemplateList;
        Iterator iterator = iORTemplateList.iterator();
        while (iterator.hasNext()) {
            IORTemplate iORTemplate = (IORTemplate)iterator.next();
            this.addTaggedProfiles(iORTemplate, objectId);
        }
        this.makeImmutable();
    }

    public IORImpl(InputStream inputStream) {
        this((ORB)((Object)inputStream.orb()), inputStream.read_string());
        IdentifiableFactoryFinder identifiableFactoryFinder = this.factory.getTaggedProfileFactoryFinder();
        EncapsulationUtility.readIdentifiableSequence(this, identifiableFactoryFinder, inputStream);
        this.makeImmutable();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void write(OutputStream outputStream) {
        outputStream.write_string(this.typeId);
        EncapsulationUtility.writeIdentifiableSequence(this, outputStream);
    }

    public String stringify() {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.factory);
        encapsOutputStream.putEndian();
        this.write(encapsOutputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            encapsOutputStream.writeTo(new HexOutputStream(stringWriter));
        }
        catch (IOException iOException) {
            throw this.wrapper.stringifyWriteError(iOException);
        }
        return "IOR:" + stringWriter;
    }

    public synchronized void makeImmutable() {
        this.makeElementsImmutable();
        if (this.iortemps != null) {
            this.iortemps.makeImmutable();
        }
        super.makeImmutable();
    }

    public org.omg.IOP.IOR getIOPIOR() {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.factory);
        this.write(encapsOutputStream);
        InputStream inputStream = (InputStream)encapsOutputStream.create_input_stream();
        return IORHelper.read((org.omg.CORBA.portable.InputStream)inputStream);
    }

    public boolean isNil() {
        return this.size() == 0;
    }

    public boolean isEquivalent(IOR iOR) {
        Iterator iterator = this.iterator();
        Iterator iterator2 = iOR.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            TaggedProfile taggedProfile;
            TaggedProfile taggedProfile2 = (TaggedProfile)iterator.next();
            if (taggedProfile2.isEquivalent(taggedProfile = (TaggedProfile)iterator2.next())) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    private void initializeIORTemplateList() {
        HashMap<ObjectKeyTemplate, IORTemplate> hashMap = new HashMap<ObjectKeyTemplate, IORTemplate>();
        this.iortemps = IORFactories.makeIORTemplateList();
        Iterator iterator = this.iterator();
        ObjectId objectId = null;
        while (iterator.hasNext()) {
            TaggedProfile taggedProfile = (TaggedProfile)iterator.next();
            TaggedProfileTemplate taggedProfileTemplate = taggedProfile.getTaggedProfileTemplate();
            ObjectKeyTemplate objectKeyTemplate = taggedProfile.getObjectKeyTemplate();
            if (objectId == null) {
                objectId = taggedProfile.getObjectId();
            } else if (!objectId.equals(taggedProfile.getObjectId())) {
                throw this.wrapper.badOidInIorTemplateList();
            }
            IORTemplate iORTemplate = (IORTemplate)hashMap.get(objectKeyTemplate);
            if (iORTemplate == null) {
                iORTemplate = IORFactories.makeIORTemplate(objectKeyTemplate);
                hashMap.put(objectKeyTemplate, iORTemplate);
                this.iortemps.add(iORTemplate);
            }
            iORTemplate.add(taggedProfileTemplate);
        }
        this.iortemps.makeImmutable();
    }

    public synchronized IORTemplateList getIORTemplates() {
        if (this.iortemps == null) {
            this.initializeIORTemplateList();
        }
        return this.iortemps;
    }

    public IIOPProfile getProfile() {
        IIOPProfile iIOPProfile = null;
        Iterator iterator = this.iteratorById(0);
        if (iterator.hasNext()) {
            iIOPProfile = (IIOPProfile)iterator.next();
        }
        if (iIOPProfile != null) {
            return iIOPProfile;
        }
        throw this.wrapper.iorMustHaveIiopProfile();
    }
}

