/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.corba.RequestImpl;
import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.CodecFactoryImpl;
import com.sun.corba.ee.impl.interceptors.InterceptorInvoker;
import com.sun.corba.ee.impl.interceptors.InterceptorList;
import com.sun.corba.ee.impl.interceptors.ORBInitInfoImpl;
import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.PIHandler;
import java.util.HashMap;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;

public class PIHandlerImpl
implements PIHandler {
    boolean printPushPopEnabled = false;
    int pushLevel = 0;
    private ORB orb;
    InterceptorsSystemException wrapper;
    ORBUtilSystemException orbutilWrapper;
    OMGSystemException omgWrapper;
    private int serverRequestIdCounter = 0;
    CodecFactory codecFactory = null;
    String[] arguments = null;
    private InterceptorList interceptorList;
    private boolean hasIORInterceptors;
    private boolean hasClientInterceptors;
    private boolean hasServerInterceptors;
    private InterceptorInvoker interceptorInvoker;
    private PICurrent current;
    private HashMap policyFactoryTable;
    private static final short[] REPLY_MESSAGE_TO_PI_REPLY_STATUS = new short[]{0, 2, 1, 3, 3, 4};
    private ThreadLocal threadLocalClientRequestInfoStack = new ThreadLocal(){

        protected Object initialValue() {
            return new RequestInfoStack();
        }
    };
    private ThreadLocal threadLocalServerRequestInfoStack = new ThreadLocal(){

        protected Object initialValue() {
            return new RequestInfoStack();
        }
    };

    private void printPush() {
        if (!this.printPushPopEnabled) {
            return;
        }
        this.printSpaces(this.pushLevel);
        ++this.pushLevel;
        System.out.println("PUSH");
    }

    private void printPop() {
        if (!this.printPushPopEnabled) {
            return;
        }
        --this.pushLevel;
        this.printSpaces(this.pushLevel);
        System.out.println("POP");
    }

    private void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
    }

    public PIHandlerImpl(ORB oRB, String[] stringArray) {
        this.orb = oRB;
        this.wrapper = InterceptorsSystemException.get(oRB, "rpc.protocol");
        this.orbutilWrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.omgWrapper = OMGSystemException.get(oRB, "rpc.protocol");
        this.arguments = stringArray;
        this.codecFactory = new CodecFactoryImpl((org.omg.CORBA.ORB)((Object)oRB));
        this.interceptorList = new InterceptorList(this.wrapper);
        this.current = new PICurrent(oRB);
        this.interceptorInvoker = new InterceptorInvoker(oRB, this.interceptorList, this.current);
        oRB.getLocalResolver().register("PICurrent", ClosureFactory.makeConstant((Object)this.current));
        oRB.getLocalResolver().register("CodecFactory", ClosureFactory.makeConstant(this.codecFactory));
    }

    public void initialize() {
        if (this.orb.getORBData().getORBInitializers() != null) {
            ORBInitInfoImpl oRBInitInfoImpl = this.createORBInitInfo();
            this.current.setORBInitializing(true);
            this.preInitORBInitializers(oRBInitInfoImpl);
            this.postInitORBInitializers(oRBInitInfoImpl);
            this.interceptorList.sortInterceptors();
            this.current.setORBInitializing(false);
            oRBInitInfoImpl.setStage(2);
            this.hasIORInterceptors = this.interceptorList.hasInterceptorsOfType(2);
            this.hasClientInterceptors = true;
            this.hasServerInterceptors = this.interceptorList.hasInterceptorsOfType(1);
            this.interceptorInvoker.setEnabled(true);
        }
    }

    public void destroyInterceptors() {
        this.interceptorList.destroyAll();
    }

    public void objectAdapterCreated(ObjectAdapter objectAdapter) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.objectAdapterCreated(objectAdapter);
    }

    public void adapterManagerStateChanged(int n, short s) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterManagerStateChanged(n, s);
    }

    public void adapterStateChanged(ObjectReferenceTemplate[] objectReferenceTemplateArray, short s) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterStateChanged(objectReferenceTemplateArray, s);
    }

    public void disableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ++requestInfoStack.disableCount;
    }

    public void enableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        --requestInfoStack.disableCount;
    }

    public void invokeClientPIStartingPoint() throws RemarshalException {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl clientRequestInfoImpl = this.peekClientRequestInfoImplStack();
        this.interceptorInvoker.invokeClientInterceptorStartingPoint(clientRequestInfoImpl);
        short s = clientRequestInfoImpl.getReplyStatus();
        if (s == 1 || s == 3) {
            Exception exception = this.invokeClientPIEndingPoint(this.convertPIReplyStatusToReplyMessage(s), clientRequestInfoImpl.getException());
            if (exception == null) {
                // empty if block
            }
            if (exception instanceof SystemException) {
                throw (SystemException)((Object)exception);
            }
            if (exception instanceof RemarshalException) {
                throw (RemarshalException)((Object)exception);
            }
            if (exception instanceof UserException || exception instanceof ApplicationException) {
                throw this.wrapper.exceptionInvalid();
            }
        } else if (s != -1) {
            throw this.wrapper.replyStatusNotInit();
        }
    }

    public Exception invokeClientPIEndingPoint(int n, Exception throwable) {
        if (!this.hasClientInterceptors) {
            return throwable;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return throwable;
        }
        short s = REPLY_MESSAGE_TO_PI_REPLY_STATUS[n];
        ClientRequestInfoImpl clientRequestInfoImpl = this.peekClientRequestInfoImplStack();
        clientRequestInfoImpl.setReplyStatus(s);
        clientRequestInfoImpl.setException((Exception)throwable);
        this.interceptorInvoker.invokeClientInterceptorEndingPoint(clientRequestInfoImpl);
        s = clientRequestInfoImpl.getReplyStatus();
        if (s == 3 || s == 4) {
            clientRequestInfoImpl.reset();
            clientRequestInfoImpl.setRetryRequest(true);
            throwable = new RemarshalException();
        } else if (s == 1 || s == 2) {
            throwable = clientRequestInfoImpl.getException();
        }
        return throwable;
    }

    public void initiateClientPIRequest(boolean bl) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl clientRequestInfoImpl = null;
        if (!requestInfoStack.empty()) {
            clientRequestInfoImpl = (ClientRequestInfoImpl)requestInfoStack.peek();
        }
        if (!bl && clientRequestInfoImpl != null && clientRequestInfoImpl.isDIIInitiate()) {
            clientRequestInfoImpl.setDIIInitiate(false);
        } else {
            if (clientRequestInfoImpl == null || !clientRequestInfoImpl.getRetryRequest()) {
                clientRequestInfoImpl = new ClientRequestInfoImpl(this.orb);
                requestInfoStack.push(clientRequestInfoImpl);
                this.printPush();
            }
            clientRequestInfoImpl.setRetryRequest(false);
            clientRequestInfoImpl.incrementEntryCount();
            if (bl) {
                clientRequestInfoImpl.setDIIInitiate(true);
            }
        }
    }

    public void cleanupClientPIRequest() {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl clientRequestInfoImpl = this.peekClientRequestInfoImplStack();
        short s = clientRequestInfoImpl.getReplyStatus();
        if (s == -1) {
            this.invokeClientPIEndingPoint(2, (Exception)this.wrapper.unknownRequestInvoke(CompletionStatus.COMPLETED_MAYBE));
        }
        clientRequestInfoImpl.decrementEntryCount();
        if (clientRequestInfoImpl.getEntryCount() == 0) {
            RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
            requestInfoStack.pop();
            this.printPop();
        }
    }

    public void setClientPIInfo(CorbaMessageMediator corbaMessageMediator) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setInfo(corbaMessageMediator);
    }

    public void setClientPIInfo(RequestImpl requestImpl) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setDIIRequest(requestImpl);
    }

    public void invokeServerPIStartingPoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorStartingPoint(serverRequestInfoImpl);
        this.serverPIHandleExceptions(serverRequestInfoImpl);
    }

    public void invokeServerPIIntermediatePoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorIntermediatePoint(serverRequestInfoImpl);
        serverRequestInfoImpl.releaseServant();
        this.serverPIHandleExceptions(serverRequestInfoImpl);
    }

    public void invokeServerPIEndingPoint(ReplyMessage replyMessage) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setReplyMessage(replyMessage);
        serverRequestInfoImpl.setCurrentExecutionPoint(2);
        if (!serverRequestInfoImpl.getAlreadyExecuted()) {
            int n = replyMessage.getReplyStatus();
            short s = REPLY_MESSAGE_TO_PI_REPLY_STATUS[n];
            if (s == 3 || s == 4) {
                serverRequestInfoImpl.setForwardRequest(replyMessage.getIOR());
            }
            Exception exception = serverRequestInfoImpl.getException();
            if (!serverRequestInfoImpl.isDynamic() && s == 2) {
                serverRequestInfoImpl.setException((Exception)this.omgWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE));
            }
            serverRequestInfoImpl.setReplyStatus(s);
            this.interceptorInvoker.invokeServerInterceptorEndingPoint(serverRequestInfoImpl);
            short s2 = serverRequestInfoImpl.getReplyStatus();
            Exception exception2 = serverRequestInfoImpl.getException();
            if (s2 == 1 && exception2 != exception) {
                throw (SystemException)((Object)exception2);
            }
            if (s2 == 3) {
                if (s != 3) {
                    IOR iOR = serverRequestInfoImpl.getForwardRequestIOR();
                    throw new ForwardException(this.orb, iOR);
                }
                if (serverRequestInfoImpl.isForwardRequestRaisedInEnding()) {
                    replyMessage.setIOR(serverRequestInfoImpl.getForwardRequestIOR());
                }
            }
        }
    }

    public void setServerPIInfo(Exception exception) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setException(exception);
    }

    public void setServerPIInfo(NVList nVList) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setDSIArguments(nVList);
    }

    public void setServerPIExceptionInfo(Any any) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setDSIException(any);
    }

    public void setServerPIInfo(Any any) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setDSIResult(any);
    }

    public void initializeServerPIInfo(CorbaMessageMediator corbaMessageMediator, ObjectAdapter objectAdapter, byte[] byArray, ObjectKeyTemplate objectKeyTemplate) {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl serverRequestInfoImpl = new ServerRequestInfoImpl(this.orb);
        requestInfoStack.push(serverRequestInfoImpl);
        this.printPush();
        corbaMessageMediator.setExecutePIInResponseConstructor(true);
        serverRequestInfoImpl.setInfo(corbaMessageMediator, objectAdapter, byArray, objectKeyTemplate);
    }

    public void setServerPIInfo(Object object, String string) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl serverRequestInfoImpl = this.peekServerRequestInfoImplStack();
        serverRequestInfoImpl.setInfo(object, string);
    }

    public void cleanupServerPIRequest() {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        requestInfoStack.pop();
        this.printPop();
    }

    private void serverPIHandleExceptions(ServerRequestInfoImpl serverRequestInfoImpl) {
        int n = serverRequestInfoImpl.getEndingPointCall();
        if (n == 1) {
            throw (SystemException)((Object)serverRequestInfoImpl.getException());
        }
        if (n == 2 && serverRequestInfoImpl.getForwardRequestException() != null) {
            IOR iOR = serverRequestInfoImpl.getForwardRequestIOR();
            throw new ForwardException(this.orb, iOR);
        }
    }

    private int convertPIReplyStatusToReplyMessage(short s) {
        int n = 0;
        for (int i = 0; i < REPLY_MESSAGE_TO_PI_REPLY_STATUS.length; ++i) {
            if (REPLY_MESSAGE_TO_PI_REPLY_STATUS[i] != s) continue;
            n = i;
            break;
        }
        return n;
    }

    private ClientRequestInfoImpl peekClientRequestInfoImplStack() {
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl clientRequestInfoImpl = null;
        if (requestInfoStack.empty()) {
            throw this.wrapper.clientInfoStackNull();
        }
        clientRequestInfoImpl = (ClientRequestInfoImpl)requestInfoStack.peek();
        return clientRequestInfoImpl;
    }

    private ServerRequestInfoImpl peekServerRequestInfoImplStack() {
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl serverRequestInfoImpl = null;
        if (requestInfoStack.empty()) {
            throw this.wrapper.serverInfoStackNull();
        }
        serverRequestInfoImpl = (ServerRequestInfoImpl)requestInfoStack.peek();
        return serverRequestInfoImpl;
    }

    private boolean isClientPIEnabledForThisThread() {
        RequestInfoStack requestInfoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        return requestInfoStack.disableCount == 0;
    }

    private void preInitORBInitializers(ORBInitInfoImpl oRBInitInfoImpl) {
        oRBInitInfoImpl.setStage(0);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer oRBInitializer = this.orb.getORBData().getORBInitializers()[i];
            if (oRBInitializer == null) continue;
            try {
                oRBInitializer.pre_init((ORBInitInfo)oRBInitInfoImpl);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void postInitORBInitializers(ORBInitInfoImpl oRBInitInfoImpl) {
        oRBInitInfoImpl.setStage(1);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer oRBInitializer = this.orb.getORBData().getORBInitializers()[i];
            if (oRBInitializer == null) continue;
            try {
                oRBInitializer.post_init((ORBInitInfo)oRBInitInfoImpl);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ORBInitInfoImpl createORBInitInfo() {
        ORBInitInfoImpl oRBInitInfoImpl = null;
        String string = this.orb.getORBData().getORBId();
        oRBInitInfoImpl = new ORBInitInfoImpl(this.orb, this.arguments, string, this.codecFactory);
        return oRBInitInfoImpl;
    }

    public void register_interceptor(Interceptor interceptor, int n) throws DuplicateName {
        if (n >= 3 || n < 0) {
            throw this.wrapper.typeOutOfRange(new Integer(n));
        }
        String string = interceptor.name();
        if (string == null) {
            throw this.wrapper.nameNull();
        }
        this.interceptorList.register_interceptor(interceptor, n);
    }

    public Current getPICurrent() {
        return this.current;
    }

    private void nullParam() throws BAD_PARAM {
        throw this.orbutilWrapper.nullParam();
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        if (any == null) {
            this.nullParam();
        }
        if (this.policyFactoryTable == null) {
            throw new PolicyError("There is no PolicyFactory Registered for type " + n, 0);
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policyFactoryTable.get(new Integer(n));
        if (policyFactory == null) {
            throw new PolicyError(" Could Not Find PolicyFactory for the Type " + n, 0);
        }
        Policy policy = policyFactory.create_policy(n, any);
        return policy;
    }

    public void registerPolicyFactory(int n, PolicyFactory policyFactory) {
        Integer n2;
        Object v;
        if (this.policyFactoryTable == null) {
            this.policyFactoryTable = new HashMap();
        }
        if ((v = this.policyFactoryTable.get(n2 = new Integer(n))) != null) {
            throw this.omgWrapper.policyFactoryRegFailed(new Integer(n));
        }
        this.policyFactoryTable.put(n2, policyFactory);
    }

    public synchronized int allocateServerRequestId() {
        return this.serverRequestIdCounter++;
    }

    private final class RequestInfoStack
    extends Stack {
        public int disableCount = 0;

        private RequestInfoStack() {
        }
    }
}

