/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo,
ORBInitInfoExt {
    private ORB orb;
    private InterceptorsSystemException wrapper;
    private ORBUtilSystemException orbutilWrapper;
    private OMGSystemException omgWrapper;
    private String[] args;
    private String orbId;
    private CodecFactory codecFactory;
    private int stage = 0;
    public static final int STAGE_PRE_INIT = 0;
    public static final int STAGE_POST_INIT = 1;
    public static final int STAGE_CLOSED = 2;
    private static final String MESSAGE_ORBINITINFO_INVALID = "ORBInitInfo object is only valid during ORB_init";

    ORBInitInfoImpl(ORB oRB, String[] stringArray, String string, CodecFactory codecFactory) {
        this.orb = oRB;
        this.wrapper = InterceptorsSystemException.get(oRB, "rpc.protocol");
        this.orbutilWrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.omgWrapper = OMGSystemException.get(oRB, "rpc.protocol");
        this.args = stringArray;
        this.orbId = string;
        this.codecFactory = codecFactory;
    }

    public ORB getORB() {
        return this.orb;
    }

    void setStage(int n) {
        this.stage = n;
    }

    private void checkStage() {
        if (this.stage == 2) {
            throw this.wrapper.orbinitinfoInvalid();
        }
    }

    public String[] arguments() {
        this.checkStage();
        return this.args;
    }

    public String orb_id() {
        this.checkStage();
        return this.orbId;
    }

    public CodecFactory codec_factory() {
        this.checkStage();
        return this.codecFactory;
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        this.checkStage();
        if (string == null) {
            this.nullParam();
        }
        if (object == null) {
            throw this.omgWrapper.rirWithNullObject();
        }
        try {
            this.orb.register_initial_reference(string, object);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            InvalidName invalidName2 = new InvalidName(invalidName.getMessage());
            invalidName2.initCause((Throwable)invalidName);
            throw invalidName2;
        }
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        this.checkStage();
        if (string == null) {
            this.nullParam();
        }
        if (this.stage == 0) {
            throw this.wrapper.rirInvalidPreInit();
        }
        Object object = null;
        try {
            object = this.orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
        return object;
    }

    public void add_client_request_interceptor_with_policy(ClientRequestInterceptor clientRequestInterceptor, Policy[] policyArray) throws DuplicateName {
        this.add_client_request_interceptor(clientRequestInterceptor);
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        this.checkStage();
        if (clientRequestInterceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)clientRequestInterceptor, 0);
    }

    public void add_server_request_interceptor_with_policy(ServerRequestInterceptor serverRequestInterceptor, Policy[] policyArray) throws DuplicateName, PolicyError {
        this.add_server_request_interceptor(serverRequestInterceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        this.checkStage();
        if (serverRequestInterceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)serverRequestInterceptor, 1);
    }

    public void add_ior_interceptor_with_policy(IORInterceptor iORInterceptor, Policy[] policyArray) throws DuplicateName, PolicyError {
        this.add_ior_interceptor(iORInterceptor);
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        this.checkStage();
        if (iORInterceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)iORInterceptor, 2);
    }

    public int allocate_slot_id() {
        this.checkStage();
        return ((PICurrent)this.orb.getPIHandler().getPICurrent()).allocateSlotId();
    }

    public void register_policy_factory(int n, PolicyFactory policyFactory) {
        this.checkStage();
        if (policyFactory == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().registerPolicyFactory(n, policyFactory);
    }

    private void nullParam() throws BAD_PARAM {
        throw this.orbutilWrapper.nullParam();
    }
}

