/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputStreamBase;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;

public class IDLJavaSerializationOutputStream
extends CDROutputStreamBase {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ByteBuffer byteBuffer;
    private IDLObjectOutputStream os;
    private IDLByteArrayOutputStream bos;
    private BufferManagerWrite bufferManager;
    private boolean directWrite;
    private boolean useDirectByteBuffer;
    private ByteBuffer pooledByteBuffer;
    static final int DIRECT_RW_LENGTH = 16;
    private boolean debug;
    protected ORBUtilSystemException wrapper;
    private static final LinkedList outputStreamPool = new LinkedList();

    IDLJavaSerializationOutputStream(boolean bl) {
        this.directWrite = bl;
    }

    public void init(ORB oRB, boolean bl, BufferManagerWrite bufferManagerWrite, byte by, boolean bl2) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)oRB);
        this.bufferManager = bufferManagerWrite;
        this.bos = IDLJavaSerializationOutputStream.getOrCreateByteArrayOutputStream(this.orb);
        this.wrapper = ORBUtilSystemException.get((com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)oRB), "rpc.encoding");
        if (!this.directWrite) {
            this.initObjectOutputStream();
        }
        this.useDirectByteBuffer = bl2;
        this.debug = ((com.sun.corba.ee.spi.orb.ORB)((java.lang.Object)oRB)).transportDebugFlag;
        if (this.debug) {
            ORBUtility.dprint(this, "IDLJavaSerializationOutputStream init");
        }
    }

    private static IDLByteArrayOutputStream getOrCreateByteArrayOutputStream(com.sun.corba.ee.spi.orb.ORB oRB) {
        IDLByteArrayOutputStream iDLByteArrayOutputStream = null;
        iDLByteArrayOutputStream = IDLJavaSerializationOutputStream.getOutputStreamObjectFromPool();
        if (iDLByteArrayOutputStream == null) {
            return new IDLByteArrayOutputStream(oRB.getORBData().getGIOPBufferSize());
        }
        return iDLByteArrayOutputStream;
    }

    private void initObjectOutputStream() {
        if (this.os != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.os = this.bos.getParent();
            if (this.os != null) {
                this.os.reset();
                this.os.setOrb(this.orb);
                return;
            }
            byte[] byArray = null;
            if (this.directWrite) {
                byArray = this.bos.toByteArray();
            }
            this.os = new IDLObjectOutputStream(this.bos, this.orb);
            this.os.flush();
            this.bos.reset(this.orb.getORBData().getGIOPBufferSize());
            if (this.directWrite) {
                this.bos.write(byArray, 0, byArray.length);
            }
            this.os.reset();
            this.bos.setParent(this.os);
        }
        catch (Exception exception) {
            throw this.wrapper.javaStreamInitFailed(exception);
        }
    }

    public final void write_boolean(boolean bl) {
        try {
            this.os.writeBoolean(bl);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_boolean");
        }
    }

    public final void write_char(char c) {
        try {
            this.os.writeChar(c);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_char");
        }
    }

    public final void write_wchar(char c) {
        this.write_char(c);
    }

    public final void write_octet(byte by) {
        try {
            if (this.directWrite && this.bos.size() < 16) {
                this.bos.write(by);
                if (this.bos.size() == 16) {
                    this.initObjectOutputStream();
                }
                return;
            }
            this.os.writeByte(by);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_octet");
        }
    }

    public final void write_short(short s) {
        try {
            this.os.writeShort(s);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_short");
        }
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_long(int n) {
        try {
            if (this.directWrite && this.bos.size() < 16) {
                this.bos.write((byte)(n >>> 24 & 0xFF));
                this.bos.write((byte)(n >>> 16 & 0xFF));
                this.bos.write((byte)(n >>> 8 & 0xFF));
                this.bos.write((byte)(n >>> 0 & 0xFF));
                if (this.bos.size() == 16) {
                    this.initObjectOutputStream();
                } else if (this.bos.size() > 16) {
                    this.wrapper.javaSerializationException("write_long");
                }
                return;
            }
            this.os.writeInt(n);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_long");
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_longlong(long l) {
        try {
            this.os.writeLong(l);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_longlong");
        }
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_float(float f) {
        try {
            this.os.writeFloat(f);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_float");
        }
    }

    public final void write_double(double d) {
        try {
            this.os.writeDouble(d);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_double");
        }
    }

    public final void write_string(String string) {
        try {
            this.os.writeUTF(string);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_string");
        }
    }

    public final void write_wstring(String string) {
        try {
            this.os.writeObject(string);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_wstring");
        }
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_boolean(blArray[n + i]);
        }
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_char(cArray[n + i]);
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        this.write_char_array(cArray, n, n2);
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        try {
            this.os.write(byArray, n, n2);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_octet_array");
        }
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_short(sArray[n + i]);
        }
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_long(nArray[n + i]);
        }
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_longlong(lArray[n + i]);
        }
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_float(fArray[n + i]);
        }
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_double(dArray[n + i]);
        }
    }

    public final void write_Object(Object object) {
        if (object == null) {
            IOR iOR = IORFactories.makeIOR(this.orb);
            iOR.write(this.parent);
            return;
        }
        if (object instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR iOR = ORBUtility.connectAndGetIOR(this.orb, object);
        iOR.write(this.parent);
    }

    public final void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    public final void write_any(Any any) {
        if (any == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
    }

    public final void write_Principal(Principal principal) {
        throw this.wrapper.giopVersionError();
    }

    public final void write_fixed(BigDecimal bigDecimal) {
        this.write_value(bigDecimal);
    }

    public final ORB orb() {
        return this.orb;
    }

    public final void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    public final void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public final void write_value(Serializable serializable, String string) {
        try {
            this.os.writeObject(serializable);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_value");
        }
    }

    public final void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.write_value(serializable, (String)null);
    }

    public final void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public final void start_block() {
        throw this.wrapper.giopVersionError();
    }

    public final void end_block() {
        throw this.wrapper.giopVersionError();
    }

    public final void putEndian() {
        this.write_boolean(false);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.os.flush();
            this.bos.writeTo(outputStream);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"writeTo");
        }
    }

    public final byte[] toByteArray() {
        try {
            this.os.flush();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"toByteArray");
        }
        return this.bos.toByteArray();
    }

    public final void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public final void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[n + i]);
        }
    }

    public final String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    public final int getSize() {
        try {
            this.os.flush();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_boolean");
        }
        return this.bos.size();
    }

    public final int getIndex() {
        return this.getSize();
    }

    protected int getRealIndex(int n) {
        return this.getSize();
    }

    public final void setIndex(int n) {
        throw this.wrapper.giopVersionError();
    }

    public final ByteBuffer getByteBuffer() {
        ByteBufferWithInfo byteBufferWithInfo = this.getByteBufferWithInfo();
        return byteBufferWithInfo.byteBuffer;
    }

    public final void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    public final boolean isLittleEndian() {
        return false;
    }

    public ByteBufferWithInfo getByteBufferWithInfo() {
        ByteBuffer byteBuffer;
        try {
            this.os.flush();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"getByteBufferWithInfo");
        }
        if (!this.directWrite || !this.useDirectByteBuffer) {
            byteBuffer = ByteBuffer.wrap(this.bos.toByteArray());
        } else {
            this.pooledByteBuffer = byteBuffer = this.orb.getByteBufferPool().getByteBuffer(this.bos.size());
            this.bos.writeTo(byteBuffer);
        }
        return new ByteBufferWithInfo((ORB)((java.lang.Object)this.orb), byteBuffer, this.bos.size());
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        throw this.wrapper.giopVersionError();
    }

    public final BufferManagerWrite getBufferManager() {
        return this.bufferManager;
    }

    public final void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string;
        String string2;
        int n;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    private void write_fixed(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        byte by = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            byte by2 = (byte)Character.digit(c, 10);
            if (by2 == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (n4 % 2 == 0) {
                by = (byte)(by | by2);
                this.write_octet(by);
                by = 0;
            } else {
                by = (byte)(by | by2 << 4);
            }
            --n4;
        }
        by = n == -1 ? (byte)((byte)(by | 0xD)) : (byte)((byte)(by | 0xC));
        this.write_octet(by);
    }

    public final void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        this.bos.writeTo(outputStream);
    }

    public final GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    public final void writeIndirection(int n, int n2) {
        throw this.wrapper.giopVersionError();
    }

    void freeInternalCaches() {
    }

    public void alignOnBoundary(int n) {
        throw this.wrapper.giopVersionError();
    }

    public void setHeaderPadding(boolean bl) {
    }

    public void start_value(String string) {
        throw this.wrapper.giopVersionError();
    }

    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    public void write(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.bos == null) {
            return;
        }
        if (this.pooledByteBuffer != null) {
            this.orb.getByteBufferPool().releaseByteBuffer(this.pooledByteBuffer);
        }
        try {
            if (this.os != null) {
                this.os.flush();
            }
            this.bos.reset(this.orb.getORBData().getGIOPBufferSize());
        }
        catch (IOException iOException) {
            return;
        }
        IDLJavaSerializationOutputStream.putOutputStreamObjectToPool(this.bos);
        this.bos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putOutputStreamObjectToPool(IDLByteArrayOutputStream iDLByteArrayOutputStream) {
        LinkedList linkedList = outputStreamPool;
        synchronized (linkedList) {
            outputStreamPool.addLast(iDLByteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDLByteArrayOutputStream getOutputStreamObjectFromPool() {
        LinkedList linkedList = outputStreamPool;
        synchronized (linkedList) {
            if (outputStreamPool.size() != 0) {
                return (IDLByteArrayOutputStream)outputStreamPool.removeFirst();
            }
        }
        return null;
    }

    static final class IDLObjectOutputStream
    extends ObjectOutputStream {
        private com.sun.corba.ee.spi.orb.ORB orb;

        IDLObjectOutputStream(OutputStream outputStream, com.sun.corba.ee.spi.orb.ORB oRB) throws IOException {
            super(outputStream);
            this.orb = oRB;
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ IDLObjectOutputStream this$0;
                {
                    this.this$0 = iDLObjectOutputStream;
                }

                public java.lang.Object run() {
                    IDLObjectOutputStream.access$000(this.this$0, true);
                    return null;
                }
            });
        }

        protected final java.lang.Object replaceObject(java.lang.Object object) throws IOException {
            try {
                if (object instanceof Remote && !StubAdapter.isStub(object)) {
                    return Utility.autoConnect(object, (ORB)((java.lang.Object)this.orb), true);
                }
            }
            catch (Exception exception) {
                IOException iOException = new IOException("replaceObject failed");
                iOException.initCause(exception);
                throw iOException;
            }
            return object;
        }

        void setOrb(com.sun.corba.ee.spi.orb.ORB oRB) {
            this.orb = oRB;
        }

        static /* synthetic */ boolean access$000(IDLObjectOutputStream iDLObjectOutputStream, boolean bl) throws SecurityException {
            return iDLObjectOutputStream.enableReplaceObject(bl);
        }
    }

    static final class IDLByteArrayOutputStream
    extends OutputStream {
        private byte[] buf;
        private LinkedList bufQ;
        private int index;
        private int count;
        private IDLObjectOutputStream parent;

        IDLByteArrayOutputStream(int n) {
            this.buf = new byte[n];
            this.bufQ = new LinkedList();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.index + n2 > this.buf.length) {
                int n3 = this.buf.length - this.index;
                System.arraycopy(byArray, n, this.buf, this.index, n3);
                this.bufQ.addLast(this.buf);
                this.count += this.buf.length;
                this.buf = new byte[Math.max(this.buf.length << 1, n2 - n3)];
                System.arraycopy(byArray, n + n3, this.buf, 0, n2 - n3);
                this.index = n2 - n3;
            } else {
                System.arraycopy(byArray, n, this.buf, this.index, n2);
                this.index += n2;
            }
        }

        public void write(int n) throws IOException {
            if (this.index + 1 > this.buf.length) {
                this.bufQ.addLast(this.buf);
                this.count += this.buf.length;
                this.buf = new byte[this.buf.length << 1];
                this.index = 0;
            }
            this.buf[this.index] = (byte)n;
            ++this.index;
        }

        int size() {
            return this.count + this.index;
        }

        void writeTo(ByteBuffer byteBuffer) {
            Iterator iterator = this.bufQ.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                byteBuffer.put(byArray, 0, byArray.length);
            }
            byteBuffer.put(this.buf, 0, this.index);
        }

        void writeTo(OutputStream outputStream) throws IOException {
            Iterator iterator = this.bufQ.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                outputStream.write(byArray, 0, byArray.length);
            }
            outputStream.write(this.buf, 0, this.index);
        }

        void writeTo(org.omg.CORBA.portable.OutputStream outputStream) {
            outputStream.write_long(this.size());
            Iterator iterator = this.bufQ.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                outputStream.write_octet_array(byArray, 0, byArray.length);
            }
            outputStream.write_octet_array(this.buf, 0, this.index);
        }

        byte[] toByteArray() {
            int n = 0;
            byte[] byArray = new byte[this.size()];
            Iterator iterator = this.bufQ.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            }
            System.arraycopy(this.buf, 0, byArray, n, this.index);
            return byArray;
        }

        void setParent(IDLObjectOutputStream iDLObjectOutputStream) {
            this.parent = iDLObjectOutputStream;
        }

        IDLObjectOutputStream getParent() {
            return this.parent;
        }

        void reset(int n) {
            if (this.buf.length != n) {
                this.buf = new byte[n];
            }
            this.bufQ.clear();
            this.index = 0;
            this.count = 0;
        }
    }
}

