/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDRInputStreamBase;
import com.sun.corba.ee.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.util.JDKBridge;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;

public class IDLJavaSerializationInputStream
extends CDRInputStreamBase {
    private ORB orb;
    private IDLObjectInputStream is;
    private IDLByteArrayInputStream bis;
    private BufferManagerRead bufferManager;
    private ByteBuffer byteBuffer;
    private boolean directRead;
    private boolean markOn;
    private int peekIndex;
    private int peekCount;
    private LinkedList markedItemQ = new LinkedList();
    private boolean debug;
    protected ORBUtilSystemException wrapper;
    private static final LinkedList inputStreamPool = new LinkedList();
    private static byte[] streamHeader = new byte[4];
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;

    IDLJavaSerializationInputStream(boolean bl) {
        this.directRead = bl;
    }

    public void init(org.omg.CORBA.ORB oRB, ByteBuffer byteBuffer, int n, boolean bl, BufferManagerRead bufferManagerRead) {
        this.orb = (ORB)((java.lang.Object)oRB);
        this.bufferManager = bufferManagerRead;
        byteBuffer.position(0).limit(n);
        this.byteBuffer = byteBuffer;
        this.bis = IDLJavaSerializationInputStream.getOrCreateByteArrayInputStream(ORBUtility.getByteBufferArray(byteBuffer), this.orb);
        this.wrapper = ORBUtilSystemException.get((ORB)((java.lang.Object)oRB), "rpc.encoding");
        if (!this.directRead) {
            this.initObjectInputStream();
        }
        this.debug = ((ORB)((java.lang.Object)oRB)).transportDebugFlag;
        if (this.debug) {
            ORBUtility.dprint(this, "IDLJavaSerializationInputStream init");
        }
    }

    private static IDLByteArrayInputStream getOrCreateByteArrayInputStream(byte[] byArray, ORB oRB) {
        IDLByteArrayInputStream iDLByteArrayInputStream = null;
        iDLByteArrayInputStream = IDLJavaSerializationInputStream.getInputStreamObjectFromPool();
        if (iDLByteArrayInputStream == null) {
            return new IDLByteArrayInputStream(byArray);
        }
        iDLByteArrayInputStream.init(byArray);
        return iDLByteArrayInputStream;
    }

    private void initObjectInputStream() {
        if (this.is != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.is = this.bis.getParent();
            if (this.is != null) {
                this.is.setOrb(this.orb);
                return;
            }
            this.bis.save();
            this.bis.init(streamHeader);
            this.is = new IDLObjectInputStream(this.bis, this.orb);
            this.bis.restore();
            this.bis.setParent(this.is);
        }
        catch (Exception exception) {
            throw this.wrapper.javaStreamInitFailed(exception);
        }
    }

    private java.lang.Object readFromMarkedItemQ() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return this.markedItemQ.get(this.peekIndex++);
        }
        return null;
    }

    public boolean read_boolean() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Boolean)object;
        }
        try {
            boolean bl = this.is.readBoolean();
            if (this.markOn) {
                this.markedItemQ.addLast(bl);
            }
            return bl;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_boolean");
        }
    }

    public char read_char() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return ((Character)object).charValue();
        }
        try {
            char c = this.is.readChar();
            if (this.markOn) {
                this.markedItemQ.addLast(new Character(c));
            }
            return c;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_char");
        }
    }

    public char read_wchar() {
        return this.read_char();
    }

    public byte read_octet() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Byte)object;
        }
        try {
            byte by;
            if (this.directRead && this.bis.position() < 16) {
                byte by2 = (byte)this.bis.read();
                if (this.bis.position() == 16) {
                    this.initObjectInputStream();
                }
                by = by2;
            } else {
                by = this.is.readByte();
            }
            if (this.markOn) {
                this.markedItemQ.addLast(new Byte(by));
            }
            return by;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_octet");
        }
    }

    public short read_short() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Short)object;
        }
        try {
            short s = this.is.readShort();
            if (this.markOn) {
                this.markedItemQ.addLast(new Short(s));
            }
            return s;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_short");
        }
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Integer)object;
        }
        try {
            int n;
            if (this.directRead && this.bis.position() < 16) {
                int n2 = this.bis.read() << 24 & 0xFF000000;
                int n3 = this.bis.read() << 16 & 0xFF0000;
                int n4 = this.bis.read() << 8 & 0xFF00;
                int n5 = this.bis.read() << 0 & 0xFF;
                if (this.bis.position() == 16) {
                    this.initObjectInputStream();
                } else if (this.bis.position() > 16) {
                    this.wrapper.javaSerializationException("read_long");
                }
                n = n2 | n3 | n4 | n5;
            } else {
                n = this.is.readInt();
            }
            if (this.markOn) {
                this.markedItemQ.addLast(new Integer(n));
            }
            return n;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_long");
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Long)object;
        }
        try {
            long l = this.is.readLong();
            if (this.markOn) {
                this.markedItemQ.addLast(new Long(l));
            }
            return l;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_longlong");
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return ((Float)object).floatValue();
        }
        try {
            float f = this.is.readFloat();
            if (this.markOn) {
                this.markedItemQ.addLast(new Float(f));
            }
            return f;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_float");
        }
    }

    public double read_double() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Double)object;
        }
        try {
            double d = this.is.readDouble();
            if (this.markOn) {
                this.markedItemQ.addLast(new Double(d));
            }
            return d;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_double");
        }
    }

    public String read_string() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (String)object;
        }
        try {
            String string = this.is.readUTF();
            if (this.markOn) {
                this.markedItemQ.addLast(string);
            }
            return string;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_string");
        }
    }

    public String read_wstring() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (String)object;
        }
        try {
            String string = (String)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(string);
            }
            return string;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_wstring");
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            blArray[i + n] = this.read_boolean();
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_char();
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        this.read_char_array(cArray, n, n2);
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            byte[] byArray2 = (byte[])object;
            if (n2 != byArray2.length) {
                throw this.wrapper.javaSerializationException("read_octet_array");
            }
            System.arraycopy(byArray2, 0, byArray, n, n2);
            return;
        }
        try {
            int n3 = n;
            int n4 = n2;
            if (this.debug) {
                ORBUtility.dprint(this, "off: " + n3 + ", len: " + n4);
            }
            while (n4 > 0) {
                int n5 = this.is.read(byArray, n3, n4);
                n3 += n5;
                n4 -= n5;
                if (!this.debug) continue;
                ORBUtility.dprint(this, "off: " + n3 + ", len: " + n4);
            }
            if (this.markOn) {
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
                this.markedItemQ.addLast(byArray3);
            }
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_octet_array");
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.read_short();
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_long();
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[i + n] = this.read_float();
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[i + n] = this.read_double();
        }
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this.parent);
        return typeCodeImpl;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        try {
            typeCodeImpl.read_value(this.parent);
        }
        catch (MARSHAL mARSHAL) {
            if (typeCodeImpl.kind().value() != 29) {
                throw mARSHAL;
            }
            mARSHAL.printStackTrace();
        }
        any.read_value((org.omg.CORBA.portable.InputStream)this.parent, (TypeCode)typeCodeImpl);
        return any;
    }

    public Principal read_Principal() {
        throw this.wrapper.giopVersionError();
    }

    public BigDecimal read_fixed() {
        return (BigDecimal)this.read_value();
    }

    public Object read_Object(Class clazz) {
        IOR iOR = IORFactories.makeIOR(this.parent);
        if (iOR.isNil()) {
            return null;
        }
        PresentationManager.StubFactoryFactory stubFactoryFactory = ORB.getStubFactoryFactory();
        String string = iOR.getProfile().getCodebase();
        PresentationManager.StubFactory stubFactory = null;
        if (clazz == null) {
            RepositoryId repositoryId = RepositoryId.cache.getId(iOR.getTypeId());
            String string2 = repositoryId.getClassName();
            boolean bl = repositoryId.isIDLType();
            if (string2 == null || string2.equals("")) {
                stubFactory = null;
            } else {
                try {
                    stubFactory = stubFactoryFactory.createStubFactory(string2, bl, string, null, null);
                }
                catch (Exception exception) {
                    stubFactory = null;
                }
            }
        } else if (StubAdapter.isStubClass(clazz)) {
            stubFactory = PresentationDefaults.makeStaticStubFactory(clazz);
        } else {
            boolean bl = (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = IDLJavaSerializationInputStream.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz);
            stubFactory = stubFactoryFactory.createStubFactory(clazz.getName(), bl, string, clazz, clazz.getClassLoader());
        }
        return CDRInputStream_1_0.internalIORToObject(iOR, stubFactory, this.orb);
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public Serializable read_value() {
        java.lang.Object object = this.readFromMarkedItemQ();
        if (object != null) {
            return (Serializable)object;
        }
        try {
            Serializable serializable = (Serializable)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(serializable);
            }
            return serializable;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_value");
        }
    }

    public Serializable read_value(Class clazz) {
        return this.read_value();
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        return this.read_value();
    }

    public Serializable read_value(String string) {
        return this.read_value();
    }

    public Serializable read_value(Serializable serializable) {
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public void consumeEndian() {
        this.read_boolean();
    }

    public int getPosition() {
        return this.bis.position();
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        this.read_any_array(anySeqHolder.value, n, n2);
    }

    private final void read_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            anyArray[i + n] = this.read_any();
        }
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    public String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    public void mark(int n) {
        if (this.markOn) {
            throw this.wrapper.javaSerializationException("mark");
        }
        this.markOn = true;
        if (!this.markedItemQ.isEmpty()) {
            this.peekIndex = 0;
            this.peekCount = this.markedItemQ.size();
        }
    }

    public void reset() {
        this.markOn = false;
        this.peekIndex = 0;
        this.peekCount = 0;
    }

    public boolean markSupported() {
        return true;
    }

    public CDRInputStreamBase dup() {
        if (this.markOn) {
            throw this.wrapper.javaSerializationException("dup() must not called when mark is on");
        }
        IDLJavaSerializationInputStream iDLJavaSerializationInputStream = new IDLJavaSerializationInputStream(this.directRead);
        iDLJavaSerializationInputStream.init((org.omg.CORBA.ORB)((java.lang.Object)this.orb), this.byteBuffer, this.byteBuffer.limit(), false, null);
        iDLJavaSerializationInputStream.setDupData(this.bis.position());
        return iDLJavaSerializationInputStream;
    }

    void setDupData(int n) {
        this.bis.position(n);
    }

    public BigDecimal read_fixed(short s, short s2) {
        StringBuffer stringBuffer = this.read_fixed_buffer();
        if (s != stringBuffer.length()) {
            throw this.wrapper.badFixed(new Integer(s), new Integer(stringBuffer.length()));
        }
        stringBuffer.insert(s - s2, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            byte by = this.read_octet();
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            if (bl || n != 0) {
                stringBuffer.append(Character.forDigit(n, 10));
                bl = true;
            }
            if (n2 == 12) {
                if (!bl) {
                    return new StringBuffer("0.0");
                }
                bl2 = false;
                continue;
            }
            if (n2 == 13) {
                stringBuffer.insert(0, '-');
                bl2 = false;
                continue;
            }
            stringBuffer.append(Character.forDigit(n2, 10));
            bl = true;
        }
        return stringBuffer;
    }

    public boolean isLittleEndian() {
        throw this.wrapper.giopVersionError();
    }

    void setHeaderPadding(boolean bl) {
    }

    public ByteBuffer getByteBuffer() {
        throw this.wrapper.giopVersionError();
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        throw this.wrapper.giopVersionError();
    }

    public int getBufferLength() {
        throw this.wrapper.giopVersionError();
    }

    public void setBufferLength(int n) {
    }

    public int getIndex() {
        return this.bis.position();
    }

    public void setIndex(int n) {
        this.bis.position(n);
    }

    public void orb(org.omg.CORBA.ORB object) {
        object = (ORB)object;
    }

    public BufferManagerRead getBufferManager() {
        return this.bufferManager;
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    void alignOnBoundary(int n) {
        throw this.wrapper.giopVersionError();
    }

    void performORBVersionSpecificInit() {
    }

    public void resetCodeSetConverters() {
    }

    public void start_value() {
        throw this.wrapper.giopVersionError();
    }

    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.bis == null) {
            return;
        }
        this.orb.getByteBufferPool().releaseByteBuffer(this.byteBuffer);
        this.is.skip(this.is.available());
        this.bis.clear();
        IDLJavaSerializationInputStream.putInputStreamObjectToPool(this.bis);
        this.bis = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInputStreamObjectToPool(IDLByteArrayInputStream iDLByteArrayInputStream) {
        LinkedList linkedList = inputStreamPool;
        synchronized (linkedList) {
            inputStreamPool.addLast(iDLByteArrayInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDLByteArrayInputStream getInputStreamObjectFromPool() {
        LinkedList linkedList = inputStreamPool;
        synchronized (linkedList) {
            if (inputStreamPool.size() != 0) {
                return (IDLByteArrayInputStream)inputStreamPool.removeFirst();
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IDLJavaSerializationInputStream.streamHeader[1] = -19;
        IDLJavaSerializationInputStream.streamHeader[0] = -84;
        IDLJavaSerializationInputStream.streamHeader[3] = 5;
        IDLJavaSerializationInputStream.streamHeader[2] = 0;
    }

    static final class IDLObjectInputStream
    extends ObjectInputStream {
        ORB orb;

        IDLObjectInputStream(InputStream inputStream, ORB oRB) throws IOException {
            super(inputStream);
            this.orb = oRB;
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ IDLObjectInputStream this$0;
                {
                    this.this$0 = iDLObjectInputStream;
                }

                public java.lang.Object run() {
                    IDLObjectInputStream.access$000(this.this$0, true);
                    return null;
                }
            });
        }

        protected final java.lang.Object resolveObject(java.lang.Object object) throws IOException {
            try {
                if (StubAdapter.isStub(object)) {
                    StubAdapter.connect(object, (org.omg.CORBA.ORB)((java.lang.Object)this.orb));
                }
            }
            catch (RemoteException remoteException) {
                IOException iOException = new IOException("resolveObject failed");
                iOException.initCause(remoteException);
                throw iOException;
            }
            return object;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return JDKBridge.loadClass(string, null, classLoader);
        }

        void setOrb(ORB oRB) {
            this.orb = oRB;
        }

        static /* synthetic */ boolean access$000(IDLObjectInputStream iDLObjectInputStream, boolean bl) throws SecurityException {
            return iDLObjectInputStream.enableResolveObject(bl);
        }
    }

    static final class IDLByteArrayInputStream
    extends InputStream {
        private int pos;
        private byte[] buffer;
        private IDLObjectInputStream parent;
        private byte[] savedBuffer;
        private int savedPos;

        public IDLByteArrayInputStream(byte[] byArray) {
            this.buffer = byArray;
            this.pos = 0;
        }

        void init(byte[] byArray) {
            this.buffer = byArray;
            this.pos = 0;
        }

        void save() {
            this.savedBuffer = this.buffer;
            this.savedPos = this.pos;
        }

        void restore() {
            this.buffer = this.savedBuffer;
            this.pos = this.savedPos;
        }

        void clear() {
            this.buffer = null;
            this.pos = 0;
            this.savedBuffer = null;
            this.savedPos = 0;
        }

        int position() {
            return this.pos;
        }

        void position(int n) {
            this.pos = n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            System.arraycopy(this.buffer, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int read() throws IOException {
            return this.buffer[this.pos++] & 0xFF;
        }

        public long skip(long l) throws IOException {
            return 0L;
        }

        void setParent(IDLObjectInputStream iDLObjectInputStream) {
            this.parent = iDLObjectInputStream;
        }

        IDLObjectInputStream getParent() {
            return this.parent;
        }
    }
}

