/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferManagerReadGrow;
import com.sun.corba.ee.impl.encoding.BufferManagerReadStream;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.BufferManagerWriteCollect;
import com.sun.corba.ee.impl.encoding.BufferManagerWriteGrow;
import com.sun.corba.ee.impl.encoding.BufferManagerWriteStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.INTERNAL;

public class BufferManagerFactory {
    public static final int GROW = 0;
    public static final int COLLECT = 1;
    public static final int STREAM = 2;

    public static BufferManagerRead newBufferManagerRead(GIOPVersion gIOPVersion, byte by, ORB oRB) {
        if (by != 0) {
            return new BufferManagerReadGrow(oRB);
        }
        switch (gIOPVersion.intValue()) {
            case 256: {
                return new BufferManagerReadGrow(oRB);
            }
            case 257: 
            case 258: {
                return new BufferManagerReadStream(oRB);
            }
        }
        throw new INTERNAL("Unknown GIOP version: " + gIOPVersion);
    }

    public static BufferManagerRead newBufferManagerRead(int n, byte by, ORB oRB) {
        if (by != 0) {
            if (n != 0) {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get(oRB, "rpc.encoding");
                throw oRBUtilSystemException.invalidBuffMgrStrategy("newBufferManagerRead");
            }
            return new BufferManagerReadGrow(oRB);
        }
        switch (n) {
            case 0: {
                return new BufferManagerReadGrow(oRB);
            }
            case 1: {
                throw new INTERNAL("Collect strategy invalid for reading");
            }
            case 2: {
                return new BufferManagerReadStream(oRB);
            }
        }
        throw new INTERNAL("Unknown buffer manager read strategy: " + n);
    }

    public static BufferManagerWrite newBufferManagerWrite(int n, byte by, ORB oRB) {
        if (by != 0) {
            if (n != 0) {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get(oRB, "rpc.encoding");
                throw oRBUtilSystemException.invalidBuffMgrStrategy("newBufferManagerWrite");
            }
            return new BufferManagerWriteGrow(oRB);
        }
        switch (n) {
            case 0: {
                return new BufferManagerWriteGrow(oRB);
            }
            case 1: {
                return new BufferManagerWriteCollect(oRB);
            }
            case 2: {
                return new BufferManagerWriteStream(oRB);
            }
        }
        throw new INTERNAL("Unknown buffer manager write strategy: " + n);
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion gIOPVersion, byte by, ORB oRB) {
        if (by != 0) {
            return new BufferManagerWriteGrow(oRB);
        }
        return BufferManagerFactory.newBufferManagerWrite(oRB.getORBData().getGIOPBuffMgrStrategy(gIOPVersion), by, oRB);
    }

    public static BufferManagerRead defaultBufferManagerRead(ORB oRB) {
        return new BufferManagerReadGrow(oRB);
    }
}

