/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierBase;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class DefaultClassCopiers {
    private static ClassCopier identityClassCopier = new ClassCopierBase("identity"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            return object;
        }
    };
    private static ClassCopier errorClassCopier = new ClassCopierBase("error"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            throw new ReflectiveCopyException("Cannot copy class " + object.getClass());
        }
    };

    private DefaultClassCopiers() {
    }

    public static ClassCopier getIdentityClassCopier() {
        return identityClassCopier;
    }

    public static ClassCopier getErrorClassCopier() {
        return errorClassCopier;
    }

    public static ClassCopier makeMapClassCopier(final ClassCopierFactory classCopierFactory) {
        return new ClassCopierBase("map"){

            public Object createCopy(Object object) throws ReflectiveCopyException {
                try {
                    return object.getClass().newInstance();
                }
                catch (Exception exception) {
                    throw new ReflectiveCopyException("MapCopier could not copy " + object.getClass(), exception);
                }
            }

            private Object myCopy(IdentityHashMap identityHashMap, Object object) throws ReflectiveCopyException {
                if (object == null) {
                    return null;
                }
                Class<?> clazz = object.getClass();
                ClassCopier classCopier = classCopierFactory.get(clazz);
                return classCopier.copy(identityHashMap, object);
            }

            public Object doCopy(IdentityHashMap identityHashMap, Object object, Object object2) throws ReflectiveCopyException {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    Object object3 = this.myCopy(identityHashMap, k);
                    Object v = entry.getValue();
                    Object object4 = this.myCopy(identityHashMap, v);
                    map2.put(object3, object4);
                }
                return object2;
            }
        };
    }
}

