/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.GetServerID;
import com.sun.corba.ee.impl.activation.Help;
import com.sun.corba.ee.impl.activation.ListActiveServers;
import com.sun.corba.ee.impl.activation.ListAliases;
import com.sun.corba.ee.impl.activation.ListORBs;
import com.sun.corba.ee.impl.activation.ListServers;
import com.sun.corba.ee.impl.activation.LocateServer;
import com.sun.corba.ee.impl.activation.LocateServerForORB;
import com.sun.corba.ee.impl.activation.Quit;
import com.sun.corba.ee.impl.activation.RegisterServer;
import com.sun.corba.ee.impl.activation.ShutdownServer;
import com.sun.corba.ee.impl.activation.StartServer;
import com.sun.corba.ee.impl.activation.UnRegisterServer;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.Repository;
import com.sun.corba.ee.spi.activation.RepositoryHelper;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.ORB;

public class ServerTool {
    static final String helpCommand = "help";
    static final String toolName = "servertool";
    static final String commandArg = "-cmd";
    private static final boolean debug = false;
    ORB orb = null;
    static Vector handlers = new Vector();
    static int maxNameLen;

    static int getServerIdForAlias(ORB oRB, String string) throws ServerNotRegistered {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            int n = repository.getServerID(string);
            return repository.getServerID(string);
        }
        catch (Exception exception) {
            throw new ServerNotRegistered();
        }
    }

    void run(String[] stringArray) {
        block7: {
            String[] stringArray2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(commandArg)) continue;
                int n = stringArray.length - i - 1;
                stringArray2 = new String[n];
                for (int j = 0; j < n; ++j) {
                    stringArray2[j] = stringArray[++i];
                }
                break;
            }
            try {
                Properties properties = System.getProperties();
                properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
                this.orb = ORB.init(stringArray, properties);
                if (stringArray2 != null) {
                    this.executeCommand(stringArray2);
                    break block7;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println(CorbaResourceUtil.getText("servertool.banner"));
                while (true) {
                    if ((stringArray2 = this.readCommand(bufferedReader)) != null) {
                        this.executeCommand(stringArray2);
                        continue;
                    }
                    this.printAvailableCommands();
                }
            }
            catch (Exception exception) {
                System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
                System.out.println();
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        ServerTool serverTool = new ServerTool();
        serverTool.run(stringArray);
    }

    String[] readCommand(BufferedReader bufferedReader) {
        System.out.print("servertool > ");
        try {
            StringTokenizer stringTokenizer;
            int n = 0;
            String[] stringArray = null;
            String string = bufferedReader.readLine();
            if (string != null && (stringTokenizer = new StringTokenizer(string)).countTokens() != 0) {
                stringArray = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
            }
            return stringArray;
        }
        catch (Exception exception) {
            System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
            System.out.println();
            exception.printStackTrace();
            return null;
        }
    }

    void printAvailableCommands() {
        System.out.println(CorbaResourceUtil.getText("servertool.shorthelp"));
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(i);
            System.out.print("\t" + commandHandler.getCommandName());
            for (int j = commandHandler.getCommandName().length(); j < maxNameLen; ++j) {
                System.out.print(" ");
            }
            System.out.print(" - ");
            commandHandler.printCommandHelp(System.out, true);
        }
        System.out.println();
    }

    void executeCommand(String[] stringArray) {
        if (stringArray[0].equals(helpCommand)) {
            if (stringArray.length == 1) {
                this.printAvailableCommands();
            } else {
                for (int i = 0; i < handlers.size(); ++i) {
                    CommandHandler commandHandler = (CommandHandler)handlers.elementAt(i);
                    if (!commandHandler.getCommandName().equals(stringArray[1])) continue;
                    commandHandler.printCommandHelp(System.out, false);
                }
            }
            return;
        }
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(i);
            if (!commandHandler.getCommandName().equals(stringArray[0])) continue;
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray2[j] = stringArray[j + 1];
            }
            try {
                System.out.println();
                boolean bl = commandHandler.processCommand(stringArray2, this.orb, System.out);
                if (bl) {
                    commandHandler.printCommandHelp(System.out, false);
                }
                System.out.println();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.printAvailableCommands();
    }

    static {
        handlers.addElement(new RegisterServer());
        handlers.addElement(new UnRegisterServer());
        handlers.addElement(new GetServerID());
        handlers.addElement(new ListServers());
        handlers.addElement(new ListAliases());
        handlers.addElement(new ListActiveServers());
        handlers.addElement(new LocateServer());
        handlers.addElement(new LocateServerForORB());
        handlers.addElement(new ListORBs());
        handlers.addElement(new ShutdownServer());
        handlers.addElement(new StartServer());
        handlers.addElement(new Help());
        handlers.addElement(new Quit());
        maxNameLen = 0;
        for (int i = 0; i < handlers.size(); ++i) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(i);
            int n = commandHandler.getCommandName().length();
            if (n <= maxNameLen) continue;
            maxNameLen = n;
        }
    }
}

