/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.ServerMain;
import com.sun.corba.ee.impl.logging.ActivationSystemException;
import com.sun.corba.ee.spi.activation.EndPointInfo;
import com.sun.corba.ee.spi.activation.InvalidORBid;
import com.sun.corba.ee.spi.activation.ORBAlreadyRegistered;
import com.sun.corba.ee.spi.activation.ORBPortInfo;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.activation.Server;
import com.sun.corba.ee.spi.activation.ServerHeldDown;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.SystemException;

public class ServerTableEntry {
    private static final int DE_ACTIVATED = 0;
    private static final int ACTIVATING = 1;
    private static final int ACTIVATED = 2;
    private static final int RUNNING = 3;
    private static final int HELD_DOWN = 4;
    private static final long waitTime = 2000L;
    private static final int ActivationRetryMax = 5;
    private int state;
    private int serverId;
    private HashMap orbAndPortInfo;
    private Server serverObj;
    private ServerDef serverDef;
    private Process process;
    private int activateRetryCount = 0;
    private String activationCmd;
    private ActivationSystemException wrapper;
    private static String javaHome = System.getProperty("java.home");
    private static String classPath = System.getProperty("java.class.path");
    private static String fileSep = System.getProperty("file.separator");
    private static String pathSep = System.getProperty("path.separator");
    private boolean debug = false;

    private String printState() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "DE_ACTIVATED";
                break;
            }
            case 1: {
                string = "ACTIVATING  ";
                break;
            }
            case 2: {
                string = "ACTIVATED   ";
                break;
            }
            case 3: {
                string = "RUNNING     ";
                break;
            }
            case 4: {
                string = "HELD_DOWN   ";
                break;
            }
        }
        return string;
    }

    public String toString() {
        return "ServerTableEntry[state=" + this.printState() + " serverId=" + this.serverId + " activateRetryCount=" + this.activateRetryCount + "]";
    }

    ServerTableEntry(ActivationSystemException activationSystemException, int n, ServerDef serverDef, int n2, String string, boolean bl, boolean bl2) {
        this.wrapper = activationSystemException;
        this.serverId = n;
        this.serverDef = serverDef;
        this.debug = bl2;
        this.orbAndPortInfo = new HashMap(255);
        this.activateRetryCount = 0;
        this.state = 1;
        this.activationCmd = javaHome + fileSep + "bin" + fileSep + "java " + serverDef.serverVmArgs + " " + "-Dioser=" + System.getProperty("ioser") + " " + "-D" + "org.omg.CORBA.ORBInitialPort" + "=" + n2 + " " + "-D" + "com.sun.CORBA.activation.DbDir" + "=" + string + " " + "-D" + "com.sun.CORBA.POA.ORBActivated" + "=true " + "-D" + "com.sun.CORBA.POA.ORBServerId" + "=" + n + " " + "-D" + "com.sun.CORBA.POA.ORBServerName" + "=" + serverDef.serverName + " " + (bl ? "-Dcom.sun.CORBA.activation.ORBServerVerify=true " : "") + "-classpath " + classPath + (serverDef.serverClassPath.equals("") ? "" : pathSep) + serverDef.serverClassPath + " com.sun.corba.ee.impl.activation.ServerMain " + serverDef.serverArgs + (bl2 ? " -debug" : "");
        if (bl2) {
            System.out.println("ServerTableEntry constructed with activation command " + this.activationCmd);
        }
    }

    public int verify() {
        try {
            if (this.debug) {
                System.out.println("Server being verified w/" + this.activationCmd);
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
            int n = this.process.waitFor();
            if (this.debug) {
                this.printDebug("verify", "returns " + ServerMain.printResult(n));
            }
            return n;
        }
        catch (Exception exception) {
            if (this.debug) {
                this.printDebug("verify", "returns unknown error because of exception " + exception);
            }
            return 4;
        }
    }

    private void printDebug(String string, String string2) {
        System.out.println("ServerTableEntry: method  =" + string);
        System.out.println("ServerTableEntry: server  =" + this.serverId);
        System.out.println("ServerTableEntry: state   =" + this.printState());
        System.out.println("ServerTableEntry: message =" + string2);
        System.out.println();
    }

    synchronized void activate() throws SystemException {
        this.state = 2;
        try {
            if (this.debug) {
                this.printDebug("activate", "activating server");
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
        }
        catch (Exception exception) {
            this.deActivate();
            if (this.debug) {
                this.printDebug("activate", "throwing premature process exit");
            }
            throw this.wrapper.unableToStartProcess();
        }
    }

    synchronized void register(Server server) {
        if (this.state == 2) {
            this.serverObj = server;
            if (this.debug) {
                this.printDebug("register", "process registered back");
            }
        } else {
            if (this.debug) {
                this.printDebug("register", "throwing premature process exit");
            }
            throw this.wrapper.serverNotExpectedToRegister();
        }
    }

    synchronized void registerPorts(String string, EndPointInfo[] endPointInfoArray) throws ORBAlreadyRegistered {
        if (this.orbAndPortInfo.containsKey(string)) {
            throw new ORBAlreadyRegistered(string);
        }
        int n = endPointInfoArray.length;
        EndPointInfo[] endPointInfoArray2 = new EndPointInfo[n];
        for (int i = 0; i < n; ++i) {
            endPointInfoArray2[i] = new EndPointInfo(endPointInfoArray[i].endpointType, endPointInfoArray[i].port);
            if (!this.debug) continue;
            System.out.println("registering type: " + endPointInfoArray2[i].endpointType + "  port  " + endPointInfoArray2[i].port);
        }
        this.orbAndPortInfo.put(string, endPointInfoArray2);
        if (this.state == 2) {
            this.state = 3;
            this.notifyAll();
        }
        if (this.debug) {
            this.printDebug("registerPorts", "process registered Ports");
        }
    }

    synchronized void install() {
        if (this.state != 3) {
            throw this.wrapper.serverNotRunning();
        }
        this.serverObj.install();
    }

    synchronized void uninstall() {
        if (this.state == 3) {
            this.deActivate();
            try {
                if (this.serverObj != null) {
                    this.serverObj.shutdown();
                    this.serverObj.uninstall();
                }
                if (this.process != null) {
                    this.process.destroy();
                }
            }
            catch (Exception exception) {}
        } else {
            throw this.wrapper.serverNotRunning();
        }
    }

    synchronized void holdDown() {
        this.state = 4;
        if (this.debug) {
            this.printDebug("holdDown", "server held down");
        }
        this.notifyAll();
    }

    synchronized void deActivate() {
        this.state = 0;
        if (this.debug) {
            this.printDebug("deActivate", "server deactivated");
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkProcessHealth() {
        if (this.state == 3) {
            try {
                int n = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            ServerTableEntry serverTableEntry = this;
            synchronized (serverTableEntry) {
                this.orbAndPortInfo.clear();
                this.deActivate();
            }
        }
    }

    synchronized boolean isValid() {
        if (this.state == 1 || this.state == 4) {
            if (this.debug) {
                this.printDebug("isValid", "returns true");
            }
            return true;
        }
        try {
            int n = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        if (this.state == 2) {
            if (this.activateRetryCount < 5) {
                if (this.debug) {
                    this.printDebug("isValid", "reactivating server");
                }
                ++this.activateRetryCount;
                this.activate();
                return true;
            }
            if (this.debug) {
                this.printDebug("isValid", "holding server down");
            }
            this.holdDown();
            return true;
        }
        this.deActivate();
        return false;
    }

    synchronized ORBPortInfo[] lookup(String string) throws ServerHeldDown {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        ORBPortInfo[] oRBPortInfoArray = null;
        if (this.state == 3) {
            oRBPortInfoArray = new ORBPortInfo[this.orbAndPortInfo.size()];
            Iterator iterator = this.orbAndPortInfo.keySet().iterator();
            try {
                int n = 0;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    EndPointInfo[] endPointInfoArray = (EndPointInfo[])this.orbAndPortInfo.get(string2);
                    int n2 = -1;
                    for (int i = 0; i < endPointInfoArray.length; ++i) {
                        if (this.debug) {
                            System.out.println("lookup num-ports " + endPointInfoArray.length + "   " + endPointInfoArray[i].endpointType + "   " + endPointInfoArray[i].port);
                        }
                        if (!endPointInfoArray[i].endpointType.equals(string)) continue;
                        n2 = endPointInfoArray[i].port;
                        break;
                    }
                    oRBPortInfoArray[n] = new ORBPortInfo(string2, n2);
                    ++n;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return oRBPortInfoArray;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized EndPointInfo[] lookupForORB(String string) throws ServerHeldDown, InvalidORBid {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        EndPointInfo[] endPointInfoArray = null;
        if (this.state == 3) {
            try {
                EndPointInfo[] endPointInfoArray2 = (EndPointInfo[])this.orbAndPortInfo.get(string);
                endPointInfoArray = new EndPointInfo[endPointInfoArray2.length];
                for (int i = 0; i < endPointInfoArray2.length; ++i) {
                    if (this.debug) {
                        System.out.println("lookup num-ports " + endPointInfoArray2.length + "   " + endPointInfoArray2[i].endpointType + "   " + endPointInfoArray2[i].port);
                    }
                    endPointInfoArray[i] = new EndPointInfo(endPointInfoArray2[i].endpointType, endPointInfoArray2[i].port);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new InvalidORBid();
            }
            return endPointInfoArray;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized String[] getORBList() {
        String[] stringArray = new String[this.orbAndPortInfo.size()];
        Iterator iterator = this.orbAndPortInfo.keySet().iterator();
        try {
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringArray[n++] = string;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stringArray;
    }

    int getServerId() {
        return this.serverId;
    }

    boolean isActive() {
        return this.state == 3 || this.state == 2;
    }

    synchronized void destroy() {
        block9: {
            block8: {
                this.deActivate();
                try {
                    if (this.serverObj != null) {
                        this.serverObj.shutdown();
                    }
                    if (this.debug) {
                        this.printDebug("destroy", "server shutdown successfully");
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block8;
                    this.printDebug("destroy", "server shutdown threw exception" + exception);
                }
            }
            try {
                if (this.process != null) {
                    this.process.destroy();
                }
                if (this.debug) {
                    this.printDebug("destroy", "process destroyed successfully");
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block9;
                this.printDebug("destroy", "process destroy threw exception" + exception);
            }
        }
    }
}

