/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.naming;

import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RoundRobinPolicy {
    private LinkedList circularList = new LinkedList();
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static Random rand = new Random();

    public RoundRobinPolicy(String[] list) {
        String[] newList = null;
        newList = list != null && list.length > 0 ? this.getAddressPortList(list) : this.getEndpointForProviderURL(System.getProperty("java.naming.provider.url"));
        if (newList != null && newList.length > 0) {
            list = this.randomize(newList);
            for (int i = 0; i < list.length; ++i) {
                this.circularList.add(i, list[i]);
            }
        } else {
            _logger.log(Level.WARNING, "no.endpoints");
        }
    }

    public String[] getEndpointForProviderURL(String providerURLString) {
        String[] newList = null;
        if (providerURLString != null) {
            try {
                IiopUrl providerURL = new IiopUrl(providerURLString);
                newList = this.getAddressPortList(providerURL);
                _logger.log(Level.WARNING, "no.endpoints.selected.provider", new Object[]{providerURLString});
            }
            catch (MalformedURLException me) {
                _logger.log(Level.WARNING, "provider.exception", new Object[]{me.getMessage(), providerURLString});
            }
        }
        return newList;
    }

    public String[] randomize(String[] list) {
        String[] randomizedList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            int random;
            do {
                random = rand.nextInt(list.length);
                _logger.fine("random ==> " + random);
            } while (list[random] == null);
            randomizedList[i] = list[random];
            _logger.fine("randomisedList[" + i + "] ==> " + randomizedList[i]);
            list[random] = null;
        }
        return randomizedList;
    }

    public synchronized boolean isEmpty() {
        return this.circularList.size() == 0;
    }

    public synchronized Object[] getNextRotation() {
        if (this.circularList.size() > 1) {
            this.circularList.addLast(this.circularList.removeFirst());
        }
        return this.circularList.toArray();
    }

    public synchronized void add(String[] list) {
        String[] newList = null;
        if (list != null && list.length > 0) {
            newList = this.getAddressPortList(list);
            list = this.randomize(newList);
            for (int i = 0; i < list.length; ++i) {
                if (this.circularList.contains(list[i])) continue;
                this.circularList.add(list[i]);
            }
        }
    }

    private String[] getAddressPortList(String[] hostPortList) {
        Vector<String> addressPortVector = new Vector<String>();
        for (int i = 0; i < hostPortList.length; ++i) {
            try {
                IiopUrl url = new IiopUrl("iiop://" + hostPortList[i]);
                String[] apList = this.getAddressPortList(url);
                for (int j = 0; j < apList.length; ++j) {
                    addressPortVector.addElement(apList[j]);
                }
                continue;
            }
            catch (MalformedURLException me) {
                _logger.log(Level.WARNING, "bad.host.port", new Object[]{hostPortList[i], me.getMessage()});
            }
        }
        String[] ret = new String[addressPortVector.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)addressPortVector.elementAt(i);
        }
        return ret;
    }

    private String[] getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address iiopUrlAddress = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String host = iiopUrlAddress.host;
        int portNumber = iiopUrlAddress.port;
        String port = Integer.toString(portNumber);
        return this.getAddressPortList(host, port);
    }

    public String[] getAddressPortList(String host, String port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            String[] ret = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                ret[i] = addresses[i].getHostAddress() + ":" + port;
            }
            return ret;
        }
        catch (UnknownHostException ukhe) {
            _logger.log(Level.WARNING, "unknown.host", new Object[]{host, ukhe.getMessage()});
            return null;
        }
    }

    public synchronized void print() {
        _logger.fine("List contents ==> ");
        for (int i = 0; i < this.circularList.size(); ++i) {
            _logger.fine("item " + i + " : " + (String)this.circularList.get(i));
        }
    }
}

