/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends BufferedInputStream
implements SharedInputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    protected RandomAccessFile in;
    protected int bufsize;
    protected long bufpos;
    protected long start = 0L;
    protected long datalen;
    private SharedFile sf;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public SharedFileInputStream(String file) throws IOException {
        this(file, defaultBufferSize);
    }

    public SharedFileInputStream(String file, int size) throws IOException {
        super(null);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.sf = new SharedFile(file);
        this.in = this.sf.open();
        this.start = 0L;
        this.datalen = this.in.length();
        this.bufsize = size;
        this.buf = new byte[size];
    }

    private SharedFileInputStream(SharedFile sf, long start, long len, int bufsize) {
        super(null);
        this.sf = sf;
        this.in = sf.open();
        this.start = start;
        this.bufpos = start;
        this.datalen = len;
        this.bufsize = bufsize;
        this.buf = new byte[bufsize];
    }

    private void fill() throws IOException {
        int n;
        if (this.markpos < 0) {
            this.pos = 0;
            this.bufpos += (long)this.count;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.bufpos += (long)this.markpos;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
                this.bufpos += (long)this.count;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
        this.in.seek(this.bufpos + (long)this.pos);
        int len = this.buf.length - this.pos;
        if (this.bufpos - this.start + (long)this.pos + (long)len > this.datalen) {
            len = (int)(this.datalen - (this.bufpos - this.start + (long)this.pos));
        }
        if ((n = this.in.read(this.buf, this.pos, len)) > 0) {
            this.count = n + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n1;
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && (n1 = this.read1(b, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in_available();
    }

    private int in_available() throws IOException {
        return (int)(this.start + this.datalen - (this.bufpos + (long)this.count));
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.sf.close();
            Object var2_1 = null;
            this.sf = null;
            this.in = null;
            this.buf = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.sf = null;
            this.in = null;
            this.buf = null;
            throw throwable;
        }
    }

    public long getPosition() {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        return this.bufpos + (long)this.pos - this.start;
    }

    public InputStream newStream(long start, long end) {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        if (start < 0L) {
            throw new IllegalArgumentException("start < 0");
        }
        if (end == -1L) {
            end = this.datalen;
        }
        return new SharedFileInputStream(this.sf, this.start + (long)((int)start), (int)(end - start), this.bufsize);
    }

    public static void main(String[] argv) throws Exception {
        int b;
        SharedFileInputStream is = new SharedFileInputStream(argv[0]);
        Random r = new Random();
        while ((b = is.read()) >= 0) {
            int b2;
            System.out.write(b);
            if (!(r.nextDouble() < 0.3)) continue;
            InputStream is2 = is.newStream(is.getPosition(), -1L);
            while ((b2 = is2.read()) >= 0) {
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    class SharedFile {
        private int cnt;
        private RandomAccessFile in;

        SharedFile(String file) throws IOException {
            this.in = new RandomAccessFile(file, "r");
        }

        public RandomAccessFile open() {
            ++this.cnt;
            return this.in;
        }

        public synchronized void close() throws IOException {
            if (--this.cnt <= 0) {
                this.in.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.in.close();
        }
    }
}

