/*
 * Decompiled with CFR 0.152.
 */
package samples.mqfailover.ejb;

import java.rmi.RemoteException;
import java.util.Date;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;

public class MQFailoverTestMDB
implements MessageDrivenBean,
MessageListener {
    private Context context;
    private QueueConnectionFactory factory;
    private Queue replyQueue;

    public void ejbCreate() throws RemoteException {
        try {
            this.context = new InitialContext();
            this.factory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/BeanQCF");
        }
        catch (Throwable throwable) {
            System.out.println("MQFailoverTestMDB :: ejbCreate:  unexpected exception thrown in TopicConnectionFactory lookup:" + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        System.out.println(" MQFailoverTestMDB : setMDC");
    }

    public void ejbRemove() {
        System.out.println(" MQFailoverTestMDB : ejbRemove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Message message) {
        block24: {
            Exception exception3222;
            QueueSession queueSession;
            QueueConnection queueConnection;
            block22: {
                System.out.println("MQFailoverTestMDB: onMessage - Message being delivered to MDB is:  " + message);
                try {
                    System.out.println("**** MQFailoverTestMDB: Message " + ((TextMessage)message).getText() + " msg.redelivered  " + message.getJMSRedelivered());
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                queueConnection = null;
                queueSession = null;
                if (!message.getJMSRedelivered()) {
                    try {
                        System.out.println("MDB Sleeping for 30 seconds");
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.out.println(" Sending back response for message " + message);
                queueConnection = this.factory.createQueueConnection();
                queueSession = queueConnection.createQueueSession(false, 1);
                this.replyQueue = (Queue)message.getJMSReplyTo();
                QueueSender queueSender = queueSession.createSender(this.replyQueue);
                TextMessage textMessage = queueSession.createTextMessage();
                textMessage.setText("Reply from MQFailoverTestMDB: \n for message : >> " + ((TextMessage)message).getText() + "\n Message received at :: " + new Date() + " << ");
                textMessage.setBooleanProperty("wasFailedOver", message.getJMSRedelivered());
                queueSender.send((Message)textMessage);
                System.out.println("MQFailoverTestMDB: Published the message back to replyQueue ");
                queueSender.close();
                Object var7_9 = null;
                if (queueSession == null) break block22;
                try {
                    queueSession.close();
                }
                catch (Exception exception3222) {
                    exception3222.printStackTrace();
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (Exception exception3222) {
                    System.out.println("MQFailoverTestMDB: onMessage:  exception on close " + exception3222.getMessage());
                }
            }
            break block24;
            {
                catch (Exception exception4) {
                    Exception exception52222;
                    System.out.println("MQFailoverTestMDB: onMessage: exception " + exception4.getMessage());
                    exception4.printStackTrace();
                    Object var7_10 = null;
                    if (queueSession != null) {
                        try {
                            queueSession.close();
                        }
                        catch (Exception exception52222) {
                            exception52222.printStackTrace();
                        }
                    }
                    if (queueConnection != null) {
                        try {
                            queueConnection.close();
                        }
                        catch (Exception exception52222) {
                            System.out.println("MQFailoverTestMDB: onMessage:  exception on close " + exception52222.getMessage());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception62222;
                Object var7_11 = null;
                if (queueSession != null) {
                    try {
                        queueSession.close();
                    }
                    catch (Exception exception62222) {
                        exception62222.printStackTrace();
                    }
                }
                if (queueConnection != null) {
                    try {
                        queueConnection.close();
                    }
                    catch (Exception exception62222) {
                        System.out.println("MQFailoverTestMDB: onMessage:  exception on close " + exception62222.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }
}

