/*
 * Decompiled with CFR 0.152.
 */
package samples.mqfailover.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.swing.JOptionPane;

public class MQFailoverTestClient {
    private static Context ic = null;
    private static int NUMBER_OF_MESSAGES = 2;
    private static String messageText = " MQ Failover Test Message ";

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            boolean bl = false;
            Object var3_4 = null;
            Object var4_5 = null;
            if (stringArray.length == 0) {
                bl = true;
            }
            if (!bl) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = null;
                    String string2 = null;
                    int n = stringArray[i].indexOf("=");
                    if (n <= -1) continue;
                    string = stringArray[i].substring(0, n);
                    string2 = stringArray[i].substring(n + 1);
                    if (string == null || string2 == null) continue;
                    properties.put(string, string2);
                }
                ic = new InitialContext(properties);
            } else {
                System.out.println("No properties. Not Initialized to comp/env");
                ic = new InitialContext();
            }
            System.out.println("\nCreated Initial Context");
            MQFailoverTestClient.waitForUserInput("Press <Enter> to continue....");
            MQFailoverTestClient.sendTestMessages();
        }
        catch (Exception exception) {
            System.err.println("Caught an unexpected exception!");
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void sendTestMessages() {
        Topic topic = null;
        Queue queue = null;
        TopicConnectionFactory topicConnectionFactory = null;
        TopicSession topicSession = null;
        TopicConnection topicConnection = null;
        TopicPublisher topicPublisher = null;
        System.out.println("\n Publishing messages");
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            topicConnectionFactory = (TopicConnectionFactory)ic.lookup("java:comp/env/jms/PublishClientTCF");
            System.out.println("*** After getting factory");
            topicConnection = topicConnectionFactory.createTopicConnection();
            System.out.println("*** After getting connection");
            topic = (Topic)ic.lookup("java:comp/env/jms/publishTopic");
            queue = (Queue)ic.lookup("java:comp/env/jms/receiveQueue");
            topicSession = topicConnection.createTopicSession(false, 1);
            topicPublisher = topicSession.createPublisher(topic);
            topicConnection.start();
            System.out.println("Sending message #: " + i);
            TextMessage textMessage = topicSession.createTextMessage(messageText + i);
            textMessage.setText("MQ Failover Demo Test Message # " + i);
            textMessage.setJMSReplyTo((Destination)queue);
            topicPublisher.publish((Message)textMessage);
            if (i % 2 != 0) {
                JOptionPane.showConfirmDialog(null, "Perform one of the following to demonstrate JMS Failover.\n Kill a JMS broker and restart the broker instance. \n OR \n Stop an application server instance and restart it", "JMS Failover sample", -1, 1);
                try {
                    System.out.println("Sleeping for 30 seconds");
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            Object var10_10 = null;
            try {
                if (topicSession != null) {
                    topicSession.close();
                }
                if (topicConnection == null) continue;
                topicConnection.close();
            }
            catch (JMSException jMSException) {
                System.err.println("Error while closing connection/session :: " + jMSException.getMessage());
                jMSException.printStackTrace();
            }
            continue;
            {
                catch (Exception exception) {
                    System.err.println("Error while publishing messages :: " + exception.getMessage());
                    exception.printStackTrace();
                    var10_10 = null;
                    try {
                        if (topicSession != null) {
                            topicSession.close();
                        }
                        if (topicConnection == null) continue;
                        topicConnection.close();
                    }
                    catch (JMSException jMSException) {
                        System.err.println("Error while closing connection/session :: " + jMSException.getMessage());
                        jMSException.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_10 = null;
                try {
                    if (topicSession != null) {
                        topicSession.close();
                    }
                    if (topicConnection != null) {
                        topicConnection.close();
                    }
                }
                catch (JMSException jMSException) {
                    System.err.println("Error while closing connection/session :: " + jMSException.getMessage());
                    jMSException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private static String waitForUserInput(String string) {
        String string2 = "";
        System.out.println(string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.println("Exception occured while waiting for <Enter>: " + exception.toString());
        }
        return string2;
    }
}

