/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(class$org$apache$jasper$servlet$JspServlet == null ? (class$org$apache$jasper$servlet$JspServlet = JspServlet.class$("org.apache.jasper.servlet.JspServlet")) : class$org$apache$jasper$servlet$JspServlet);
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;
    static /* synthetic */ Class class$org$apache$jasper$servlet$JspServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.options = new EmbeddedServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        if (log.isDebugEnabled()) {
            log.debug(Localizer.getMessage("jsp.message.scratch.dir.is", this.options.getScratchDir().toString()));
            log.debug(Localizer.getMessage("jsp.message.dont.modify.servlets"));
        }
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String jspFile;
            String jspUri;
            String currentIncludedUri;
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri != null && !includeUri.equals(currentIncludedUri = requestUri.substring(requestUri.indexOf(includeUri)))) {
                includeUri = currentIncludedUri;
            }
            if (includeUri == null) {
                jspUri = request.getServletPath();
                if (request.getPathInfo() != null) {
                    jspUri = request.getServletPath() + request.getPathInfo();
                }
            } else {
                jspUri = includeUri;
            }
            if ((jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file")) != null) {
                jspUri = jspFile;
            }
            boolean precompile = this.preCompile(request);
            if (log.isDebugEnabled()) {
                log.debug("JspEngine --> " + jspUri);
                log.debug("\t     ServletPath: " + request.getServletPath());
                log.debug("\t        PathInfo: " + request.getPathInfo());
                log.debug("\t        RealPath: " + this.context.getRealPath(jspUri));
                log.debug("\t      RequestURI: " + request.getRequestURI());
                log.debug("\t     QueryString: " + request.getQueryString());
                log.debug("\t  Request Params: ");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    log.info("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("JspServlet.destroy()");
        }
        this.rctxt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (null == this.context.getResource(jspUri)) {
                        response.sendError(404, jspUri);
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

