/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    private static Log log = LogFactory.getLog(class$org$apache$catalina$core$StandardHost == null ? (class$org$apache$catalina$core$StandardHost = StandardHost.class$("org.apache.catalina.core.StandardHost")) : class$org$apache$catalina$core$StandardHost);
    private String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private Deployer deployer = null;
    private boolean deployOnStartup = true;
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean liveDeploy = true;
    private boolean unpackWARs = true;
    private String workDir = null;
    private DefaultContext defaultContext;
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    private int[] ports = new int[0];
    static String STANDARD_HOST_DEPLOYER = "org.apache.catalina.core.StandardHostDeployer";
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$catalina$core$StandardHost;
    static /* synthetic */ Class class$org$apache$catalina$Host;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.autoDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.setAutoDeploy(liveDeploy);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setPorts(int[] ports) {
        int[] oldPorts = this.ports;
        this.ports = (int[])ports.clone();
        this.support.firePropertyChange("ports", oldPorts, this.ports);
    }

    public int[] getPorts() {
        return (int[])this.ports.clone();
    }

    public void installDefaultContext(Context context) {
        if (this.defaultContext != null && this.defaultContext instanceof StandardDefaultContext) {
            ((StandardDefaultContext)this.defaultContext).installDefaultContext(context);
        }
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addAlias(String alias) {
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public int[] findPorts() {
        return this.getPorts();
    }

    public String getInfo() {
        return info;
    }

    public Context map(String uri) {
        int slash;
        if (log.isDebugEnabled()) {
            log.debug("Mapping request URI '" + uri + "'");
        }
        if (uri == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("  Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace("  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.error(sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        String[] stringArray = this.aliases;
        synchronized (this.aliases) {
            int n = -1;
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n) continue;
                results[j++] = this.aliases[i];
            }
            this.aliases = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeAlias", alias);
            return;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "setContext", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Throwable t) {
                log.debug("No realm for this host " + realmName);
            }
        }
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                this.addValve(valve);
            }
            catch (Throwable t) {
                log.error(sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        if (this.xmlValidation) {
            log.debug(sm.getString("standardHost.validationEnabled"));
        } else {
            log.debug(sm.getString("standardHost.validationDisabled"));
        }
        super.start();
    }

    public void backgroundProcess() {
        this.lifecycle.fireLifecycleEvent("check", null);
    }

    public void install(String contextPath, URL war) throws IOException {
        this.getDeployer().install(contextPath, war);
    }

    public synchronized void install(URL config, URL war) throws IOException {
        this.getDeployer().install(config, war);
    }

    public Context findDeployedApp(String contextPath) {
        return this.getDeployer().findDeployedApp(contextPath);
    }

    public String[] findDeployedApps() {
        return this.getDeployer().findDeployedApps();
    }

    public void remove(String contextPath) throws IOException {
        this.getDeployer().remove(contextPath);
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        this.getDeployer().remove(contextPath, undeploy);
    }

    public void start(String contextPath) throws IOException {
        this.getDeployer().start(contextPath);
    }

    public void stop(String contextPath) throws IOException {
        this.getDeployer().stop(contextPath);
    }

    public Deployer getDeployer() {
        if (this.deployer != null) {
            return this.deployer;
        }
        log.info("Create Host deployer for direct deployment ( non-jmx ) ");
        try {
            Class<?> c = Class.forName(STANDARD_HOST_DEPLOYER);
            this.deployer = (Deployer)c.newInstance();
            Method m = c.getMethod("setHost", class$org$apache$catalina$Host == null ? (class$org$apache$catalina$Host = StandardHost.class$("org.apache.catalina.Host")) : class$org$apache$catalina$Host);
            m.invoke((Object)this.deployer, this);
        }
        catch (Throwable t) {
            log.error("Error creating deployer ", t);
        }
        return this.deployer;
    }

    public void setDeployer(Deployer d) {
        this.deployer = d;
    }

    public String[] getValveNames() throws Exception {
        Valve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.getParent() == null) {
            try {
                ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
                if (this.mserver.isRegistered(serviceName)) {
                    log.debug("Registering with the Engine");
                    this.mserver.invoke(serviceName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                log.debug("Register " + this.domain);
                this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.info("Error registering ", t);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        ObjectName res = super.preRegister(server, oname);
        String name = oname.getKeyProperty("host");
        if (name != null) {
            this.setName(name);
        }
        return res;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Create ObjectName " + domain + " " + parent);
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

