/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.StringManager;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.naming.ContextAccessController;

public class StandardDefaultContext
implements DefaultContext,
LifecycleListener,
MBeanRegistration {
    private Hashtable contexts = new Hashtable();
    private String[] applicationListeners = new String[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean cookies = true;
    private boolean crossContext = true;
    private static final String info = "org.apache.catalina.core.DefaultContext/1.0";
    private String[] instanceListeners = new String[0];
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private NamingResources namingResources = new NamingResources();
    private HashMap parameters = new HashMap();
    private boolean reloadable = false;
    private boolean swallowOutput = false;
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    DirContext dirContext = null;
    protected String name = "defaultContext";
    protected Container parent = null;
    protected Vector lifecycle = new Vector();
    protected Loader loader = null;
    protected Manager manager = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheTTL = 5000;
    protected boolean cachingAllowed = true;
    protected int managerChecksFrequency = 6;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public StandardDefaultContext() {
        this.namingResources.setContainer(this);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setManagerChecksFrequency(int managerChecksFrequency) {
        this.managerChecksFrequency = managerChecksFrequency;
    }

    public int getManagerChecksFrequency() {
        return this.managerChecksFrequency;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
    }

    public String getInfo() {
        return info;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
    }

    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    public void setSwallowOutput(boolean swallowOutput) {
        boolean oldSwallowOutput = this.swallowOutput;
        this.swallowOutput = swallowOutput;
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public void setResources(DirContext resources) {
        this.dirContext = resources;
    }

    public DirContext getResources() {
        return this.dirContext;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        this.loader = loader;
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.add(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            String[] results = new String[this.applicationListeners.length + 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                results[i] = this.applicationListeners[i];
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter parameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
    }

    public void addEnvironment(ContextEnvironment environment) {
        this.namingResources.addEnvironment(environment);
    }

    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            String[] results = new String[this.instanceListeners.length + 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                results[i] = this.instanceListeners[i];
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
    }

    public void addResourceEnvRef(String name, String type) {
        this.namingResources.addResourceEnvRef(name, type);
    }

    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                results[i] = this.wrapperLifecycles[i];
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            String[] results = new String[this.wrapperListeners.length + 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                results[i] = this.wrapperListeners[i];
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    public ResourceParams[] findResourceParams() {
        return this.namingResources.findResourceParams();
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            int n = -1;
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (!this.applicationListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationListeners[i];
            }
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String name) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            int n = -1;
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!name.equals(this.applicationParameters[i].getName())) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationParameters[i];
            }
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int n = -1;
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (!this.instanceListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.instanceListeners[i];
            }
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removeEnvironment(String envName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + envName + "'");
        }
        nresources.removeEnvironment(envName);
    }

    public void removeResource(String resourceName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceName + "'");
        }
        nresources.removeResource(resourceName);
    }

    public void removeResourceLink(String resourceLinkName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextResourceLink resource = nresources.findResourceLink(resourceLinkName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceLinkName + "'");
        }
        nresources.removeResourceLink(resourceLinkName);
    }

    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            int n = -1;
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (!this.wrapperLifecycles[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            int n = -1;
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (!this.wrapperListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context = null;
        NamingContextListener listener = null;
        if (event.getLifecycle() instanceof StandardContext) {
            context = (StandardContext)event.getLifecycle();
            LifecycleListener[] listeners = context.findLifecycleListeners();
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof NamingContextListener)) continue;
                listener = (NamingContextListener)listeners[i];
                break;
            }
        }
        if (listener == null) {
            return;
        }
        if (event.getType().equals("before_stop") || event.getType().equals("reload")) {
            this.contexts.remove(context);
            this.namingResources.removePropertyChangeListener(listener);
            if (!event.getType().equals("reload")) {
                context.removeLifecycleListener(this);
            }
        }
        if (event.getType().equals("after_start") || event.getType().equals("reload")) {
            this.contexts.put(context, context);
            NamingResources contextResources = context.getNamingResources();
            ContextAccessController.setWritable(listener.getName(), context);
            ContextEjb[] contextEjb = this.findEjbs();
            for (int i = 0; i < contextEjb.length; ++i) {
                ContextEjb contextEntry = contextEjb[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEjb(contextEntry.getName());
                }
                listener.addEjb(contextEntry);
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            for (int i = 0; i < contextEnv.length; ++i) {
                ContextEnvironment contextEntry = contextEnv[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEnvironment(contextEntry.getName());
                }
                listener.addEnvironment(contextEntry);
            }
            ContextResource[] resources = this.findResources();
            for (int i = 0; i < resources.length; ++i) {
                ContextResource contextEntry = resources[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeResource(contextEntry.getName());
                }
                listener.addResource(contextEntry);
            }
            ContextResourceLink[] resourceLinks = this.findResourceLinks();
            for (int i = 0; i < resourceLinks.length; ++i) {
                ContextResourceLink contextEntry = resourceLinks[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeResourceLink(contextEntry.getName());
                }
                listener.addResourceLink(contextEntry);
            }
            String[] envRefs = this.findResourceEnvRefs();
            for (int i = 0; i < envRefs.length; ++i) {
                if (contextResources.exists(envRefs[i])) {
                    listener.removeResourceEnvRef(envRefs[i]);
                }
                listener.addResourceEnvRef(envRefs[i], this.findResourceEnvRef(envRefs[i]));
            }
            ContextAccessController.setReadOnly(listener.getName());
            this.namingResources.addPropertyChangeListener(listener);
        }
    }

    public void installDefaultContext(Context context) {
        if (context instanceof StandardContext) {
            ((StandardContext)context).setUseNaming(this.isUseNaming());
            ((StandardContext)context).setSwallowOutput(this.getSwallowOutput());
            ((StandardContext)context).setCachingAllowed(this.isCachingAllowed());
            ((StandardContext)context).setCacheTTL(this.getCacheTTL());
            ((StandardContext)context).setCacheMaxSize(this.getCacheMaxSize());
            ((StandardContext)context).setAllowLinking(this.isAllowLinking());
            ((StandardContext)context).setCaseSensitive(this.isCaseSensitive());
            ((StandardContext)context).setManagerChecksFrequency(this.getManagerChecksFrequency());
            if (!this.contexts.containsKey(context)) {
                ((StandardContext)context).addLifecycleListener(this);
            }
            Enumeration lifecycleListeners = this.lifecycle.elements();
            while (lifecycleListeners.hasMoreElements()) {
                ((StandardContext)context).addLifecycleListener((LifecycleListener)lifecycleListeners.nextElement());
            }
        }
        if (!context.getPrivileged() && this.loader != null) {
            ClassLoader parentClassLoader = context.getParent().getParentClassLoader();
            Class<?> clazz = this.loader.getClass();
            Class[] types = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = StandardDefaultContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            Object[] args = new Object[]{parentClassLoader};
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(types);
                Loader context_loader = (Loader)constructor.newInstance(args);
                context_loader.setDelegate(this.loader.getDelegate());
                context_loader.setReloadable(this.loader.getReloadable());
                if (this.loader instanceof WebappLoader) {
                    ((WebappLoader)context_loader).setDebug(((WebappLoader)this.loader).getDebug());
                    ((WebappLoader)context_loader).setLoaderClass(((WebappLoader)this.loader).getLoaderClass());
                }
                context.setLoader(context_loader);
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("DefaultContext custom Loader install failed");
                iae.initCause(e);
                throw iae;
            }
        }
    }

    public void importDefaultContext(Context context) {
        int i;
        int i2;
        context.setCookies(this.getCookies());
        context.setCrossContext(this.getCrossContext());
        context.setReloadable(this.getReloadable());
        String[] listeners = this.findApplicationListeners();
        for (i2 = 0; i2 < listeners.length; ++i2) {
            context.addApplicationListener(listeners[i2]);
        }
        listeners = this.findInstanceListeners();
        for (i2 = 0; i2 < listeners.length; ++i2) {
            context.addInstanceListener(listeners[i2]);
        }
        String[] wrapper = this.findWrapperListeners();
        for (i = 0; i < wrapper.length; ++i) {
            context.addWrapperListener(wrapper[i]);
        }
        wrapper = this.findWrapperLifecycles();
        for (i = 0; i < wrapper.length; ++i) {
            context.addWrapperLifecycle(wrapper[i]);
        }
        String[] parameters = this.findParameters();
        for (int i3 = 0; i3 < parameters.length; ++i3) {
            context.addParameter(parameters[i3], this.findParameter(parameters[i3]));
        }
        ApplicationParameter[] appParam = this.findApplicationParameters();
        for (int i4 = 0; i4 < appParam.length; ++i4) {
            context.addApplicationParameter(appParam[i4]);
        }
        if (!(context instanceof StandardContext)) {
            ContextEjb[] contextEjb = this.findEjbs();
            for (int i5 = 0; i5 < contextEjb.length; ++i5) {
                context.addEjb(contextEjb[i5]);
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            for (int i6 = 0; i6 < contextEnv.length; ++i6) {
                context.addEnvironment(contextEnv[i6]);
            }
            ContextResource[] resources = this.findResources();
            for (int i7 = 0; i7 < resources.length; ++i7) {
                context.addResource(resources[i7]);
            }
            ContextResourceLink[] resourceLinks = this.findResourceLinks();
            for (int i8 = 0; i8 < resourceLinks.length; ++i8) {
                context.addResourceLink(resourceLinks[i8]);
            }
            String[] envRefs = this.findResourceEnvRefs();
            for (int i9 = 0; i9 < envRefs.length; ++i9) {
                context.addResourceEnvRef(envRefs[i9], this.findResourceEnvRef(envRefs[i9]));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("DefaultContext[");
        sb.append("]");
        return sb.toString();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    protected String getJSR77Suffix() {
        return this.suffix;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        if (this.type == null) {
            this.type = name.getKeyProperty("j2eeType");
        }
        String j2eeApp = name.getKeyProperty("J2EEApplication");
        String j2eeServer = name.getKeyProperty("J2EEServer");
        if (j2eeApp == null) {
            j2eeApp = "none";
        }
        if (j2eeServer == null) {
            j2eeServer = "none";
        }
        this.suffix = ",J2EEApplication=" + j2eeApp + ",J2EEServer=" + j2eeServer;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public String[] getEnvironments() {
        ContextEnvironment[] envs = this.getNamingResources().findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < envs.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), envs[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for environment " + envs[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceNames() {
        ContextResource[] resources = this.getNamingResources().findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < resources.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), resources[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resources[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] links = this.getNamingResources().findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < links.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), links[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + links[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        nresources.addEnvironment(env);
        ManagedBean managed = Registry.getRegistry().findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        ManagedBean managed = Registry.getRegistry().findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String resourceLinkName, String global, String name, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setGlobal(global);
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = Registry.getRegistry().findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

