/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.security.jauth.callback.TrustStoreCallback;
import com.sun.org.apache.xml.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.org.apache.xml.security.utils.RFC2253Parser;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeaderException;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.reference.X509SubjectKeyIdentifier;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;

public class WssProviderSecurityEnvironment
implements SecurityEnvironment {
    private Map _securityOptions;
    private CallbackHandler _handler;
    private SecretKeyCallback skCallback = null;
    private PrivateKeyCallback pkCallback = null;
    private CertStoreCallback csCallback = null;
    private TrustStoreCallback tsCallback = null;
    private PasswordValidationCallback pvCallback = null;
    private Subject subject;
    Map aliases_keypwds = null;
    protected long MAX_CLOCK_SKEW = 0x6DDD00L;
    protected long TIMESTAMP_FRESHNESS_LIMIT = 18000000L;
    private static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'");

    public WssProviderSecurityEnvironment(CallbackHandler handler, Map options) throws XWSSecurityException {
        this._handler = handler;
        this._securityOptions = options;
        if (this._securityOptions != null) {
            String mo_aliases = (String)this._securityOptions.get("ALIASES");
            String mo_keypwds = (String)this._securityOptions.get("PASSWORDS");
            if (mo_aliases != null && mo_keypwds != null) {
                StringTokenizer aliases = new StringTokenizer(mo_aliases, " ");
                StringTokenizer keypwds = new StringTokenizer(mo_keypwds, " ");
                if (aliases.countTokens() != keypwds.countTokens()) {
                    // empty if block
                }
                while (aliases.hasMoreElements()) {
                    this.aliases_keypwds.put(aliases.nextToken(), keypwds.nextToken());
                }
            }
        }
    }

    public PrivateKey getPrivateKey() throws XWSSecurityException {
        try {
            Set set;
            if (this.subject != null && (set = this.subject.getPrivateCredentials(PrivateKey.class)) != null && set.size() == 1) {
                return (PrivateKey)set.toArray()[0];
            }
            this.pkCallback = new PrivateKeyCallback(null);
            Callback[] _callbacks = new Callback[]{this.pkCallback};
            this._handler.handle(_callbacks);
            return this.pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(String alias) throws XWSSecurityException {
        PrivateKey privateKey = null;
        try {
            PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(alias);
            this.pkCallback = new PrivateKeyCallback(request);
            Callback[] callbacks = new Callback[]{this.pkCallback};
            this._handler.handle(callbacks);
            privateKey = this.pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        if (privateKey == null) {
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(byte[] keyIdentifier) throws XWSSecurityException {
        try {
            Set set;
            if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    X500PrivateCredential cred = (X500PrivateCredential)it.next();
                    if (!this.matchesKeyIdentifier(Base64.decode(keyIdentifier), cred.getCertificate())) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdentifier);
            this.pkCallback = new PrivateKeyCallback(request);
            Callback[] callbacks = new Callback[]{this.pkCallback};
            this._handler.handle(callbacks);
            return this.pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(X509Certificate cert) throws XWSSecurityException {
        try {
            Set set;
            if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                String issuerName = RFC2253Parser.normalize(cert.getIssuerDN().getName());
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    X500PrivateCredential cred = (X500PrivateCredential)it.next();
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    if (!serialNo.equals(cert.getSerialNumber()) || !currentIssuerName.equals(issuerName)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(cert.getIssuerX500Principal(), cert.getSerialNumber());
            this.pkCallback = new PrivateKeyCallback(request);
            Callback[] callbacks = new Callback[]{this.pkCallback};
            this._handler.handle(callbacks);
            return this.pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        try {
            Set set;
            if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    X500PrivateCredential cred = (X500PrivateCredential)it.next();
                    X509Certificate x509Cert = cred.getCertificate();
                    BigInteger serialNo = x509Cert.getSerialNumber();
                    String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                    if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                    return cred.getPrivateKey();
                }
            }
            PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
            this.pkCallback = new PrivateKeyCallback(request);
            Callback[] callbacks = new Callback[]{this.pkCallback};
            this._handler.handle(callbacks);
            return this.pkCallback.getKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public X509Certificate getDefaultCertificate() throws XWSSecurityException {
        Set set;
        if (this.subject != null && (set = this.subject.getPublicCredentials(X509Certificate.class)) != null && set.size() == 1) {
            return (X509Certificate)set.toArray()[0];
        }
        this.pkCallback = new PrivateKeyCallback(null);
        Callback[] _callbacks = new Callback[]{this.pkCallback};
        try {
            this._handler.handle(_callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = this.pkCallback.getChain();
        if (chain == null) {
            throw new XWSSecurityException("Empty certificate chain returned by PrivateKeyCallback");
        }
        return (X509Certificate)chain[0];
    }

    public boolean authenticateUser(String username, String password) throws XWSSecurityException {
        char[] pwd = password == null ? null : password.toCharArray();
        this.pvCallback = new PasswordValidationCallback(username, pwd);
        Callback[] callbacks = new Callback[]{this.pvCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        if (pwd != null) {
            this.pvCallback.clearPassword();
        }
        return this.pvCallback.getResult();
    }

    public boolean authenticateUser(String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        return false;
    }

    public boolean validateCertificate(X509Certificate cert) throws XWSSecurityException {
        CertPathBuilder builder;
        PKIXBuilderParameters parameters;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new XWSSecurityException("X509Certificate Expired", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new XWSSecurityException("X509Certificate not yet valid", e);
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(cert);
        try {
            Callback[] callbacks = null;
            if (this.tsCallback == null && this.csCallback == null) {
                this.csCallback = new CertStoreCallback();
                this.tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{this.csCallback, this.tsCallback};
            } else if (this.csCallback == null) {
                this.csCallback = new CertStoreCallback();
                callbacks = new Callback[]{this.csCallback};
            } else if (this.tsCallback == null) {
                this.tsCallback = new TrustStoreCallback();
                callbacks = new Callback[]{this.tsCallback};
            }
            if (callbacks != null) {
                try {
                    this._handler.handle(callbacks);
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
            }
            parameters = new PKIXBuilderParameters(this.tsCallback.getTrustStore(), (CertSelector)certSelector);
            parameters.setRevocationEnabled(false);
            parameters.addCertStore(this.csCallback.getCertStore());
            builder = CertPathBuilder.getInstance("PKIX");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        try {
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(parameters);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public X509Certificate getMatchingCertificate(byte[] keyIdMatch) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        Set set;
        if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                X500PrivateCredential cred = (X500PrivateCredential)it.next();
                X509Certificate cert = cred.getCertificate();
                if (!this.matchesKeyIdentifier(keyIdMatch, cert)) continue;
                return cert;
            }
        }
        PrivateKeyCallback.SubjectKeyIDRequest request = new PrivateKeyCallback.SubjectKeyIDRequest(keyIdMatch);
        this.pkCallback = new PrivateKeyCallback(request);
        if (this.tsCallback == null) {
            this.tsCallback = new TrustStoreCallback();
        }
        Callback[] callbacks = new Callback[]{this.pkCallback, this.tsCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = this.pkCallback.getChain();
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesKeyIdentifier(keyIdMatch, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((trustStore = this.tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(keyIdMatch, trustStore)) != null) {
            return otherPartyCert;
        }
        throw new XWSSecurityException("No Matching Certificate for :" + keyIdMatch + " found in KeyStore or TrustStore");
    }

    public X509Certificate getMatchingCertificate(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate otherPartyCert;
        KeyStore trustStore;
        Set set;
        if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                X500PrivateCredential cred = (X500PrivateCredential)it.next();
                X509Certificate x509Cert = cred.getCertificate();
                BigInteger serialNo = x509Cert.getSerialNumber();
                String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                return x509Cert;
            }
        }
        PrivateKeyCallback.IssuerSerialNumRequest request = new PrivateKeyCallback.IssuerSerialNumRequest(new X500Principal(issuerName), serialNumber);
        this.pkCallback = new PrivateKeyCallback(request);
        if (this.tsCallback == null) {
            this.tsCallback = new TrustStoreCallback();
        }
        Callback[] callbacks = new Callback[]{this.pkCallback, this.tsCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        Certificate[] chain = this.pkCallback.getChain();
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Cert = (X509Certificate)chain[i];
                if (!this.matchesIssuerSerialAndName(serialNumber, issuerName, x509Cert)) continue;
                return x509Cert;
            }
        }
        if ((trustStore = this.tsCallback.getTrustStore()) != null && (otherPartyCert = this.getMatchingCertificate(serialNumber, issuerName, trustStore)) != null) {
            return otherPartyCert;
        }
        throw new XWSSecurityException("No Matching Certificate for : found in KeyStore or TrustStore");
    }

    public SecretKey getSecretKey(String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKeyCallback.AliasRequest request = new SecretKeyCallback.AliasRequest(alias);
        this.skCallback = new SecretKeyCallback(request);
        Callback[] callbacks = new Callback[]{this.skCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return this.skCallback.getKey();
    }

    public X509Certificate getCertificate(String alias, boolean forSigning) throws XWSSecurityException {
        X509Certificate cert;
        block11: {
            cert = null;
            try {
                if (forSigning) {
                    try {
                        Set set;
                        if (this.subject != null && (set = this.subject.getPrivateCredentials(X500PrivateCredential.class)) != null) {
                            Iterator it = set.iterator();
                            while (it.hasNext()) {
                                X500PrivateCredential cred = (X500PrivateCredential)it.next();
                                if (!cred.getAlias().equals(alias)) continue;
                                return cred.getCertificate();
                            }
                        }
                        PrivateKeyCallback.AliasRequest request = new PrivateKeyCallback.AliasRequest(alias);
                        this.pkCallback = new PrivateKeyCallback(request);
                        Callback[] callbacks = new Callback[]{this.pkCallback};
                        this._handler.handle(callbacks);
                    }
                    catch (Exception e) {
                        throw new XWSSecurityException(e);
                    }
                    Certificate[] chain = this.pkCallback.getChain();
                    if (chain != null) {
                        cert = (X509Certificate)chain[0];
                    }
                    break block11;
                }
                if (this.tsCallback == null) {
                    this.tsCallback = new TrustStoreCallback();
                    Callback[] _callbacks = new Callback[]{this.tsCallback};
                    this._handler.handle(_callbacks);
                }
                if (this.tsCallback.getTrustStore() != null) {
                    cert = (X509Certificate)this.tsCallback.getTrustStore().getCertificate(alias);
                }
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
        }
        if (cert == null) {
            throw new XWSSecurityException("Unable to locate certificate for the alias " + alias);
        }
        return cert;
    }

    private boolean matchesKeyIdentifier(byte[] keyIdMatch, X509Certificate x509Cert) {
        byte[] keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private X509Certificate getMatchingCertificate(byte[] keyIdMatch, KeyStore kStore) throws XWSSecurityException {
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(keyIdMatch, keyId)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            throw new XWSSecurityException(kEx);
        }
        return null;
    }

    private boolean matchesIssuerSerialAndName(BigInteger serialNumberMatch, String issuerNameMatch, X509Certificate x509Cert) {
        BigInteger serialNumber = x509Cert.getSerialNumber();
        String issuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
        return serialNumber.equals(serialNumberMatch) && issuerName.equals(issuerNameMatch);
    }

    private X509Certificate getMatchingCertificate(BigInteger serialNumber, String issuerName, KeyStore kStore) throws XWSSecurityException {
        try {
            Enumeration<String> enum1 = kStore.aliases();
            while (enum1.hasMoreElements()) {
                String alias = enum1.nextElement();
                Certificate cert = kStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                BigInteger serialNo = x509Cert.getSerialNumber();
                String currentIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                if (!serialNo.equals(serialNumber) || !currentIssuerName.equals(issuerName)) continue;
                return x509Cert;
            }
        }
        catch (KeyStoreException kEx) {
            throw new XWSSecurityException(kEx);
        }
        return null;
    }

    public void updateOtherPartySubject(Subject subject, String username, String password) {
        String x500Name = "CN=" + username;
        X500Principal principal = new X500Principal(x500Name);
        subject.getPrincipals().add(principal);
        subject.getPrivateCredentials().add(password);
    }

    public void updateOtherPartySubject(Subject subject, X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        subject.getPrincipals().add(principal);
        subject.getPublicCredentials().add(cert);
    }

    public boolean validateCreationTime(String creationTime) throws XWSSecurityException {
        String disableTSRejection = System.getProperty("Disable.Timestamp.Rejection");
        boolean disableRejection = false;
        if ("true".equalsIgnoreCase(disableTSRejection)) {
            disableRejection = true;
        }
        try {
            Date created;
            try {
                created = calendarFormatter1.parse(creationTime);
            }
            catch (ParseException pe) {
                created = calendarFormatter2.parse(creationTime);
            }
            Date current = this.getFreshnessAndSkewAdjustedDate();
            if (created.before(current)) {
                if (disableRejection) {
                    System.out.println("Invalid creation time detected; no action taken");
                    return true;
                }
                return false;
            }
            Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), true);
            if (currentTime.before(created)) {
                if (disableRejection) {
                    System.out.println("Invalid creation time detected; no action taken");
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        return true;
    }

    public boolean validateExpirationTime(String expirationTime) throws XWSSecurityException {
        if (expirationTime != null) {
            try {
                Date expires;
                try {
                    expires = calendarFormatter1.parse(expirationTime);
                }
                catch (ParseException pe) {
                    expires = calendarFormatter2.parse(expirationTime);
                }
                Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), false);
                if (expires.before(currentTime)) {
                    return false;
                }
            }
            catch (Exception e) {
                throw new XWSSecurityException(e);
            }
        }
        return true;
    }

    public boolean validateAndCacheNonce(String nonce, String created) {
        return false;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public PublicKey getPublicKey(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getMatchingCertificate(serialNumber, issuerName).getPublicKey();
    }

    public PublicKey getPublicKey(String keyIdentifier) throws XWSSecurityException {
        try {
            return this.getMatchingCertificate(this.getDecodedBase64EncodedData(keyIdentifier)).getPublicKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PublicKey getPublicKey(byte[] keyIdentifier) throws XWSSecurityException {
        try {
            return this.getMatchingCertificate(keyIdentifier).getPublicKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    private byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }

    public X509Certificate getCertificate(BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getMatchingCertificate(serialNumber, issuerName);
    }

    public X509Certificate getCertificate(String keyIdentifier) throws XWSSecurityException {
        try {
            byte[] decoded = this.getDecodedBase64EncodedData(keyIdentifier);
            return this.getMatchingCertificate(decoded);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(PublicKey publicKey) {
        return null;
    }

    public X509Certificate getCertificate(byte[] ski) {
        return null;
    }

    public X509Certificate getCertificate(PublicKey publicKey) throws XWSSecurityException {
        return null;
    }

    public boolean validateSamlIssuer(String issuer) {
        return true;
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        return true;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    private Date getFreshnessAndSkewAdjustedDate() throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - this.MAX_CLOCK_SKEW - this.TIMESTAMP_FRESHNESS_LIMIT;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private Date getGMTDateWithSkewAdjusted(Calendar c, boolean addSkew) {
        long offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)c.getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += this.MAX_CLOCK_SKEW) : (currentTime -= this.MAX_CLOCK_SKEW);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    public String getUsername() throws XWSSecurityException {
        return null;
    }

    public String getPassword() throws XWSSecurityException {
        return null;
    }

    public Properties getPrefixNamespaceMappings() throws XWSSecurityException {
        return null;
    }
}

