/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonceCache
extends TimerTask {
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    private Hashtable nonceCache = new Hashtable();
    private Hashtable oldNonceCache = new Hashtable();
    private boolean scheduledFlag = false;
    private boolean canceledFlag = false;

    public boolean validateAndCacheNonce(String nonce, String created) {
        if (this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce)) {
            log.log(Level.FINE, "Nonce  Cache already contains the new Nonce Value received, ERROR...." + this);
            return false;
        }
        log.log(Level.FINE, "Storing Nonce Value " + nonce + " into " + this);
        this.nonceCache.put(nonce, created);
        return true;
    }

    public boolean isScheduled() {
        return this.scheduledFlag;
    }

    public void scheduled(boolean flag) {
        this.scheduledFlag = flag;
    }

    public boolean wasCanceled() {
        return this.canceledFlag;
    }

    public void run() {
        if (this.nonceCache.size() == 0) {
            boolean canceled = this.cancel();
            log.log(Level.FINE, "Canceled Timer Task due to inactivity ...for " + this);
            return;
        }
        log.log(Level.FINE, "Clearing old Nonce values...for " + this);
        this.oldNonceCache.clear();
        Hashtable temp = this.nonceCache;
        this.nonceCache = this.oldNonceCache;
        this.oldNonceCache = temp;
    }

    public boolean cancel() {
        boolean ret = super.cancel();
        this.canceledFlag = true;
        return ret;
    }
}

