/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TeeFilter
extends FilterBase
implements MessageFilter {
    private static final String prettyPrintStylesheet = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:wsse='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'\n  version='1.0'>\n  <xsl:output method='xml' indent='yes'/>\n  <xsl:strip-space elements='*'/>\n  <xsl:template match='/'>\n    <xsl:apply-templates/>\n  </xsl:template>\n  <xsl:template match='node() | @*'>\n    <xsl:choose>\n      <xsl:when test='contains(name(current()), \"wsse:Password\")'>\n        <wsse:Password>****</wsse:Password>\n      </xsl:when>\n      <xsl:otherwise>\n        <xsl:copy>\n          <xsl:apply-templates select='node() | @*'/>\n        </xsl:copy>\n      </xsl:otherwise>\n    </xsl:choose>\n  </xsl:template>\n</xsl:stylesheet>\n";
    private OutputStream out;
    private Templates templates;

    public TeeFilter(OutputStream out, Source stylesheet) throws XWSSecurityException {
        this.init(out, stylesheet);
    }

    public TeeFilter(OutputStream out, boolean prettyPrint) throws XWSSecurityException {
        if (prettyPrint) {
            this.init(out, this.getPrettyPrintStylesheet());
        } else {
            this.init(out, null);
        }
    }

    public TeeFilter(OutputStream out) throws XWSSecurityException {
        this.init(out, null);
    }

    public TeeFilter() throws XWSSecurityException {
        this.init(null, null);
    }

    private void init(OutputStream out, Source stylesheet) throws XWSSecurityException {
        this.out = out;
        if (stylesheet == null) {
            this.templates = null;
        } else {
            TransformerFactoryImpl tf = new TransformerFactoryImpl();
            try {
                this.templates = ((TransformerFactory)tf).newTemplates(stylesheet);
            }
            catch (TransformerConfigurationException e) {
                log.log(Level.SEVERE, "WSS0147.unableto.use.stylesheet", new Object[]{e.getMessage()});
                throw new XWSSecurityException("Unable to use stylesheet", e);
            }
        }
    }

    private Source getPrettyPrintStylesheet() {
        byte[] xsltBytes = prettyPrintStylesheet.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(xsltBytes);
        StreamSource stylesheetSource = new StreamSource(bais);
        return stylesheetSource;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (this.out == null) {
            return;
        }
        try {
            Transformer transformer = this.templates == null ? new TransformerFactoryImpl().newTransformer() : this.templates.newTransformer();
            Source msgSource = secureMessage.getSOAPPart().getContent();
            transformer.transform(msgSource, new StreamResult(this.out));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSS0148.unableto.process.soapmessage", new Object[]{ex.getMessage()});
            throw new XWSSecurityException("Unable to process SOAPMessage", ex);
        }
    }
}

