/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.AllowEncryption;
import com.sun.xml.wss.configuration.AllowSignature;
import com.sun.xml.wss.configuration.DecryptRequirement;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.UsernamePasswordRequirement;
import com.sun.xml.wss.configuration.VerifyRequirement;
import com.sun.xml.wss.filter.FilterBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXRPCSecurityFilter
extends FilterBase
implements ExtendedMessageFilter {
    int currentIdx = 0;
    SecurityRequirements receiverRequirements;
    private static final String alwSigClsName = "com.sun.xml.wss.configuration.AllowSignature";
    private static final String alwEncClsName = "com.sun.xml.wss.configuration.AllowEncryption";
    private static final String sigReqClsName = "com.sun.xml.wss.configuration.VerifyRequirement";
    private static final String encReqClsName = "com.sun.xml.wss.configuration.DecryptRequirement";
    private static final String upwReqClsName = "com.sun.xml.wss.configuration.UsernamePasswordRequirement";

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        this.currentIdx = 0;
        if (this.receiverRequirements != null) {
            Iterator i = this.receiverRequirements.iterator();
            while (i.hasNext()) {
                SecurityRequirement requirement = (SecurityRequirement)i.next();
                if (requirement.getClass().getName().equals(upwReqClsName)) {
                    this.verifyUsernameTokenReferences(requirement, secureMessage);
                    continue;
                }
                if (requirement.getClass().getName().equals(sigReqClsName)) {
                    this.verifySignatureReferences(requirement, secureMessage, true);
                    continue;
                }
                if (requirement.getClass().getName().equals(encReqClsName)) {
                    this.verifyEncryptionReferences(requirement, secureMessage, true);
                    continue;
                }
                if (requirement.getClass().getName().equals(alwSigClsName)) {
                    this.verifySignatureReferences(requirement, secureMessage, false);
                    continue;
                }
                if (!requirement.getClass().getName().equals(alwEncClsName)) continue;
                this.verifyEncryptionReferences(requirement, secureMessage, false);
            }
            if (this.currentIdx != secureMessage.getOperationsLog().size()) {
                throw new PolicyViolationException("Message does not strictly conform to the requirements");
            }
        }
    }

    private void verifyUsernameTokenReferences(SecurityRequirement sReq, SecurableSoapMessage ssm) throws XWSSecurityException {
        boolean reqForNonceMet = false;
        boolean reqForPwdDigestMet = false;
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            throw new PolicyViolationException("Expected wsse:UsernameToken not found");
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 2) {
            throw new PolicyViolationException("Expected wsse:UsernameToken not found");
        }
        Set references = item.getReferences();
        UsernamePasswordRequirement upReq = (UsernamePasswordRequirement)sReq;
        UsernamePasswordRequirement lgReq = (UsernamePasswordRequirement)references.toArray()[0];
        reqForNonceMet = upReq.getNonceRequired() == lgReq.getNonceRequired();
        boolean bl = reqForPwdDigestMet = upReq.getPasswordDigestRequired() == lgReq.getPasswordDigestRequired();
        if (!reqForNonceMet) {
            log.log(Level.SEVERE, "WSS0213.policy.violation.exception");
            throw new PolicyViolationException("Receiver Requirement for nonce has not been met");
        }
        if (!reqForPwdDigestMet) {
            log.log(Level.SEVERE, "WSS0212.policy.violation.exception");
            throw new PolicyViolationException("Receiver Requirement for Digested Password has not been met");
        }
    }

    private void verifySignatureReferences(SecurityRequirement sReq, SecurableSoapMessage ssm, boolean strict) throws XWSSecurityException {
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            if (strict) {
                throw new PolicyViolationException("Expected ds:Signature element not found");
            }
            return;
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 0) {
            if (strict) {
                throw new PolicyViolationException("Expected ds:Signature element not found");
            }
            --this.currentIdx;
            return;
        }
        ArrayList neededList = strict ? ((VerifyRequirement)sReq).getTargets() : ((AllowSignature)sReq).getTargets();
        try {
            this.validateReferences(ssm, neededList, item.getReferences(), true);
        }
        catch (PolicyViolationException pve) {
            if (strict) {
                throw pve;
            }
            --this.currentIdx;
        }
    }

    private void verifyEncryptionReferences(SecurityRequirement sReq, SecurableSoapMessage ssm, boolean strict) throws XWSSecurityException {
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            if (strict) {
                throw new PolicyViolationException("Expected xenc:Encryption element not found");
            }
            return;
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 1) {
            if (strict) {
                throw new PolicyViolationException("Expected xenc:Encryption element not found");
            }
            --this.currentIdx;
            return;
        }
        ArrayList neededList = strict ? ((DecryptRequirement)sReq).getTargets() : ((AllowEncryption)sReq).getTargets();
        try {
            this.validateReferences(ssm, neededList, item.getReferences(), false);
        }
        catch (PolicyViolationException pve) {
            if (strict) {
                throw pve;
            }
            --this.currentIdx;
        }
    }

    private void validateReferences(SecurableSoapMessage ssm, ArrayList neededList, Set log, boolean isSignature) throws XWSSecurityException {
        int validateReferences = 0;
        Iterator i = neededList.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            validateReferences += this.validateReference(ssm, target, log, isSignature);
        }
        if (validateReferences != log.size()) {
            throw new PolicyViolationException("Not all requirements for " + (isSignature ? "signature " : "encryption ") + "have been met");
        }
    }

    private int validateReference(SecurableSoapMessage ssm, Target target, Set log, boolean isSignature) throws XWSSecurityException {
        int validateReferences = 0;
        String type = target.getType();
        String value = target.getValue();
        if (type.equals("qname")) {
            String xpath = XMLUtil.convertToXpath(value);
            NodeList targetsToCheckFor = null;
            try {
                targetsToCheckFor = XPathAPI.selectNodeList((Node)ssm.getSOAPPart(), xpath, ssm.getNSContext());
            }
            catch (TransformerException e) {
                throw new XWSSecurityRuntimeException(e);
            }
            if (targetsToCheckFor == null || targetsToCheckFor.getLength() == 0) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            this.verify(ssm, this.convertToArrayList(targetsToCheckFor), log, isSignature);
            validateReferences = targetsToCheckFor.getLength();
        } else if (type.equals("xpath")) {
            NodeList targetsToCheckFor = null;
            try {
                targetsToCheckFor = XPathAPI.selectNodeList((Node)ssm.getSOAPPart(), value, ssm.getNSContext());
            }
            catch (TransformerException e) {
                throw new XWSSecurityRuntimeException(e);
            }
            if (targetsToCheckFor == null || targetsToCheckFor.getLength() == 0) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            this.verify(ssm, this.convertToArrayList(targetsToCheckFor), log, isSignature);
            validateReferences = targetsToCheckFor.getLength();
        } else if (type.equals("uri")) {
            Element refElem = ssm.getElementById(value);
            if (refElem == null) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            ArrayList<Element> targetsToCheckFor = new ArrayList<Element>();
            targetsToCheckFor.add(refElem);
            this.verify(ssm, targetsToCheckFor, log, isSignature);
            ++validateReferences;
        }
        return validateReferences;
    }

    public void setReceiverRequirements(SecurityRequirements receiverRequirements) {
        if (!receiverRequirements.isEmpty()) {
            this.receiverRequirements = receiverRequirements;
        }
    }

    private void verify(SecurableSoapMessage ssm, ArrayList required, Set log, boolean isSignature) throws XWSSecurityException {
        Node refElem = null;
        Iterator it = required.iterator();
        while (it.hasNext()) {
            refElem = (Node)it.next();
            if (log.contains(refElem)) continue;
            String errorString = null;
            try {
                errorString = "Target for " + (isSignature ? "signature: " : "encryption: ") + XMLUtil.resolveXPath(refElem) + " does not meet the requirement";
            }
            catch (Exception e) {
                throw new XWSSecurityRuntimeException(e);
            }
            throw new PolicyViolationException(errorString);
        }
    }

    private ArrayList convertToArrayList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
        }
        return result;
    }

    public void setReceiverRequirement(SecurityRequirement requirement) throws UnsupportedOperationException {
        log.log(Level.SEVERE, "WSS0207.unsupported.operation.exception");
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void enableOperationsLog(boolean enable) throws UnsupportedOperationException {
        log.log(Level.SEVERE, "WSS0207.unsupported.operation.exception");
        throw new UnsupportedOperationException("Operation not supported");
    }
}

