/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.security.encryption.XMLCipher;
import com.sun.org.apache.xml.security.encryption.XMLEncryptionException;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.ReferenceListHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.WssSoapFaultException;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.KeyResolver;
import java.security.PrivateKey;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class ImportEncryptedKeyFilter
extends FilterBase
implements MessageFilter {
    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        SOAPElement xencEncryptedKey = wsseSecurity.getCurrentHeaderBlockElement();
        if (!xencEncryptedKey.getLocalName().equals("EncryptedKey") || !XMLUtil.inEncryptionNS(xencEncryptedKey)) {
            log.log(Level.SEVERE, "WSS0209.unexpected.header.block", new Object[]{"xenc:EncryptedKey", xencEncryptedKey.getTagName()});
            throw new XWSSecurityException("Expected EncryptedKey, found " + xencEncryptedKey.getTagName());
        }
        xencEncryptedKey.normalize();
        this.decrypt(xencEncryptedKey, secureMessage);
    }

    private void decrypt(SOAPElement xencEncryptedKey, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        try {
            SecretKey symmetricKey;
            XMLCipher xmlCipher = XMLCipher.getInstance();
            EncryptedKey encryptedKey = xmlCipher.loadEncryptedKey((Element)xencEncryptedKey);
            String encryptionAlgorithm = encryptedKey.getEncryptionMethod().getAlgorithm();
            if (!"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptionAlgorithm) && !"http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encryptionAlgorithm)) {
                log.log(Level.SEVERE, "WSS0210.unsupported.key.encryption.algorithm", encryptionAlgorithm);
                XWSSecurityException xwsse = new XWSSecurityException("Expected http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p or http://www.w3.org/2001/04/xmlenc#rsa-1_5 for key encryption, found " + encryptionAlgorithm);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, xwsse.getMessage(), xwsse);
            }
            KeyInfoHeaderBlock keyInfo = new KeyInfoHeaderBlock(encryptedKey.getKeyInfo());
            PrivateKey key = (PrivateKey)KeyResolver.getKey(keyInfo, false, secureMessage);
            xmlCipher.init(4, key);
            try {
                symmetricKey = (SecretKey)xmlCipher.decryptKey(encryptedKey, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            }
            catch (XMLEncryptionException xmlee) {
                log.log(Level.SEVERE, "WSS0211.error.decrypting.key");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Decryption of key encryption key failed", xmlee);
            }
            secureMessage.setFilterParameter("SymmetricKey", symmetricKey);
            SOAPElement refListSoapElement = (SOAPElement)xencEncryptedKey.getChildElements(SOAPFactory.newInstance().createName("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#")).next();
            ReferenceListHeaderBlock referenceListBlock = new ReferenceListHeaderBlock(refListSoapElement);
            secureMessage.setFilterParameter("ReferenceList", referenceListBlock);
        }
        catch (WssSoapFaultException wssSfe) {
            throw wssSfe;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
            throw new XWSSecurityException(e);
        }
    }
}

