/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.WssSoapFaultException;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.AllowEncryption;
import com.sun.xml.wss.configuration.AllowSignature;
import com.sun.xml.wss.configuration.DecryptRequirement;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.UsernamePasswordRequirement;
import com.sun.xml.wss.configuration.VerifyRequirement;
import com.sun.xml.wss.filter.DecryptReferenceListFilter;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.filter.ImportCertificateTokenFilter;
import com.sun.xml.wss.filter.ImportEncryptedKeyFilter;
import com.sun.xml.wss.filter.ImportReferenceListFilter;
import com.sun.xml.wss.filter.ImportTimestampFilter;
import com.sun.xml.wss.filter.ImportUsernameTokenFilter;
import com.sun.xml.wss.filter.SignFilter;
import com.sun.xml.wss.filter.VerifyFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedProcessSecurityHeaderFilter
extends FilterBase
implements ExtendedMessageFilter {
    int currentIdx;
    int idxToReqLst;
    SecurityHeader securityHeader;
    SecurityRequirements receiverRequirements = null;
    SecurityRequirement currentSecurityRequirement = null;
    private boolean lazy = false;
    private boolean enableLogging = false;
    private boolean processHeader = true;
    private boolean reqsSpecified = false;
    private boolean isTimestampFound = false;
    private SOAPElement currentHeaderElement = null;
    private SignFilter signFilter;
    private VerifyFilter verifyFilter;
    private ImportTimestampFilter importTimestampFilter;
    private ImportEncryptedKeyFilter importEncKeyFilter;
    private ImportReferenceListFilter importRefListFilter;
    private DecryptReferenceListFilter decryptRefListFilter;
    private ImportCertificateTokenFilter importCertTokenFilter;
    private ImportUsernameTokenFilter importUsernameTokenFilter;
    private static final String alwSigClsName = "com.sun.xml.wss.configuration.AllowSignature";
    private static final String alwEncClsName = "com.sun.xml.wss.configuration.AllowEncryption";
    private static final String sigReqClsName = "com.sun.xml.wss.configuration.VerifyRequirement";
    private static final String encReqClsName = "com.sun.xml.wss.configuration.DecryptRequirement";
    private static final String upwReqClsName = "com.sun.xml.wss.configuration.UsernamePasswordRequirement";

    public ExtendedProcessSecurityHeaderFilter() {
    }

    public ExtendedProcessSecurityHeaderFilter(SecurityRequirements requirements) {
        this.setReceiverRequirements(requirements);
    }

    public synchronized void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (this.lazy) {
            this.processingHook_lazy(secureMessage);
        } else {
            if (!this.preProcessingHook(secureMessage)) {
                return;
            }
            this.processingHook(secureMessage);
            this.postProcessingHook();
        }
    }

    public void processingHook_lazy(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        this.currentIdx = 0;
        if (this.receiverRequirements != null) {
            Iterator i = this.receiverRequirements.iterator();
            while (i.hasNext()) {
                SecurityRequirement requirement = (SecurityRequirement)i.next();
                if (requirement.getClass().getName().equals(upwReqClsName)) {
                    this.verifyUsernameTokenReferences(requirement, secureMessage);
                    continue;
                }
                if (requirement.getClass().getName().equals(sigReqClsName)) {
                    this.verifySignatureReferences(requirement, secureMessage, true);
                    continue;
                }
                if (requirement.getClass().getName().equals(encReqClsName)) {
                    this.verifyEncryptionReferences(requirement, secureMessage, true);
                    continue;
                }
                if (requirement.getClass().getName().equals(alwSigClsName)) {
                    this.verifySignatureReferences(requirement, secureMessage, false);
                    continue;
                }
                if (!requirement.getClass().getName().equals(alwEncClsName)) continue;
                this.verifyEncryptionReferences(requirement, secureMessage, false);
            }
            if (this.currentIdx != secureMessage.getOperationsLog().size()) {
                throw new PolicyViolationException("Message does not strictly conform to the policy");
            }
        }
    }

    private void verifyUsernameTokenReferences(SecurityRequirement sReq, SecurableSoapMessage ssm) throws XWSSecurityException {
        boolean reqForNonceMet = false;
        boolean reqForPwdDigestMet = false;
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            throw new PolicyViolationException("Expected wsse:UsernameToken not found");
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 2) {
            throw new PolicyViolationException("Expected wsse:UsernameToken not found");
        }
        Set references = item.getReferences();
        UsernamePasswordRequirement upReq = (UsernamePasswordRequirement)sReq;
        UsernamePasswordRequirement lgReq = (UsernamePasswordRequirement)references.toArray()[0];
        reqForNonceMet = upReq.getNonceRequired() == lgReq.getNonceRequired();
        boolean bl = reqForPwdDigestMet = upReq.getPasswordDigestRequired() == lgReq.getPasswordDigestRequired();
        if (!reqForNonceMet) {
            log.log(Level.SEVERE, "WSS0213.policy.violation.exception");
            throw new PolicyViolationException("Receiver Requirement for nonce has not been met");
        }
        if (!reqForPwdDigestMet) {
            log.log(Level.SEVERE, "WSS0212.policy.violation.exception");
            throw new PolicyViolationException("Receiver Requirement for Digested Password has not been met");
        }
    }

    private void verifySignatureReferences(SecurityRequirement sReq, SecurableSoapMessage ssm, boolean strict) throws XWSSecurityException {
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            if (strict) {
                throw new PolicyViolationException("Expected ds:Signature element not found");
            }
            return;
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 0) {
            if (strict) {
                throw new PolicyViolationException("Expected ds:Signature element not found");
            }
            --this.currentIdx;
            return;
        }
        ArrayList neededList = strict ? ((VerifyRequirement)sReq).getTargets() : ((AllowSignature)sReq).getTargets();
        try {
            this.validateReferences(ssm, neededList, this.modifiableSet(item.getReferences()), true);
        }
        catch (PolicyViolationException pve) {
            if (strict) {
                throw pve;
            }
            --this.currentIdx;
        }
    }

    private void verifyEncryptionReferences(SecurityRequirement sReq, SecurableSoapMessage ssm, boolean strict) throws XWSSecurityException {
        if (ssm.getOperationsLog().size() == this.currentIdx) {
            if (strict) {
                throw new PolicyViolationException("Expected xenc:Encryption element not found");
            }
            return;
        }
        SecurableSoapMessage.OperationsLogItem item = (SecurableSoapMessage.OperationsLogItem)ssm.getOperationsLog().get(this.currentIdx++);
        if (item.getType() != 1) {
            if (strict) {
                throw new PolicyViolationException("Expected xenc:Encryption element not found");
            }
            --this.currentIdx;
            return;
        }
        ArrayList neededList = strict ? ((DecryptRequirement)sReq).getTargets() : ((AllowEncryption)sReq).getTargets();
        try {
            this.validateReferences(ssm, neededList, this.modifiableSet(item.getReferences()), false);
        }
        catch (PolicyViolationException pve) {
            if (strict) {
                throw pve;
            }
            --this.currentIdx;
        }
    }

    private Set modifiableSet(Set set) {
        HashSet mset = new HashSet(set.size());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            mset.add(i.next());
        }
        return mset;
    }

    private void validateReferences(SecurableSoapMessage ssm, ArrayList neededList, Set log, boolean isSignature) throws XWSSecurityException {
        int validateReferences = 0;
        Iterator i = neededList.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            validateReferences += this.validateReference(ssm, target, log, isSignature);
        }
        ArrayList optionals = this.receiverRequirements.getOptionalTargets();
        if (optionals != null && !this.verifyOptionalTargets(ssm, this.receiverRequirements.getOptionalTargets(), log)) {
            throw new PolicyViolationException("More elements " + (isSignature ? "signed " : "encrypted ") + "than required and allowed");
        }
    }

    private boolean verifyOptionalTargets(SecurableSoapMessage ssm, ArrayList targets, Set log) throws XWSSecurityException {
        HashSet<Node> set = new HashSet<Node>();
        Iterator i = targets.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            if (target.getType().equals("uri")) {
                set.add((Node)ssm.getMessageParts(target));
                continue;
            }
            NodeList nlist = (NodeList)ssm.getMessageParts(target);
            for (int j = 0; j < nlist.getLength(); ++j) {
                set.add(nlist.item(j));
            }
        }
        return set.equals(log);
    }

    private int validateReference(SecurableSoapMessage ssm, Target target, Set log, boolean isSignature) throws XWSSecurityException {
        int validateReferences = 0;
        String type = target.getType();
        String value = target.getValue();
        if (type.equals("qname")) {
            NodeList targetsToCheckFor = (NodeList)ssm.getMessageParts(target);
            if (targetsToCheckFor == null || targetsToCheckFor.getLength() == 0) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            this.verify(ssm, this.convertToArrayList(targetsToCheckFor), log, isSignature);
            validateReferences = targetsToCheckFor.getLength();
        } else if (type.equals("xpath")) {
            NodeList targetsToCheckFor = (NodeList)ssm.getMessageParts(target);
            if (targetsToCheckFor == null || targetsToCheckFor.getLength() == 0) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            this.verify(ssm, this.convertToArrayList(targetsToCheckFor), log, isSignature);
            validateReferences = targetsToCheckFor.getLength();
        } else if (type.equals("uri")) {
            Element refElem = ssm.getElementById(value);
            if (refElem == null) {
                throw new PolicyViolationException("Target for " + (isSignature ? "signature: " : "encryption: ") + value + " does not meet the requirement");
            }
            ArrayList<Element> targetsToCheckFor = new ArrayList<Element>();
            targetsToCheckFor.add(refElem);
            this.verify(ssm, targetsToCheckFor, log, isSignature);
            ++validateReferences;
        }
        return validateReferences;
    }

    private void verify(SecurableSoapMessage ssm, ArrayList required, Set log, boolean isSignature) throws XWSSecurityException {
        Node refElem = null;
        Iterator it = required.iterator();
        while (it.hasNext()) {
            refElem = (Node)it.next();
            if (!log.contains(refElem)) {
                String errorString = null;
                try {
                    errorString = "Target for " + (isSignature ? "signature: " : "encryption: ") + XMLUtil.resolveXPath(refElem) + " does not meet the requirement";
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
                throw new PolicyViolationException(errorString);
            }
            log.remove(refElem);
        }
    }

    private ArrayList convertToArrayList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
        }
        return result;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setReceiverRequirements(SecurityRequirements receiverRequirements) {
        if (receiverRequirements != null && !receiverRequirements.isEmpty()) {
            this.reqsSpecified = true;
            this.receiverRequirements = receiverRequirements;
        }
    }

    public void setReceiverRequirement(SecurityRequirement requirement) throws UnsupportedOperationException {
        log.log(Level.SEVERE, "WSS0207.unsupported.operation.exception");
        throw new UnsupportedOperationException("Operation not supported");
    }

    private SecurityRequirement getCurrentSecurityRequirement() throws PolicyViolationException {
        try {
            this.currentSecurityRequirement = (SecurityRequirement)this.receiverRequirements.get(this.idxToReqLst++);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0208.policy.violation.exception");
            throw new PolicyViolationException("Additional Security found than required in the message");
        }
        return this.currentSecurityRequirement;
    }

    private SOAPElement getNextHeaderElement() {
        if (this.currentHeaderElement == null) {
            this.currentHeaderElement = this.securityHeader.getFirstChildElement();
        } else {
            Node nextChild;
            for (nextChild = this.currentHeaderElement.getNextSibling(); !(nextChild instanceof SOAPElement) && null != nextChild; nextChild = nextChild.getNextSibling()) {
            }
            this.currentHeaderElement = (SOAPElement)nextChild;
        }
        return this.currentHeaderElement;
    }

    private SOAPElement getPreviousHeaderElement() throws XWSSecurityException {
        Node prevSibling;
        for (prevSibling = this.currentHeaderElement.getPreviousSibling(); prevSibling != null && !(prevSibling instanceof SOAPElement); prevSibling = prevSibling.getPreviousSibling()) {
        }
        this.currentHeaderElement = (SOAPElement)prevSibling;
        return this.currentHeaderElement;
    }

    public void enableOperationsLog(boolean log) {
        this.enableLogging = log;
    }

    private void resetState() {
        this.idxToReqLst = 0;
        this.currentHeaderElement = null;
        this.processHeader = true;
        this.isTimestampFound = false;
    }

    private void throwWssSoapFault() throws WssSoapFaultException {
        log.log(Level.SEVERE, "WSS0204.illegal.header.block", this.currentHeaderElement.getLocalName());
        XWSSecurityException xwsse = new XWSSecurityException("Unrecognized header block: " + this.currentHeaderElement.getTagName());
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, xwsse.getMessage(), xwsse);
    }

    private boolean getSecurityHeader(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        this.securityHeader = secureMessage.findSecurityHeader();
        if (null == this.securityHeader) {
            if (this.reqsSpecified) {
                log.log(Level.SEVERE, "WSS0202.missing.security.header");
                throw new XWSSecurityException("Message does not contain wsse:Security Header");
            }
            log.log(Level.WARNING, "WSS0202.missing.security.header");
            return false;
        }
        return true;
    }

    private boolean preProcessingHook(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (!this.getSecurityHeader(secureMessage)) {
            return false;
        }
        this.resetState();
        return true;
    }

    private void processingHook(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        while (this.getNextHeaderElement() != null) {
            String elementName = this.currentHeaderElement.getLocalName();
            if ("BinarySecurityToken".equals(elementName)) {
                this.processBinarySecurityToken(secureMessage);
                continue;
            }
            if ("UsernameToken".equals(elementName)) {
                this.processUsernameToken(secureMessage);
                continue;
            }
            if ("Timestamp".equals(elementName)) {
                this.processTimestamp(secureMessage);
                continue;
            }
            if ("Signature".equals(elementName)) {
                this.processSignatureHeader(secureMessage);
                continue;
            }
            if ("EncryptedKey".equals(elementName)) {
                this.processEncryptionHeader(secureMessage, true);
                continue;
            }
            if ("ReferenceList".equals(elementName)) {
                this.processEncryptionHeader(secureMessage, false);
                continue;
            }
            this.throwWssSoapFault();
        }
    }

    private void postProcessingHook() throws XWSSecurityException {
        if (this.reqsSpecified) {
            if (this.receiverRequirements.isTimestampRequired() && !this.isTimestampFound) {
                log.log(Level.SEVERE, "WSS0205.policy.violation.exception");
                throw new PolicyViolationException("wsu:Timestamp element not found in message");
            }
            int size = this.receiverRequirements.size();
            if (this.idxToReqLst != size) {
                while (this.getCurrentSecurityRequirement() != null) {
                    boolean isAS = this.currentSecurityRequirement instanceof AllowSignature;
                    boolean isAE = this.currentSecurityRequirement instanceof AllowEncryption;
                    if (!isAS && !isAE) break;
                    if (this.idxToReqLst != size) continue;
                    return;
                }
                log.log(Level.SEVERE, "WSS0206.policy.violation.exception");
                throw new PolicyViolationException("Not all Security Requirements are met");
            }
        }
    }

    private void processTimestamp(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (this.importTimestampFilter == null) {
            this.importTimestampFilter = new ImportTimestampFilter();
        }
        this.importTimestampFilter.process(secureMessage);
        this.isTimestampFound = true;
    }

    private void processBinarySecurityToken(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (this.importCertTokenFilter == null) {
            this.importCertTokenFilter = new ImportCertificateTokenFilter();
        }
        this.importCertTokenFilter.process(secureMessage);
    }

    private void processUsernameToken(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (this.reqsSpecified) {
            if (!(this.getCurrentSecurityRequirement() instanceof UsernamePasswordRequirement)) {
                log.log(Level.SEVERE, "WSS0203.policy.violation.exception", "wsse:UsernameToken");
                throw new PolicyViolationException("Unexpected wsse:UsernameToken element");
            }
            if (this.importUsernameTokenFilter == null) {
                this.importUsernameTokenFilter = new ImportUsernameTokenFilter(this.currentSecurityRequirement);
            } else {
                this.importUsernameTokenFilter.setReceiverRequirement(this.currentSecurityRequirement);
            }
        } else if (this.importUsernameTokenFilter == null) {
            this.importUsernameTokenFilter = new ImportUsernameTokenFilter();
        }
        this.importUsernameTokenFilter.enableOperationsLog(this.enableLogging);
        this.importUsernameTokenFilter.process(secureMessage);
    }

    private void processSignatureHeader(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        boolean applyOptionals = false;
        if (this.reqsSpecified) {
            while (this.getCurrentSecurityRequirement() instanceof AllowEncryption) {
            }
            applyOptionals = this.currentSecurityRequirement instanceof AllowSignature;
            if (!applyOptionals && !(this.currentSecurityRequirement instanceof VerifyRequirement)) {
                throw new PolicyViolationException("Unexpected ds:Signature element in the header");
            }
            if (this.verifyFilter == null) {
                this.verifyFilter = new VerifyFilter(this.currentSecurityRequirement, this.receiverRequirements.getOptionalTargets());
            } else {
                this.verifyFilter.setReceiverRequirement(this.currentSecurityRequirement);
            }
        } else if (this.verifyFilter == null) {
            this.verifyFilter = new VerifyFilter();
        }
        try {
            this.verifyFilter.enableOperationsLog(this.enableLogging);
            this.verifyFilter.process(secureMessage);
        }
        catch (PolicyViolationException pve) {
            if (applyOptionals) {
                this.securityHeader.setCurrentHeaderElement(this.getPreviousHeaderElement());
            }
            throw pve;
        }
    }

    private void processEncryptionHeader(SecurableSoapMessage secureMessage, boolean isEncryptedKeyHeader) throws XWSSecurityException {
        boolean applyOptionals = false;
        if (this.reqsSpecified) {
            while (this.getCurrentSecurityRequirement() instanceof AllowSignature) {
            }
            applyOptionals = this.currentSecurityRequirement instanceof AllowEncryption;
            if (!applyOptionals && !(this.currentSecurityRequirement instanceof DecryptRequirement)) {
                throw new PolicyViolationException("Unexpected " + (isEncryptedKeyHeader ? "xenc:EncryptedKey " : "xenc:ReferenceList ") + "element in the header");
            }
        }
        if (this.processHeader) {
            if (isEncryptedKeyHeader) {
                if (this.importEncKeyFilter == null) {
                    this.importEncKeyFilter = new ImportEncryptedKeyFilter();
                }
                this.importEncKeyFilter.process(secureMessage);
            } else {
                if (this.importRefListFilter == null) {
                    this.importRefListFilter = new ImportReferenceListFilter();
                }
                this.importRefListFilter.process(secureMessage);
            }
        }
        if (this.reqsSpecified) {
            if (this.decryptRefListFilter == null) {
                this.decryptRefListFilter = new DecryptReferenceListFilter(this.currentSecurityRequirement, this.receiverRequirements.getOptionalTargets());
            } else {
                this.decryptRefListFilter.setReceiverRequirement(this.currentSecurityRequirement);
            }
        } else if (this.decryptRefListFilter == null) {
            this.decryptRefListFilter = new DecryptReferenceListFilter();
        }
        try {
            this.decryptRefListFilter.enableOperationsLog(this.enableLogging);
            this.decryptRefListFilter.process(secureMessage);
            this.processHeader = true;
        }
        catch (PolicyViolationException pve) {
            if (applyOptionals) {
                if (this.processHeader) {
                    this.securityHeader.setCurrentHeaderElement(this.getPreviousHeaderElement());
                    this.processHeader = false;
                } else {
                    this.getPreviousHeaderElement();
                }
            }
            throw pve;
        }
    }
}

