/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.UsernameToken;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportUsernameTokenFilter
extends FilterBase
implements MessageFilter {
    private String wsuId;
    private String configuredUsername;
    private String configuredPassword;
    private boolean genNonceAndCreated = false;
    private boolean digestPassword = false;

    public ExportUsernameTokenFilter(String username, String password, boolean digestPassword) {
        this.configuredUsername = username;
        this.configuredPassword = password;
        this.digestPassword = digestPassword;
    }

    public ExportUsernameTokenFilter(String username, String password) {
        this(username, password, false);
    }

    public ExportUsernameTokenFilter(String username, String password, boolean setNonceAndCreated, boolean digestPassword) {
        this.configuredUsername = username;
        this.configuredPassword = password;
        this.genNonceAndCreated = setNonceAndCreated;
        this.digestPassword = digestPassword;
    }

    public ExportUsernameTokenFilter() {
        this.configuredUsername = null;
        this.configuredPassword = null;
    }

    public void init() throws XWSSecurityException {
        this.wsuId = this.getParameter("wsuId");
        this.configuredUsername = this.getParameter("username");
        this.configuredPassword = this.getParameter("password");
        String genNonceAndCreated = this.getParameter("gennonceandcreated");
        String digestPassword = this.getParameter("digestpassword");
        if (genNonceAndCreated != null) {
            this.genNonceAndCreated = new Boolean(genNonceAndCreated);
        }
        if (digestPassword != null) {
            this.digestPassword = new Boolean(digestPassword);
        }
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        String username;
        String password;
        block6: {
            password = null;
            username = this.configuredUsername != null ? this.configuredUsername : secureMessage.getSecurityEnvironment().getUsername();
            if (username == null) {
                log.log(Level.SEVERE, "WSS0387.error.creating.usernametoken");
                throw new XWSSecurityException("Username has not been set");
            }
            if (this.configuredPassword != null) {
                password = this.configuredPassword;
            }
            if (password == null) {
                try {
                    password = secureMessage.getSecurityEnvironment().getPassword();
                }
                catch (XWSSecurityException xwsse) {
                    if (xwsse.getCause() instanceof UnsupportedCallbackException) break block6;
                    log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"PasswordCallback"});
                    log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", xwsse);
                    throw xwsse;
                }
            }
        }
        SOAPPart soapPart = secureMessage.getSOAPPart();
        UsernameToken token = this.genNonceAndCreated ? new UsernameToken((Document)soapPart, username, password, true, true, this.digestPassword) : new UsernameToken((Document)soapPart, username, password, this.digestPassword);
        SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
        if (this.wsuId != null && !this.wsuId.equals("")) {
            XMLUtil.setWsuIdAttr((Element)token.getAsSoapElement(), this.wsuId);
        }
        wsseSecurity.insertHeaderBlock(token);
    }
}

