/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.Timestamp;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;

public class ExportTimestampFilter
extends FilterBase
implements MessageFilter {
    private String created;
    private String expires;
    private String timeout;

    public ExportTimestampFilter() {
    }

    public ExportTimestampFilter(String created) throws XWSSecurityException {
        this(created, null);
    }

    public ExportTimestampFilter(String created, String expires) throws XWSSecurityException {
        if (created == null) {
            log.log(Level.SEVERE, "WSS0199.null.creation.time");
            throw new XWSSecurityException("Created value should not be null");
        }
        this.created = created;
        this.expires = expires;
    }

    public void init() throws XWSSecurityException {
        this.timeout = this.getParameter("timeout");
    }

    public void process(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        SecurityHeader secHeader = secureMsg.findOrCreateSecurityHeader();
        Timestamp wsuTimestamp = new Timestamp();
        wsuTimestamp.setCreated(this.created);
        wsuTimestamp.setTimeout(this.timeout);
        wsuTimestamp.setExpires(this.expires);
        secHeader.insertHeaderBlock(wsuTimestamp);
    }
}

