/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;

public class ExportSignatureFilter
extends FilterBase
implements MessageFilter {
    private String algorithm;
    private String x509TokenId;

    private ExportSignatureFilter(KeyInfoStrategy keyInfoStrategy, String algorithm) throws XWSSecurityException {
        if (null == keyInfoStrategy) {
            log.log(Level.SEVERE, "WSS0197.keyinfostrategy.null");
            throw new XWSSecurityException("KeyInfoStrategy should not be null");
        }
        this.keyInfoStrategy = keyInfoStrategy;
        this.algorithm = algorithm;
    }

    public ExportSignatureFilter() throws XWSSecurityException {
    }

    public ExportSignatureFilter(KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        this(keyInfoStrategy, "RSA");
    }

    public void init() throws XWSSecurityException {
        this.algorithm = this.getParameter("algorithm");
        if (this.algorithm == null) {
            this.algorithm = "RSA";
        }
        if (this.getParameter("x509TokenId") != null) {
            this.x509TokenId = this.getParameter("x509TokenId");
        }
        if (this.keyInfoStrategy == null) {
            log.log(Level.SEVERE, "WSS0185.filterparameter.not.set", new Object[]{"keyinfostrategy"});
            throw new XWSSecurityException("filter parameter 'keyinfostrategy' was not set");
        }
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SOAPPart soapPart = secureMessage.getSOAPPart();
        String signMethod = null;
        if (!this.algorithm.equalsIgnoreCase("RSA")) {
            log.log(Level.SEVERE, "WSS0198.unsupported.signature.algorithm", signMethod);
            throw new XWSSecurityException("Unsupported Sign Algorithm: " + this.algorithm);
        }
        signMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        SignatureHeaderBlock sigBlock = new SignatureHeaderBlock((Document)soapPart, signMethod);
        KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
        String alias = this.keyInfoStrategy.getAlias();
        this.keyInfoStrategy.setCertificate(secureMessage.getSecurityEnvironment().getCertificate(alias, true));
        this.keyInfoStrategy.insertKey(keyInfoBlock, secureMessage, this.x509TokenId);
        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(sigBlock);
        secureMessage.setFilterParameter("Signature", sigBlock);
        secureMessage.setFilterParameter("KeyInfoStrategy", this.keyInfoStrategy);
    }
}

