/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;

public class ExportSecurityTokenReferenceFilter
extends FilterBase
implements MessageFilter {
    private KeyInfoStrategy strategy = null;

    public ExportSecurityTokenReferenceFilter(KeyInfoStrategy strategy) {
        this.strategy = strategy;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
        SecurityTokenReference tokenRef = new SecurityTokenReference();
        tokenRef.setWsuId(secureMessage.generateId());
        this.strategy.insertKey(tokenRef, secureMessage);
        wsseSecurity.insertHeaderBlock(tokenRef);
    }
}

