/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.encryption.XMLCipher;
import com.sun.org.apache.xml.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.EncryptedDataHeaderBlock;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.ReferenceListHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.keyinfo.KeyNameStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptElementFilter
extends FilterBase
implements MessageFilter {
    public EncryptElementFilter(String xpath, boolean encryptContentFlag, KeyInfoStrategy keyInfoStrategy) {
        this.targets = new ArrayList();
        Target target = new Target("xpath", xpath, encryptContentFlag);
        this.targets.add(target);
        this.keyInfoStrategy = keyInfoStrategy;
    }

    public EncryptElementFilter(String xpath, boolean encryptContentFlag) {
        this(xpath, encryptContentFlag, null);
    }

    public EncryptElementFilter(String xpath) {
        this(xpath, true);
    }

    public EncryptElementFilter(ArrayList targets, KeyInfoStrategy keyInfoStrategy) {
        this.targets = targets;
        this.keyInfoStrategy = keyInfoStrategy;
    }

    public EncryptElementFilter(ArrayList targets) {
        this(targets, null);
    }

    public EncryptElementFilter() {
        this.targets = new ArrayList();
        this.targets.add(new Target());
    }

    public void init() throws XWSSecurityException {
    }

    public void process(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        XMLCipher xmlCipher;
        SecretKey symmetricKey = this.getSymmetricKey(secureMsg);
        if (symmetricKey == null) {
            log.log(Level.SEVERE, "WSS0191.symmetrickey.not.set");
            throw new XWSSecurityException("Symmetric key required for encryption is not set");
        }
        try {
            xmlCipher = XMLCipher.getInstance("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            xmlCipher.init(1, symmetricKey);
        }
        catch (XMLEncryptionException xee) {
            log.log(Level.SEVERE, "WSS0134.unableto.initialize.xml.cipher");
            throw new XWSSecurityException("Unable to initialize XML Cipher", xee);
        }
        if (this.targets == null) {
            log.log(Level.SEVERE, "WSS0192.encryption.targets.not.specified");
            throw new XWSSecurityException("No encryption targets specified");
        }
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            String targetType = target.getType();
            String targetValue = target.getValue();
            boolean contentOnly = target.getContentOnly();
            if (targetType.equals("qname")) {
                this.process(xmlCipher, secureMsg, this.convertToXpath(targetValue), contentOnly);
                continue;
            }
            if (targetType.equals("xpath")) {
                this.process(xmlCipher, secureMsg, targetValue, contentOnly);
                continue;
            }
            if (!targetType.equals("uri")) continue;
            Element elem = secureMsg.getElementById(targetValue);
            this.processElement(xmlCipher, (SOAPElement)elem, secureMsg, contentOnly);
        }
    }

    private void process(XMLCipher xmlCipher, SecurableSoapMessage secureMsg, String xpath, boolean contentOnly) throws XWSSecurityException {
        NodeList elemsToEncrypt;
        try {
            elemsToEncrypt = XPathAPI.selectNodeList((Node)secureMsg.getSOAPPart(), xpath, secureMsg.getNSContext());
        }
        catch (TransformerException e) {
            throw new XWSSecurityException(e);
        }
        if (elemsToEncrypt == null || elemsToEncrypt.getLength() == 0) {
            log.log(Level.SEVERE, "WSS0193.invalid.target");
            throw new XWSSecurityException("No element exists with the xpath: " + xpath);
        }
        for (int i = 0; i < elemsToEncrypt.getLength(); ++i) {
            SOAPElement element = (SOAPElement)elemsToEncrypt.item(i);
            this.processElement(xmlCipher, element, secureMsg, contentOnly);
        }
    }

    private void processElement(XMLCipher xmlCipher, SOAPElement element, SecurableSoapMessage ssm, boolean contentOnly) throws XWSSecurityException {
        if (element.getNodeType() != 1) {
            log.log(Level.SEVERE, "WSS0165.unable.to.encrypt");
            throw new XWSSecurityException("XPath does not correspond to a DOM Element");
        }
        if (element.getLocalName().equals("Header") && !contentOnly) {
            log.log(Level.SEVERE, "WSS0194.illegal.target", "SOAP-ENV:Header");
            throw new XWSSecurityException("Encryption of Soap Header is not allowed");
        }
        if (element.getLocalName().equals("Body") && !contentOnly) {
            log.log(Level.SEVERE, "WSS0194.illegal.target", "SOAP-ENV:Body");
            throw new XWSSecurityException("Encryption of Soap Body is not allowed");
        }
        this.encrypt(xmlCipher, element, ssm, contentOnly);
    }

    private void encrypt(XMLCipher xmlCipher, SOAPElement encryptElm, SecurableSoapMessage secureMsg, boolean contentOnly) throws XWSSecurityException {
        Object contextNode;
        SOAPPart soapPart = secureMsg.getSOAPPart();
        Element nsContext = secureMsg.getNSContext();
        Node refNode = null;
        if (contentOnly) {
            contextNode = encryptElm;
        } else {
            contextNode = encryptElm.getParentNode();
            refNode = encryptElm.getNextSibling();
        }
        try {
            xmlCipher.doFinal((Document)soapPart, (Element)encryptElm, contentOnly);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0128.unableto.encrypt.message");
            throw new XWSSecurityException("Unable to encrypt element", e);
        }
        Element xencEncryptedData = contentOnly ? (Element)contextNode.getFirstChild() : (refNode == null ? (Element)contextNode.getLastChild() : (Element)refNode.getPreviousSibling());
        String xencEncryptedDataId = secureMsg.generateId();
        String xencEncryptedDataRef = "#" + xencEncryptedDataId;
        xencEncryptedData.setAttribute("Id", xencEncryptedDataId);
        ReferenceListHeaderBlock referenceListBlock = (ReferenceListHeaderBlock)secureMsg.getFilterParameter("ReferenceList");
        if (referenceListBlock == null) {
            log.log(Level.SEVERE, "WSS0195.referencelist.not.set");
            throw new XWSSecurityException("REFERENCE_LIST filter parameter is not set");
        }
        referenceListBlock.addReference(xencEncryptedDataRef);
        if (this.keyInfoStrategy != null) {
            KeyInfoHeaderBlock keyInfo = new KeyInfoHeaderBlock((Document)soapPart);
            this.keyInfoStrategy.insertKey(keyInfo, secureMsg, null);
            EncryptedDataHeaderBlock encryptedData = new EncryptedDataHeaderBlock(XMLUtil.convertToSoapElement((Document)soapPart, xencEncryptedData));
            encryptedData.setKeyInfo(keyInfo);
            xencEncryptedData.getParentNode().replaceChild((Node)encryptedData.getAsSoapElement(), xencEncryptedData);
        }
    }

    private SecretKey getSymmetricKey(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        if (this.keyInfoStrategy instanceof KeyNameStrategy) {
            SecurityEnvironment secEnv = secureMsg.getSecurityEnvironment();
            if (secEnv == null) {
                log.log(Level.SEVERE, "WSS0196.securityenvironment.not.set");
                throw new XWSSecurityException("Security environment has not been set");
            }
            return secEnv.getSecretKey(((KeyNameStrategy)this.keyInfoStrategy).getKeyName(), true);
        }
        return (SecretKey)secureMsg.getFilterParameter("SymmetricKey");
    }

    private String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }
}

